/*
 * Decompiled with CFR 0.152.
 */
package com.github.anicolaspp.ojai;

import com.github.anicolaspp.ojai.DocumentProjector;
import com.github.anicolaspp.ojai.PathProjector;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.store.Connection;

public class ListProjector
implements PathProjector {
    private Document document;
    private Connection connection;

    public ListProjector(Document document, Connection connection) {
        this.document = document;
        this.connection = connection;
    }

    private Optional<List<Object>> tryGetList(String string) {
        List list = this.document.getList(FieldPath.parseFrom((String)string));
        return Optional.ofNullable(list);
    }

    @Override
    public Document projectPath(String string) {
        String[] stringArray = string.replace("\"", "").split("\\.");
        String string2 = stringArray[0].replace("[]", "");
        return this.tryGetList(string2).map(Collection::stream).map(stream -> this.getEmbeddedDocuments(string, string2, (Stream<Object>)stream)).map(list -> this.getOuterDocument(string2, (List<Document>)list)).orElse(this.connection.newDocument());
    }

    private Document getOuterDocument(String string, List<Document> list) {
        if (list.size() == 0) {
            return this.connection.newDocument();
        }
        return this.connection.newDocument().set(string, list);
    }

    private List<Document> getEmbeddedDocuments(String string, String string2, Stream<Object> stream) {
        return stream.map(object -> this.connection.newDocument(object)).map(document -> {
            String string3 = string.substring(string2.length() + 3);
            if (!string3.isEmpty()) {
                return new DocumentProjector((Document)document, this.connection).projectPath(string3);
            }
            return document;
        }).filter(document -> !document.isEmpty()).collect(Collectors.toList());
    }
}

