/*
 * Decompiled with CFR 0.152.
 */
package com.github.aqiu202.cache.config;

import com.github.aqiu202.cache.anno.EnableTimedCaching;
import com.github.aqiu202.cache.data.str.StringCaffeineCache;
import com.github.aqiu202.cache.data.str.StringGuavaCache;
import com.github.aqiu202.cache.data.str.StringRedisCache;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class TimedCacheConfigRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map map = importingClassMetadata.getAnnotationAttributes(EnableTimedCaching.class.getName(), false);
        if (map == null) {
            return;
        }
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)map);
        long timeout = (Long)attributes.getNumber("timeout");
        TimeUnit timeUnit = (TimeUnit)attributes.getEnum("timeUnit");
        EnableTimedCaching.CacheMode cacheMode = (EnableTimedCaching.CacheMode)attributes.getEnum("cacheMode");
        GenericBeanDefinition b = new GenericBeanDefinition();
        if (EnableTimedCaching.CacheMode.redis.equals((Object)cacheMode)) {
            b.setBeanClass(StringRedisCache.class);
            b.setAutowireCandidate(true);
        } else if (EnableTimedCaching.CacheMode.caffeine.equals((Object)cacheMode)) {
            b.setBeanClass(StringCaffeineCache.class);
        } else if (EnableTimedCaching.CacheMode.guava.equals((Object)cacheMode)) {
            b.setBeanClass(StringGuavaCache.class);
        }
        b.getPropertyValues().add("timeout", (Object)timeout);
        b.getPropertyValues().add("timeUnit", (Object)timeUnit);
        registry.registerBeanDefinition("simpleTimeLimitedStringCache", (BeanDefinition)b);
    }
}

