/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.Slice;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001I4qa\u0003\u0007\u0011\u0002\u0007\u0005Q\u0003C\u0003-\u0001\u0011\u0005Q\u0006C\u00032\u0001\u0019\u0005!\u0007C\u00037\u0001\u0011\u0015q\u0007C\u0003A\u0001\u0011\u0015\u0013\tC\u0003N\u0001\u0011\u0015c\nC\u0003W\u0001\u0011\u0015s\u000bC\u0003_\u0001\u0011\u0015q\fC\u0003f\u0001\u0011\u0015a\rC\u0003j\u0001\u0011\u0015#\u000eC\u0003o\u0001\u0011\u0015qNA\bBeJ\f\u0017PQ;gM\u0016\u0014H*[6f\u0015\tia\"\u0001\bck\u001a4WM]1oINd\u0017nY3\u000b\u0005=\u0001\u0012AC1siV\u0014x\u000e]1mC*\u0011\u0011CE\u0001\u0007O&$\b.\u001e2\u000b\u0003M\t1aY8n\u0007\u0001)\"AF\u0012\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0004=}\tS\"\u0001\u0007\n\u0005\u0001b!A\u0002\"vM\u001a,'\u000f\u0005\u0002#G1\u0001A!\u0002\u0013\u0001\u0005\u0004)#!\u0001+\u0012\u0005\u0019J\u0003C\u0001\r(\u0013\tA\u0013DA\u0004O_RD\u0017N\\4\u0011\u0005aQ\u0013BA\u0016\u001a\u0005\r\te._\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u00039\u0002\"\u0001G\u0018\n\u0005AJ\"\u0001B+oSR\f\u0001#\u001e8eKJd\u00170\u001b8h+:\u001c\u0018MZ3\u0016\u0003M\u00022\u0001\u0007\u001b\"\u0013\t)\u0014DA\u0003BeJ\f\u00170\u0001\u0004va\u0012\fG/\u001a\u000b\u0004qerT\"\u0001\u0001\t\u000bi\u001a\u0001\u0019A\u001e\u0002\u000b%tG-\u001a=\u0011\u0005aa\u0014BA\u001f\u001a\u0005\rIe\u000e\u001e\u0005\u0006\u007f\r\u0001\r!I\u0001\u0006m\u0006dW/Z\u0001\ti>\u001cFO]5oOR\t!\t\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000bfi\u0011A\u0012\u0006\u0003\u000fR\ta\u0001\u0010:p_Rt\u0014BA%\u001a\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%K\u0012aC5og\u0016\u0014H/\u0011:sCf$R\u0001O(Q%RCQAO\u0003A\u0002mBQ!U\u0003A\u0002m\n1b]8ve\u000e,\u0017J\u001c3fq\")1+\u0002a\u0001w\u0005a\u0011N\\:feRdUM\\4uQ\")Q+\u0002a\u0001g\u0005Y1o\\;sG\u0016\f%O]1z\u0003-Ign]3siNc\u0017nY3\u0015\u0007aB\u0016\fC\u0003;\r\u0001\u00071\bC\u0003[\r\u0001\u00071,A\u0003tY&\u001cW\rE\u0002\u001f9\u0006J!!\u0018\u0007\u0003\u000bMc\u0017nY3\u0002!I,\u0007\u000f\\1dK\u001a\u0013x.\\!se\u0006LH#\u0002\u001daC\n$\u0007\"\u0002\u001e\b\u0001\u0004Y\u0004\"B)\b\u0001\u0004Y\u0004\"B2\b\u0001\u0004Y\u0014!\u0004:fa2\f7-\u001a'f]\u001e$\b\u000eC\u0003V\u000f\u0001\u00071'\u0001\tsKBd\u0017mY3Ge>l7\u000b\\5dKR\u0019\u0001h\u001a5\t\u000biB\u0001\u0019A\u001e\t\u000biC\u0001\u0019A.\u0002\u0015MD\u0017N\u001a;SS\u001eDG\u000fF\u00029W2DQAO\u0005A\u0002mBQ!\\\u0005A\u0002m\n\u0001\u0002Z5ti\u0006t7-Z\u0001\ng\"Lg\r\u001e'fMR$2\u0001\u000f9r\u0011\u0015Q$\u00021\u0001<\u0011\u0015i'\u00021\u0001<\u0001")
public interface ArrayBufferLike<T>
extends Buffer<T> {
    public Object underlyingUnsafe();

    public static /* synthetic */ ArrayBufferLike update$(ArrayBufferLike $this, int index, Object value) {
        return $this.update(index, value);
    }

    @Override
    default public ArrayBufferLike<T> update(int index, T value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index);
        ScalaRunTime$.MODULE$.array_update(this.underlyingUnsafe(), index, value);
        this.set(Math.max(index, this.top()));
        return this;
    }

    public static /* synthetic */ String toString$(ArrayBufferLike $this) {
        return $this.toString();
    }

    default public String toString() {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(this.underlyingUnsafe()).take(Math.min(20, this.length()))).mkString("[", ",", this.length() > 20 ? ", ... ]" : "]");
    }

    public static /* synthetic */ ArrayBufferLike insertArray$(ArrayBufferLike $this, int index, int sourceIndex, int insertLength, Object sourceArray) {
        return $this.insertArray(index, sourceIndex, insertLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike<T> insertArray(int index, int sourceIndex, int insertLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(insertLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.shiftRight(index, copyLength);
            System.arraycopy(sourceArray, sourceIndex, this.underlyingUnsafe(), index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike insertSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.insertSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike<T> insertSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.shiftRight(index, slice.length());
        slice.copyToArray(index, this.underlyingUnsafe());
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike replaceFromArray$(ArrayBufferLike $this, int index, int sourceIndex, int replaceLength, Object sourceArray) {
        return $this.replaceFromArray(index, sourceIndex, replaceLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike<T> replaceFromArray(int index, int sourceIndex, int replaceLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(replaceLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.ensureIndex(index + replaceLength);
            System.arraycopy(sourceArray, sourceIndex, this.underlyingUnsafe(), index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike replaceFromSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.replaceFromSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike<T> replaceFromSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index + slice.length());
        slice.copyToArray(index, this.underlyingUnsafe());
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike shiftRight$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftRight(index, distance);
    }

    @Override
    default public ArrayBufferLike<T> shiftRight(int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            this.ensureIndex(Math.max(this.length(), index) + distance);
            if (this.length() - index > 0) {
                System.arraycopy(this.underlyingUnsafe(), index, this.underlyingUnsafe(), index + distance, this.length() - index);
            }
            object = this.top() >= index ? this.set(this.top() + distance) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike shiftLeft$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftLeft(index, distance);
    }

    @Override
    default public ArrayBufferLike<T> shiftLeft(int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            int distance2 = Math.min(index, distance);
            int offset = distance - distance2;
            if (this.length() - index - offset > 0) {
                System.arraycopy(this.underlyingUnsafe(), index + offset, this.underlyingUnsafe(), index - distance2, this.length() - index - offset);
            }
            object = this.top() >= index - distance2 ? this.set(Math.max(-1, this.top() - distance)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static void $init$(ArrayBufferLike $this) {
    }
}

