/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.ArrayOps$;
import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.Slice;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=ba\u0002\t\u0012!\u0003\r\tA\u0007\u0005\u0006c\u0001!\tA\r\u0005\u0006m\u00011\ta\u000e\u0005\u0006w\u0001!)\u0006\u0010\u0005\u0006\r\u0002!)f\u0012\u0005\u0006\u0019\u0002!)%\u0014\u0005\u0006#\u0002!)E\u0015\u0005\u0006=\u0002!)e\u0018\u0005\u0006O\u0002!)\u0005\u001b\u0005\u0006_\u0002!)\u0005\u001d\u0005\u0006m\u0002!)e\u001e\u0005\u0006u\u0002!)e\u001f\u0005\u0007\u007f\u0002!)%!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0012\u0002\n!9\u0011Q\u0003\u0001\u0005F\u0005]\u0001bBA\u0010\u0001\u0011\u0015\u0013\u0011\u0005\u0002\u0010\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fT5lK*\u0011!cE\u0001\u000fEV4g-\u001a:b]\u0012\u001cH.[2f\u0015\t!R#\u0001\u0006beR,(o\u001c9bY\u0006T!AF\f\u0002\r\u001dLG\u000f[;c\u0015\u0005A\u0012aA2p[\u000e\u0001QCA\u000e)'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\r\"c%D\u0001\u0012\u0013\t)\u0013C\u0001\u0004Ck\u001a4WM\u001d\t\u0003O!b\u0001\u0001B\u0003*\u0001\t\u0007!FA\u0001U#\tYc\u0006\u0005\u0002\u001eY%\u0011QF\b\u0002\b\u001d>$\b.\u001b8h!\tir&\u0003\u00021=\t\u0019\u0011I\\=\u0002\r\u0011Jg.\u001b;%)\u0005\u0019\u0004CA\u000f5\u0013\t)dD\u0001\u0003V]&$\u0018\u0001E;oI\u0016\u0014H._5oOVs7/\u00194f+\u0005A\u0004cA\u000f:M%\u0011!H\b\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000fk:\u001c\u0007.Z2lK\u0012\f\u0005\u000f\u001d7z)\t1S\bC\u0003?\u0007\u0001\u0007q(A\u0003j]\u0012,\u0007\u0010\u0005\u0002\u001e\u0001&\u0011\u0011I\b\u0002\u0004\u0013:$\bFA\u0002D!\tiB)\u0003\u0002F=\t1\u0011N\u001c7j]\u0016\fq\"\u001e8dQ\u0016\u001c7.\u001a3Va\u0012\fG/\u001a\u000b\u0004g!K\u0005\"\u0002 \u0005\u0001\u0004y\u0004\"\u0002&\u0005\u0001\u00041\u0013!\u0002<bYV,\u0007F\u0001\u0003D\u0003\u0019)\b\u000fZ1uKR\u0019aj\u0014)\u000e\u0003\u0001AQAP\u0003A\u0002}BQAS\u0003A\u0002\u0019\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002'B\u0011Ak\u0017\b\u0003+f\u0003\"A\u0016\u0010\u000e\u0003]S!\u0001W\r\u0002\rq\u0012xn\u001c;?\u0013\tQf$\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.\u001f\u0003-Ign]3si\u0006\u0013(/Y=\u0015\u000b9\u0003\u0017mY3\t\u000by:\u0001\u0019A \t\u000b\t<\u0001\u0019A \u0002\u0017M|WO]2f\u0013:$W\r\u001f\u0005\u0006I\u001e\u0001\raP\u0001\rS:\u001cXM\u001d;MK:<G\u000f\u001b\u0005\u0006M\u001e\u0001\r\u0001O\u0001\fg>,(oY3BeJ\f\u00170A\u0006j]N,'\u000f^*mS\u000e,Gc\u0001(jU\")a\b\u0003a\u0001\u007f!)1\u000e\u0003a\u0001Y\u0006)1\u000f\\5dKB\u00191%\u001c\u0014\n\u00059\f\"!B*mS\u000e,\u0017\u0001\u0005:fa2\f7-\u001a$s_6\f%O]1z)\u0015q\u0015O]:v\u0011\u0015q\u0014\u00021\u0001@\u0011\u0015\u0011\u0017\u00021\u0001@\u0011\u0015!\u0018\u00021\u0001@\u00035\u0011X\r\u001d7bG\u0016dUM\\4uQ\")a-\u0003a\u0001q\u0005\u0001\"/\u001a9mC\u000e,gI]8n'2L7-\u001a\u000b\u0004\u001dbL\b\"\u0002 \u000b\u0001\u0004y\u0004\"B6\u000b\u0001\u0004a\u0017AC:iS\u001a$(+[4iiR\u0019a\n`?\t\u000byZ\u0001\u0019A \t\u000by\\\u0001\u0019A \u0002\u0011\u0011L7\u000f^1oG\u0016\f\u0011b\u001d5jMRdUM\u001a;\u0015\u000b9\u000b\u0019!!\u0002\t\u000byb\u0001\u0019A \t\u000byd\u0001\u0019A \u0002\u001d5|g/\u001a*b]\u001e,'+[4iiR9a*a\u0003\u0002\u0010\u0005M\u0001BBA\u0007\u001b\u0001\u0007q(A\u0005ge>l\u0017J\u001c3fq\"1\u0011\u0011C\u0007A\u0002}\nq\u0001^8J]\u0012,\u0007\u0010C\u0003\u007f\u001b\u0001\u0007q(A\u0007n_Z,'+\u00198hK2+g\r\u001e\u000b\b\u001d\u0006e\u00111DA\u000f\u0011\u0019\tiA\u0004a\u0001\u007f!1\u0011\u0011\u0003\bA\u0002}BQA \bA\u0002}\n\u0011b]<baJ\u000bgnZ3\u0015\u000f9\u000b\u0019#a\n\u0002,!1\u0011QE\bA\u0002}\nQAZ5sgRDa!!\u000b\u0010\u0001\u0004y\u0014AB:fG>tG\r\u0003\u0004\u0002.=\u0001\raP\u0001\u000bg^\f\u0007\u000fT3oORD\u0007")
public interface ArrayBufferLike<T>
extends Buffer<T> {
    public Object underlyingUnsafe();

    public static /* synthetic */ Object uncheckedApply$(ArrayBufferLike $this, int index) {
        return $this.uncheckedApply(index);
    }

    @Override
    default public T uncheckedApply(int index) {
        return (T)ScalaRunTime$.MODULE$.array_apply(this.underlyingUnsafe(), index);
    }

    public static /* synthetic */ void uncheckedUpdate$(ArrayBufferLike $this, int index, Object value) {
        $this.uncheckedUpdate(index, value);
    }

    @Override
    default public void uncheckedUpdate(int index, T value) {
        ScalaRunTime$.MODULE$.array_update(this.underlyingUnsafe(), index, value);
    }

    public static /* synthetic */ ArrayBufferLike update$(ArrayBufferLike $this, int index, Object value) {
        return $this.update(index, value);
    }

    @Override
    default public ArrayBufferLike<T> update(int index, T value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index);
        ScalaRunTime$.MODULE$.array_update(this.underlyingUnsafe(), index, value);
        this.set(Math.max(index, this.top()));
        return this;
    }

    public static /* synthetic */ String toString$(ArrayBufferLike $this) {
        return $this.toString();
    }

    default public String toString() {
        return Predef$.MODULE$.genericWrapArray(scala.collection.ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.genericArrayOps(this.underlyingUnsafe()), Math.min(20, this.length()))).mkString("[", ",", this.length() > 20 ? ", ... ]" : "]");
    }

    public static /* synthetic */ ArrayBufferLike insertArray$(ArrayBufferLike $this, int index, int sourceIndex, int insertLength, Object sourceArray) {
        return $this.insertArray(index, sourceIndex, insertLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike<T> insertArray(int index, int sourceIndex, int insertLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(insertLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.shiftRight(index, copyLength);
            System.arraycopy(sourceArray, sourceIndex, this.underlyingUnsafe(), index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike insertSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.insertSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike<T> insertSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.shiftRight(index, slice.length());
        slice.copyToArray(index, this.underlyingUnsafe());
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike replaceFromArray$(ArrayBufferLike $this, int index, int sourceIndex, int replaceLength, Object sourceArray) {
        return $this.replaceFromArray(index, sourceIndex, replaceLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike<T> replaceFromArray(int index, int sourceIndex, int replaceLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(replaceLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.ensureIndex(index + replaceLength);
            System.arraycopy(sourceArray, sourceIndex, this.underlyingUnsafe(), index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike replaceFromSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.replaceFromSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike<T> replaceFromSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index + slice.length());
        slice.copyToArray(index, this.underlyingUnsafe());
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike shiftRight$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftRight(index, distance);
    }

    @Override
    default public ArrayBufferLike<T> shiftRight(int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            this.ensureIndex(Math.max(this.length(), index) + distance);
            if (this.length() - index > 0) {
                System.arraycopy(this.underlyingUnsafe(), index, this.underlyingUnsafe(), index + distance, this.length() - index);
            }
            object = this.top() >= index ? this.set(this.top() + distance) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike shiftLeft$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftLeft(index, distance);
    }

    @Override
    default public ArrayBufferLike<T> shiftLeft(int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            int distance2 = Math.min(index, distance);
            int offset = distance - distance2;
            if (this.length() - index - offset > 0) {
                System.arraycopy(this.underlyingUnsafe(), index + offset, this.underlyingUnsafe(), index - distance2, this.length() - index - offset);
            }
            object = this.top() >= index - distance2 ? this.set(Math.max(-1, this.top() - distance)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike moveRangeRight$(ArrayBufferLike $this, int fromIndex, int toIndex, int distance) {
        return $this.moveRangeRight(fromIndex, toIndex, distance);
    }

    @Override
    default public ArrayBufferLike<T> moveRangeRight(int fromIndex, int toIndex, int distance) {
        Object object;
        if (distance > 0 && fromIndex >= 0 && toIndex > fromIndex && fromIndex < this.length()) {
            int to = Math.min(toIndex, this.length());
            this.ensureIndex(to + distance - 1);
            Object backup = ArrayOps$.MODULE$.copyOf(ArrayOps$.MODULE$.copyOf(this.underlyingUnsafe(), 0), distance);
            this.slice(to, Math.min(to + distance, this.length())).copyToArray(0, backup);
            System.arraycopy(this.underlyingUnsafe(), fromIndex, this.underlyingUnsafe(), fromIndex + distance, to - fromIndex);
            System.arraycopy(backup, 0, this.underlyingUnsafe(), fromIndex, ScalaRunTime$.MODULE$.array_length(backup));
            object = this.set(Math.max(this.top(), to + distance - 1));
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike moveRangeLeft$(ArrayBufferLike $this, int fromIndex, int toIndex, int distance) {
        return $this.moveRangeLeft(fromIndex, toIndex, distance);
    }

    @Override
    default public ArrayBufferLike<T> moveRangeLeft(int fromIndex, int toIndex, int distance) {
        block0: {
            if (distance <= 0 || fromIndex < 0 || toIndex <= fromIndex || fromIndex >= this.length()) break block0;
            int from = Math.max(fromIndex, distance);
            int to = Math.min(toIndex, this.length());
            Object backup = ArrayOps$.MODULE$.copyOf(ArrayOps$.MODULE$.copyOf(this.underlyingUnsafe(), 0), distance);
            Slice relocating = this.slice(from - distance, fromIndex);
            relocating.copyToArray(ScalaRunTime$.MODULE$.array_length(backup) - relocating.length(), backup);
            int gap = Math.max(0, distance - fromIndex);
            this.shiftRight(0, gap);
            System.arraycopy(this.underlyingUnsafe(), fromIndex + gap, this.underlyingUnsafe(), fromIndex - distance + gap, to - fromIndex);
            System.arraycopy(backup, 0, this.underlyingUnsafe(), to - distance + gap, ScalaRunTime$.MODULE$.array_length(backup));
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike swapRange$(ArrayBufferLike $this, int first, int second, int swapLength) {
        return $this.swapRange(first, second, swapLength);
    }

    @Override
    default public ArrayBufferLike<T> swapRange(int first, int second, int swapLength) {
        block0: {
            if (swapLength <= 0 || first < 0 || second < 0 || first == second || first >= this.length() || second >= this.length() || first + swapLength < 0 || second + swapLength < 0) break block0;
            int backupLength = Math.min(swapLength, this.length() - Math.max(first, second));
            Object backup = ArrayOps$.MODULE$.copyOf(this.underlyingUnsafe(), backupLength);
            this.slice(second, second + backupLength).copyToArray(0, backup);
            System.arraycopy(this.underlyingUnsafe(), first, this.underlyingUnsafe(), second, backupLength);
            System.arraycopy(backup, 0, this.underlyingUnsafe(), first, backupLength);
        }
        return this;
    }

    public static void $init$(ArrayBufferLike $this) {
    }
}

