/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.IntBuffer;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

public final class IndexTracker$ {
    public static IndexTracker$ MODULE$;

    static {
        new IndexTracker$();
    }

    public final IntBuffer trackShiftRight(int index, int distance, IntBuffer indexes) {
        Object object = indexes.nonEmpty() && distance > 0 && index >= 0 ? indexes.modifyAllWhen((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)x$1 -> x$1 + distance, (Function1<Object, Object>)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$2 -> x$2 >= index) : BoxedUnit.UNIT;
        return indexes;
    }

    public final <S extends Seq<Object>> S trackShiftRight(int index, int distance, S indexes) {
        if (indexes.nonEmpty() && distance > 0 && index >= 0) {
            return (S)((Seq)indexes.map((Function1)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (i >= index) {
                    return i + distance;
                }
                return i;
            }, Seq$.MODULE$.canBuildFrom()));
        }
        return indexes;
    }

    public final IntBuffer trackShiftLeft(int index, int distance, IntBuffer indexes) {
        Object object;
        if (indexes.nonEmpty() && distance > 0 && index >= 0) {
            indexes.removeWhen((Function1<Object, Object>)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)i -> i >= index - distance && i < index);
            indexes.modifyAllWhen((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)x$3 -> x$3 - distance, (Function1<Object, Object>)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$4 -> x$4 >= index);
            object = indexes.removeWhen((Function1<Object, Object>)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$5 -> x$5 < 0);
        } else {
            object = BoxedUnit.UNIT;
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackShiftLeft(int index, int distance, S indexes) {
        if (indexes.nonEmpty() && distance > 0 && index >= 0) {
            return (S)((Seq)((TraversableLike)((TraversableLike)indexes.filterNot((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)i -> i >= index - distance && i < index)).map((Function1)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (i >= index) {
                    return i - distance;
                }
                return i;
            }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$6 -> x$6 < 0));
        }
        return indexes;
    }

    public final IntBuffer trackMoveRangeRight(int fromIndex, int toIndex, int distance, IntBuffer indexes) {
        Object object;
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = fromIndex - toIndex;
            object = indexes.modifyAll((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (i >= fromIndex && i < toIndex) {
                    return i + distance;
                }
                if (i >= toIndex && i < toIndex + distance) {
                    return i + offset;
                }
                return i;
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackMoveRangeRight(int fromIndex, int toIndex, int distance, S indexes) {
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = fromIndex - toIndex;
            return (S)((Seq)indexes.map((Function1)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (i >= fromIndex && i < toIndex) {
                    return i + distance;
                }
                if (i >= toIndex && i < toIndex + distance) {
                    return i + offset;
                }
                return i;
            }, Seq$.MODULE$.canBuildFrom()));
        }
        return indexes;
    }

    public final IntBuffer trackMoveRangeLeft(int fromIndex, int toIndex, int distance, IntBuffer indexes) {
        Object object;
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = toIndex - fromIndex;
            int shift = Math.max(0, distance - fromIndex);
            Object object2 = shift > 0 ? indexes.modifyAll((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)x$7 -> x$7 + shift) : BoxedUnit.UNIT;
            object = indexes.modifyAll((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (i >= fromIndex + shift && i < toIndex + shift) {
                    return i - distance;
                }
                if (i >= fromIndex - distance + shift && i < fromIndex + shift) {
                    return i + offset;
                }
                return i;
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackMoveRangeLeft(int fromIndex, int toIndex, int distance, S indexes) {
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = toIndex - fromIndex;
            int shift = Math.max(0, distance - fromIndex);
            S indexes2 = shift > 0 ? (Seq)indexes.map((Function1)(JFunction1.mcII.sp & java.io.Serializable & Serializable)x$8 -> x$8 + shift, Seq$.MODULE$.canBuildFrom()) : indexes;
            return (S)((Seq)indexes2.map((Function1)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (i >= fromIndex + shift && i < toIndex + shift) {
                    return i - distance;
                }
                if (i >= fromIndex - distance + shift && i < fromIndex + shift) {
                    return i + offset;
                }
                return i;
            }, Seq$.MODULE$.canBuildFrom()));
        }
        return indexes;
    }

    public final IntBuffer trackSwapRange(int first, int second, int swapLength, IntBuffer indexes) {
        Object object;
        if (indexes.nonEmpty() && swapLength > 0 && first >= 0 && second >= 0 && first != second && first + swapLength >= 0 && second + swapLength >= 0) {
            int offset = first - second;
            boolean hasLeftOverlap = Math.abs(offset) < swapLength && first < second;
            boolean hasRightOverlap = !hasLeftOverlap && Math.abs(offset) < swapLength && first > second;
            object = indexes.modifyAll((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (hasLeftOverlap && i >= first && i < second) {
                    return -1;
                }
                if (hasRightOverlap && i >= second + swapLength && i < first + swapLength) {
                    return -1;
                }
                if (i >= second && i < second + swapLength) {
                    return i + offset;
                }
                if (i >= first && i < first + swapLength) {
                    return i - offset;
                }
                return i;
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackSwapRange(int first, int second, int swapLength, S indexes) {
        if (indexes.nonEmpty() && swapLength > 0 && first >= 0 && second >= 0 && first != second && first + swapLength >= 0 && second + swapLength >= 0) {
            int offset = first - second;
            boolean hasLeftOverlap = Math.abs(offset) < swapLength && first < second;
            boolean hasRightOverlap = !hasLeftOverlap && Math.abs(offset) < swapLength && first > second;
            return (S)((Seq)indexes.map((Function1)(JFunction1.mcII.sp & java.io.Serializable & Serializable)i -> {
                if (hasLeftOverlap && i >= first && i < second) {
                    return -1;
                }
                if (hasRightOverlap && i >= second + swapLength && i < first + swapLength) {
                    return -1;
                }
                if (i >= second && i < second + swapLength) {
                    return i + offset;
                }
                if (i >= first && i < first + swapLength) {
                    return i - offset;
                }
                return i;
            }, Seq$.MODULE$.canBuildFrom()));
        }
        return indexes;
    }

    private IndexTracker$() {
        MODULE$ = this;
    }
}

