/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.ArrayBufferLike;
import com.github.arturopala.bufferandslice.Slice;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public abstract class ArrayBufferLike$class {
    public static final ArrayBufferLike update(ArrayBufferLike $this, int index, Object value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        $this.ensureIndex(index);
        ScalaRunTime$.MODULE$.array_update($this.underlyingUnsafe(), index, value);
        $this.set(Math.max(index, $this.top()));
        return $this;
    }

    public static final String toString(ArrayBufferLike $this) {
        return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps($this.underlyingUnsafe()).take(Math.min(20, $this.length()))).mkString("[", ",", $this.length() > 20 ? ", ... ]" : "]");
    }

    public static final ArrayBufferLike insertArray(ArrayBufferLike $this, int index, int sourceIndex, int insertLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(insertLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            $this.shiftRight(index, copyLength);
            System.arraycopy(sourceArray, sourceIndex, $this.underlyingUnsafe(), index, copyLength);
        }
        $this.set(Math.max($this.top(), index + copyLength - 1));
        return $this;
    }

    public static final ArrayBufferLike insertSlice(ArrayBufferLike $this, int index, Slice slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        $this.shiftRight(index, slice.length());
        slice.copyToArray(index, $this.underlyingUnsafe());
        $this.set(Math.max($this.top(), index + slice.length() - 1));
        return $this;
    }

    public static final ArrayBufferLike replaceFromArray(ArrayBufferLike $this, int index, int sourceIndex, int replaceLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(replaceLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            $this.ensureIndex(index + replaceLength);
            System.arraycopy(sourceArray, sourceIndex, $this.underlyingUnsafe(), index, copyLength);
        }
        $this.set(Math.max($this.top(), index + copyLength - 1));
        return $this;
    }

    public static final ArrayBufferLike replaceFromSlice(ArrayBufferLike $this, int index, Slice slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        $this.ensureIndex(index + slice.length());
        slice.copyToArray(index, $this.underlyingUnsafe());
        $this.set(Math.max($this.top(), index + slice.length() - 1));
        return $this;
    }

    public static final ArrayBufferLike shiftRight(ArrayBufferLike $this, int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            $this.ensureIndex(Math.max($this.length(), index) + distance);
            if ($this.length() - index > 0) {
                System.arraycopy($this.underlyingUnsafe(), index, $this.underlyingUnsafe(), index + distance, $this.length() - index);
            }
            object = $this.top() >= index ? $this.set($this.top() + distance) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return $this;
    }

    public static final ArrayBufferLike shiftLeft(ArrayBufferLike $this, int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            int distance2 = Math.min(index, distance);
            int offset = distance - distance2;
            if ($this.length() - index - offset > 0) {
                System.arraycopy($this.underlyingUnsafe(), index + offset, $this.underlyingUnsafe(), index - distance2, $this.length() - index - offset);
            }
            object = $this.top() >= index - distance2 ? $this.set(Math.max(-1, $this.top() - distance)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return $this;
    }

    public static void $init$(ArrayBufferLike $this) {
    }
}

