/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.Slice;
import scala.Function1;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class Buffer$class {
    public static final Buffer modify(Buffer $this, int index, Function1 map) {
        if (index >= 0 && index < $this.length()) {
            $this.update(index, map.apply($this.apply(index)));
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max(index, $this.com$github$arturopala$bufferandslice$Buffer$$topIndex()));
        }
        return $this;
    }

    public static final Buffer map(Buffer $this, Function1 f) {
        return $this.modifyAll(f);
    }

    public static final Buffer modifyAll(Buffer $this, Function1 map) {
        for (int i = 0; i < $this.length(); ++i) {
            $this.update(i, map.apply($this.apply(i)));
        }
        return $this;
    }

    public static final Buffer modifyAllWhen(Buffer $this, Function1 map, Function1 pred) {
        for (int i = 0; i < $this.length(); ++i) {
            Object v = $this.apply(i);
            Object object = BoxesRunTime.unboxToBoolean((Object)pred.apply(v)) ? $this.update(i, map.apply(v)) : BoxedUnit.UNIT;
        }
        return $this;
    }

    public static final Buffer modifyRange(Buffer $this, int fromIndex, int toIndex, Function1 map) {
        if (toIndex > 0 && fromIndex < $this.length()) {
            int i;
            int limit = Math.min($this.length(), toIndex);
            for (i = Math.max(0, fromIndex); i < limit; ++i) {
                $this.update(i, map.apply($this.apply(i)));
            }
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max($this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), i - 1));
        }
        return $this;
    }

    public static final Buffer modifyRangeWhen(Buffer $this, int fromIndex, int toIndex, Function1 map, Function1 pred) {
        if (toIndex > 0 && fromIndex < $this.length()) {
            int i;
            int limit = Math.min($this.length(), toIndex);
            for (i = Math.max(0, fromIndex); i < limit; ++i) {
                Object v = $this.apply(i);
                Object object = BoxesRunTime.unboxToBoolean((Object)pred.apply(v)) ? $this.update(i, map.apply(v)) : BoxedUnit.UNIT;
            }
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max($this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), i - 1));
        }
        return $this;
    }

    public static final Object head(Buffer $this) {
        return $this.apply($this.com$github$arturopala$bufferandslice$Buffer$$topIndex());
    }

    public static final int length(Buffer $this) {
        return $this.com$github$arturopala$bufferandslice$Buffer$$topIndex() + 1;
    }

    public static final boolean isEmpty(Buffer $this) {
        return $this.length() == 0;
    }

    public static final boolean nonEmpty(Buffer $this) {
        return $this.length() > 0;
    }

    public static final int top(Buffer $this) {
        return $this.com$github$arturopala$bufferandslice$Buffer$$topIndex();
    }

    public static final Buffer set(Buffer $this, int index) {
        $this.ensureIndex(index);
        $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max(-1, index));
        return $this;
    }

    public static final Buffer rewind(Buffer $this, int distance) {
        $this.ensureIndex(Math.max(-1, $this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - distance));
        $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max(-1, $this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - distance));
        return $this;
    }

    public static final Buffer forward(Buffer $this, int distance) {
        $this.ensureIndex($this.com$github$arturopala$bufferandslice$Buffer$$topIndex() + distance);
        $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq($this.com$github$arturopala$bufferandslice$Buffer$$topIndex() < 0 ? distance : $this.com$github$arturopala$bufferandslice$Buffer$$topIndex() + distance);
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public static final int reset(Buffer $this) {
        void var1_1;
        int i = $this.com$github$arturopala$bufferandslice$Buffer$$topIndex();
        $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(-1);
        return (int)var1_1;
    }

    public static final Buffer append(Buffer $this, Object value) {
        $this.update($this.length(), value);
        return $this;
    }

    public static final Buffer appendArray(Buffer $this, Object values) {
        return $this.insertArray($this.length(), 0, ScalaRunTime$.MODULE$.array_length(values), values);
    }

    public static final Buffer appendSlice(Buffer $this, Slice slice) {
        return $this.insertSlice($this.length(), slice);
    }

    public static final Buffer appendSequence(Buffer $this, IndexedSeq values) {
        return $this.insertValues($this.length(), 0, values.length(), values);
    }

    public static final Buffer appendFromIterator(Buffer $this, Iterator iterator) {
        while (iterator.hasNext()) {
            $this.append(iterator.next());
        }
        return $this;
    }

    public static final Buffer appendIterable(Buffer $this, Iterable iterable) {
        return $this.appendFromIterator(iterable.iterator());
    }

    public static final Buffer insertValues(Buffer $this, int index, int sourceIndex, int insertLength, Function1 source) {
        if (index >= 0 && sourceIndex >= 0) {
            if (insertLength > 0) {
                $this.shiftRight(index, insertLength);
                for (int i = 0; i < insertLength; ++i) {
                    $this.update(index + i, source.apply((Object)BoxesRunTime.boxToInteger((int)(sourceIndex + i))));
                }
            }
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max($this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), index + insertLength - 1));
        }
        return $this;
    }

    public static final Buffer insertFromIterator(Buffer $this, int index, int insertLength, Iterator iterator) {
        if (index >= 0) {
            if (insertLength > 0) {
                $this.shiftRight(index, insertLength);
                for (int i = 0; i < insertLength && iterator.hasNext(); ++i) {
                    $this.update(index + i, iterator.next());
                }
            }
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max($this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), index + insertLength - 1));
        }
        return $this;
    }

    public static final Buffer replaceValues(Buffer $this, int index, int sourceIndex, int replaceLength, Function1 source) {
        if (index >= 0 && sourceIndex >= 0) {
            if (replaceLength > 0) {
                $this.ensureIndex(index + replaceLength);
                for (int i = 0; i < replaceLength; ++i) {
                    $this.update(index + i, source.apply((Object)BoxesRunTime.boxToInteger((int)(sourceIndex + i))));
                }
            }
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max($this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), index + replaceLength - 1));
        }
        return $this;
    }

    public static final Buffer replaceFromIterator(Buffer $this, int index, int replaceLength, Iterator iterator) {
        if (index >= 0) {
            if (replaceLength > 0) {
                $this.ensureIndex(index + replaceLength);
                for (int i = 0; i < replaceLength && iterator.hasNext(); ++i) {
                    $this.update(index + i, iterator.next());
                }
            }
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(Math.max($this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), index + replaceLength - 1));
        }
        return $this;
    }

    public static final Buffer remove(Buffer $this, int index) {
        return $this.shiftLeft(index + 1, 1);
    }

    public static final Buffer removeRange(Buffer $this, int fromIndex, int toIndex) {
        return $this.shiftLeft(toIndex, toIndex - fromIndex);
    }

    public static final Buffer store(Buffer $this, Object value) {
        if ($this.com$github$arturopala$bufferandslice$Buffer$$topIndex() < 0) {
            $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(0);
        }
        $this.update($this.com$github$arturopala$bufferandslice$Buffer$$topIndex(), value);
        return $this;
    }

    public static final Buffer push(Buffer $this, Object value) {
        $this.update($this.length(), value);
        return $this;
    }

    public static final Object peek(Buffer $this) {
        return $this.apply($this.com$github$arturopala$bufferandslice$Buffer$$topIndex());
    }

    /*
     * WARNING - void declaration
     */
    public static final Object pop(Buffer $this) {
        void var1_1;
        Object value = $this.peek();
        $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq($this.com$github$arturopala$bufferandslice$Buffer$$topIndex() - 1);
        return var1_1;
    }

    public static final Slice slice(Buffer $this, int from, int to) {
        return $this.toSlice().slice(from, to);
    }

    public static final Slice take(Buffer $this, int n) {
        return $this.toSlice().take(n);
    }

    public static final Slice takeRight(Buffer $this, int n) {
        return $this.toSlice().takeRight(n);
    }

    public static final Slice drop(Buffer $this, int n) {
        return $this.toSlice().drop(n);
    }

    public static final Slice dropRight(Buffer $this, int n) {
        return $this.toSlice().dropRight(n);
    }

    public static void $init$(Buffer $this) {
        $this.com$github$arturopala$bufferandslice$Buffer$$topIndex_$eq(-1);
    }
}

