/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.Buffer;
import com.github.arturopala.bufferandslice.Slice;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rca\u0002\n\u0014!\u0003\r\t\u0001\b\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006q\u00011\t\"\u000f\u0005\u0006q\u00011\t\u0002\u0013\u0005\u0006\u001f\u00021\t\u0002\u0015\u0005\u0006)\u00021\t\"\u0016\u0005\u00061\u0002!)%\u0017\u0005\u0006?\u0002!)\u0005\u0019\u0005\u0006Y\u0002!)%\u001c\u0005\u0006g\u0002!)\u0005\u001e\u0005\u0006o\u0002!)\u0005\u001f\u0005\u0006}\u0002!)e \u0005\b\u0003\u000b\u0001AQIA\u0004\u0011\u001d\ty\u0001\u0001C#\u0003#Aq!a\u0006\u0001\t\u000b\nI\u0002C\u0004\u0002&\u0001!)%a\n\t\u000f\u0005=\u0002\u0001\"\u0012\u00022!9\u0011q\b\u0001\u0005F\u0005\u0005#aD!se\u0006L()\u001e4gKJd\u0015n[3\u000b\u0005Q)\u0012A\u00042vM\u001a,'/\u00198eg2L7-\u001a\u0006\u0003-]\t!\"\u0019:ukJ|\u0007/\u00197b\u0015\tA\u0012$\u0001\u0004hSRDWO\u0019\u0006\u00025\u0005\u00191m\\7\u0004\u0001U\u0011QDK\n\u0004\u0001y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\rE\u0002&M!j\u0011aE\u0005\u0003OM\u0011aAQ;gM\u0016\u0014\bCA\u0015+\u0019\u0001!Qa\u000b\u0001C\u00021\u0012\u0011\u0001V\t\u0003[A\u0002\"a\b\u0018\n\u0005=\u0002#a\u0002(pi\"Lgn\u001a\t\u0003?EJ!A\r\u0011\u0003\u0007\u0005s\u00170\u0001\u0004%S:LG\u000f\n\u000b\u0002kA\u0011qDN\u0005\u0003o\u0001\u0012A!\u00168ji\u0006A1m\u001c9z\rJ|W\u000eF\u00036u}\"e\tC\u0003<\u0005\u0001\u0007A(A\u0006t_V\u00148-Z!se\u0006L\bcA\u0010>Q%\u0011a\b\t\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006\u0001\n\u0001\r!Q\u0001\fg>,(oY3J]\u0012,\u0007\u0010\u0005\u0002 \u0005&\u00111\t\t\u0002\u0004\u0013:$\b\"B#\u0003\u0001\u0004\t\u0015a\u0003;be\u001e,G/\u00138eKbDQa\u0012\u0002A\u0002\u0005\u000b!bY8qs2+gn\u001a;i)\r)\u0014J\u0014\u0005\u0006\u0015\u000e\u0001\raS\u0001\u0006g2L7-\u001a\t\u0004K1C\u0013BA'\u0014\u0005\u0015\u0019F.[2f\u0011\u0015)5\u00011\u0001B\u00031\u0019w\u000e]=Ge>l7+\u001a7g)\u0011)\u0014KU*\t\u000b\u0001#\u0001\u0019A!\t\u000b\u0015#\u0001\u0019A!\t\u000b\u001d#\u0001\u0019A!\u0002\u0015\u0015l\u0007\u000f^=BeJ\f\u0017\u0010\u0006\u0002=-\")q+\u0002a\u0001\u0003\u00061A.\u001a8hi\"\fa!\u001e9eCR,Gc\u0001.\\;6\t\u0001\u0001C\u0003]\r\u0001\u0007\u0011)A\u0003j]\u0012,\u0007\u0010C\u0003_\r\u0001\u0007\u0001&A\u0003wC2,X-\u0001\u0005u_N#(/\u001b8h)\u0005\t\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002eA5\tQM\u0003\u0002g7\u00051AH]8pizJ!\u0001\u001b\u0011\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003Q\u0002\n1\"\u001b8tKJ$\u0018I\u001d:bsR)!L\\8qe\")A\f\u0003a\u0001\u0003\")\u0001\t\u0003a\u0001\u0003\")\u0011\u000f\u0003a\u0001\u0003\u0006a\u0011N\\:feRdUM\\4uQ\")1\b\u0003a\u0001y\u0005Y\u0011N\\:feR\u001cF.[2f)\rQVO\u001e\u0005\u00069&\u0001\r!\u0011\u0005\u0006\u0015&\u0001\raS\u0001\u0011e\u0016\u0004H.Y2f\rJ|W.\u0011:sCf$RAW={wvDQ\u0001\u0018\u0006A\u0002\u0005CQ\u0001\u0011\u0006A\u0002\u0005CQ\u0001 \u0006A\u0002\u0005\u000bQB]3qY\u0006\u001cW\rT3oORD\u0007\"B\u001e\u000b\u0001\u0004a\u0014\u0001\u0005:fa2\f7-\u001a$s_6\u001cF.[2f)\u0015Q\u0016\u0011AA\u0002\u0011\u0015a6\u00021\u0001B\u0011\u0015Q5\u00021\u0001L\u0003)\u0019\b.\u001b4u%&<\u0007\u000e\u001e\u000b\u00065\u0006%\u00111\u0002\u0005\u000692\u0001\r!\u0011\u0005\u0007\u0003\u001ba\u0001\u0019A!\u0002\u0011\u0011L7\u000f^1oG\u0016\f\u0011b\u001d5jMRdUM\u001a;\u0015\u000bi\u000b\u0019\"!\u0006\t\u000bqk\u0001\u0019A!\t\r\u00055Q\u00021\u0001B\u00039iwN^3SC:<WMU5hQR$rAWA\u000e\u0003?\t\u0019\u0003\u0003\u0004\u0002\u001e9\u0001\r!Q\u0001\nMJ|W.\u00138eKbDa!!\t\u000f\u0001\u0004\t\u0015a\u0002;p\u0013:$W\r\u001f\u0005\u0007\u0003\u001bq\u0001\u0019A!\u0002\u001b5|g/\u001a*b]\u001e,G*\u001a4u)\u001dQ\u0016\u0011FA\u0016\u0003[Aa!!\b\u0010\u0001\u0004\t\u0005BBA\u0011\u001f\u0001\u0007\u0011\t\u0003\u0004\u0002\u000e=\u0001\r!Q\u0001\ng^\f\u0007OU1oO\u0016$rAWA\u001a\u0003o\tY\u0004\u0003\u0004\u00026A\u0001\r!Q\u0001\u0006M&\u00148\u000f\u001e\u0005\u0007\u0003s\u0001\u0002\u0019A!\u0002\rM,7m\u001c8e\u0011\u0019\ti\u0004\u0005a\u0001\u0003\u0006Q1o^1q\u0019\u0016tw\r\u001e5\u0002\u0011=\u0004H/[7ju\u0016$\u0012A\u0017")
public interface ArrayBufferLike<T>
extends Buffer<T> {
    public void copyFrom(Object var1, int var2, int var3, int var4);

    public void copyFrom(Slice<T> var1, int var2);

    public void copyFromSelf(int var1, int var2, int var3);

    public Object emptyArray(int var1);

    public static /* synthetic */ ArrayBufferLike update$(ArrayBufferLike $this, int index, Object value) {
        return $this.update(index, value);
    }

    @Override
    default public ArrayBufferLike<T> update(int index, T value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index);
        this.uncheckedUpdate(index, value);
        this.set(Math.max(index, this.top()));
        return this;
    }

    public static /* synthetic */ String toString$(ArrayBufferLike $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.iterator().take(Math.min(20, this.length())).mkString("[", ",", this.length() > 20 ? ", ... ]" : "]");
    }

    public static /* synthetic */ ArrayBufferLike insertArray$(ArrayBufferLike $this, int index, int sourceIndex, int insertLength, Object sourceArray) {
        return $this.insertArray(index, sourceIndex, insertLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike<T> insertArray(int index, int sourceIndex, int insertLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(insertLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.shiftRight(index, copyLength);
            this.copyFrom(sourceArray, sourceIndex, index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike insertSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.insertSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike<T> insertSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.shiftRight(index, slice.length());
        this.copyFrom(slice, index);
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike replaceFromArray$(ArrayBufferLike $this, int index, int sourceIndex, int replaceLength, Object sourceArray) {
        return $this.replaceFromArray(index, sourceIndex, replaceLength, sourceArray);
    }

    @Override
    default public ArrayBufferLike<T> replaceFromArray(int index, int sourceIndex, int replaceLength, Object sourceArray) {
        if (index < 0 || sourceIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        int copyLength = Math.min(replaceLength, ScalaRunTime$.MODULE$.array_length(sourceArray));
        if (copyLength > 0) {
            this.ensureIndex(index + replaceLength);
            this.copyFrom(sourceArray, sourceIndex, index, copyLength);
        }
        this.set(Math.max(this.top(), index + copyLength - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike replaceFromSlice$(ArrayBufferLike $this, int index, Slice slice) {
        return $this.replaceFromSlice(index, slice);
    }

    @Override
    default public ArrayBufferLike<T> replaceFromSlice(int index, Slice<T> slice) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureIndex(index + slice.length());
        this.copyFrom(slice, index);
        this.set(Math.max(this.top(), index + slice.length() - 1));
        return this;
    }

    public static /* synthetic */ ArrayBufferLike shiftRight$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftRight(index, distance);
    }

    @Override
    default public ArrayBufferLike<T> shiftRight(int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            this.ensureIndex(Math.max(this.length(), index) + distance);
            if (this.length() - index > 0) {
                this.copyFromSelf(index, index + distance, this.length() - index);
            }
            object = this.top() == -1 ? this.set(distance - 1) : (this.top() >= index ? this.set(this.top() + distance) : BoxedUnit.UNIT);
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike shiftLeft$(ArrayBufferLike $this, int index, int distance) {
        return $this.shiftLeft(index, distance);
    }

    @Override
    default public ArrayBufferLike<T> shiftLeft(int index, int distance) {
        Object object;
        if (distance > 0 && index >= 0) {
            int distance2 = Math.min(index, distance);
            int offset = distance - distance2;
            if (this.length() - index - offset > 0) {
                this.copyFromSelf(index + offset, index - distance2, this.length() - index - offset);
            }
            object = this.top() >= index - distance2 ? this.set(Math.max(-1, this.top() - distance)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike moveRangeRight$(ArrayBufferLike $this, int fromIndex, int toIndex, int distance) {
        return $this.moveRangeRight(fromIndex, toIndex, distance);
    }

    @Override
    default public ArrayBufferLike<T> moveRangeRight(int fromIndex, int toIndex, int distance) {
        Object object;
        if (distance > 0 && fromIndex >= 0 && toIndex > fromIndex && fromIndex < this.length()) {
            int to = Math.min(toIndex, this.length());
            this.ensureIndex(to + distance - 1);
            Object backup = this.emptyArray(distance);
            this.slice(to, Math.min(to + distance, this.length())).copyToArray(0, backup);
            this.copyFromSelf(fromIndex, fromIndex + distance, to - fromIndex);
            this.copyFrom(backup, 0, fromIndex, ScalaRunTime$.MODULE$.array_length(backup));
            object = this.set(Math.max(this.top(), to + distance - 1));
        } else {
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike moveRangeLeft$(ArrayBufferLike $this, int fromIndex, int toIndex, int distance) {
        return $this.moveRangeLeft(fromIndex, toIndex, distance);
    }

    @Override
    default public ArrayBufferLike<T> moveRangeLeft(int fromIndex, int toIndex, int distance) {
        block0: {
            if (distance <= 0 || fromIndex < 0 || toIndex <= fromIndex || fromIndex >= this.length()) break block0;
            int from = Math.max(fromIndex, distance);
            int to = Math.min(toIndex, this.length());
            Object backup = this.emptyArray(distance);
            Slice relocating = this.slice(from - distance, fromIndex);
            relocating.copyToArray(ScalaRunTime$.MODULE$.array_length(backup) - relocating.length(), backup);
            int gap = Math.max(0, distance - fromIndex);
            this.shiftRight(0, gap);
            this.copyFromSelf(fromIndex + gap, fromIndex - distance + gap, to - fromIndex);
            this.copyFrom(backup, 0, to - distance + gap, ScalaRunTime$.MODULE$.array_length(backup));
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike swapRange$(ArrayBufferLike $this, int first, int second, int swapLength) {
        return $this.swapRange(first, second, swapLength);
    }

    @Override
    default public ArrayBufferLike<T> swapRange(int first, int second, int swapLength) {
        block0: {
            if (swapLength <= 0 || first < 0 || second < 0 || first == second || first >= this.length() || second >= this.length() || first + swapLength < 0 || second + swapLength < 0) break block0;
            int backupLength = Math.min(swapLength, this.length() - Math.max(first, second));
            Object backup = this.emptyArray(backupLength);
            this.slice(second, second + backupLength).copyToArray(0, backup);
            this.copyFromSelf(first, second, backupLength);
            this.copyFrom(backup, 0, first, backupLength);
        }
        return this;
    }

    public static /* synthetic */ ArrayBufferLike optimize$(ArrayBufferLike $this) {
        return $this.optimize();
    }

    @Override
    default public ArrayBufferLike<T> optimize() {
        return (ArrayBufferLike)this.copy();
    }

    public static void $init$(ArrayBufferLike $this) {
    }
}

