/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.IntBuffer;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JFunction1;

public final class IndexTracker$
implements Serializable {
    public static final IndexTracker$ MODULE$ = new IndexTracker$();

    private IndexTracker$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IndexTracker$.class);
    }

    public final IntBuffer trackShiftRight(int index, int distance, IntBuffer indexes) {
        if (indexes.nonEmpty() && distance > 0 && index >= 0) {
            indexes.modifyAllWhen((Function1)(JFunction1 & Serializable)_$1 -> _$1 + distance, (Function1)(JFunction1 & Serializable)_$2 -> _$2 >= index);
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackShiftRight(int index, int distance, S indexes) {
        return (S)(indexes.nonEmpty() && distance > 0 && index >= 0 ? (Seq)indexes.map((Function1)(JFunction1 & Serializable)i -> i >= index ? i + distance : i) : indexes);
    }

    public final IntBuffer trackShiftLeft(int index, int distance, IntBuffer indexes) {
        if (indexes.nonEmpty() && distance > 0 && index >= 0) {
            indexes.removeWhen((Function1)(JFunction1 & Serializable)i -> i >= index - distance && i < index);
            indexes.modifyAllWhen((Function1)(JFunction1 & Serializable)_$3 -> _$3 - distance, (Function1)(JFunction1 & Serializable)_$4 -> _$4 >= index);
            indexes.removeWhen((Function1)(JFunction1 & Serializable)_$5 -> _$5 < 0);
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackShiftLeft(int index, int distance, S indexes) {
        return (S)(indexes.nonEmpty() && distance > 0 && index >= 0 ? (Seq)((IterableOps)((IterableOps)indexes.filterNot((Function1)(JFunction1 & Serializable)i -> i >= index - distance && i < index)).map((Function1)(JFunction1 & Serializable)i -> i >= index ? i - distance : i)).filterNot((Function1)(JFunction1 & Serializable)_$6 -> _$6 < 0) : indexes);
    }

    public final IntBuffer trackMoveRangeRight(int fromIndex, int toIndex, int distance, IntBuffer indexes) {
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = fromIndex - toIndex;
            indexes.modifyAll((Function1)(JFunction1 & Serializable)i -> i >= fromIndex && i < toIndex ? i + distance : (i >= toIndex && i < toIndex + distance ? i + offset : i));
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackMoveRangeRight(int fromIndex, int toIndex, int distance, S indexes) {
        Object object;
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = fromIndex - toIndex;
            object = (Seq)indexes.map((Function1)(JFunction1 & Serializable)i -> i >= fromIndex && i < toIndex ? i + distance : (i >= toIndex && i < toIndex + distance ? i + offset : i));
        } else {
            object = indexes;
        }
        return object;
    }

    public final IntBuffer trackMoveRangeLeft(int fromIndex, int toIndex, int distance, IntBuffer indexes) {
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = toIndex - fromIndex;
            int shift = Math.max(0, distance - fromIndex);
            if (shift > 0) {
                indexes.modifyAll((Function1)(JFunction1 & Serializable)_$7 -> _$7 + shift);
            }
            indexes.modifyAll((Function1)(JFunction1 & Serializable)i -> i >= fromIndex + shift && i < toIndex + shift ? i - distance : (i >= fromIndex - distance + shift && i < fromIndex + shift ? i + offset : i));
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackMoveRangeLeft(int fromIndex, int toIndex, int distance, S indexes) {
        Object object;
        if (indexes.nonEmpty() && distance > 0 && fromIndex >= 0 && toIndex > fromIndex) {
            int offset = toIndex - fromIndex;
            int shift = Math.max(0, distance - fromIndex);
            S indexes2 = shift > 0 ? (Seq)indexes.map((Function1)(JFunction1 & Serializable)_$8 -> _$8 + shift) : indexes;
            object = (Seq)indexes2.map((Function1)(JFunction1 & Serializable)i -> i >= fromIndex + shift && i < toIndex + shift ? i - distance : (i >= fromIndex - distance + shift && i < fromIndex + shift ? i + offset : i));
        } else {
            object = indexes;
        }
        return object;
    }

    public final IntBuffer trackSwapRange(int first, int second, int swapLength, IntBuffer indexes) {
        if (indexes.nonEmpty() && swapLength > 0 && first >= 0 && second >= 0 && first != second && first + swapLength >= 0 && second + swapLength >= 0) {
            int offset = first - second;
            boolean hasLeftOverlap = Math.abs(offset) < swapLength && first < second;
            boolean hasRightOverlap = !hasLeftOverlap && Math.abs(offset) < swapLength && first > second;
            indexes.modifyAll((Function1)(JFunction1 & Serializable)i -> hasLeftOverlap && i >= first && i < second ? -1 : (hasRightOverlap && i >= second + swapLength && i < first + swapLength ? -1 : (i >= second && i < second + swapLength ? i + offset : (i >= first && i < first + swapLength ? i - offset : i))));
        }
        return indexes;
    }

    public final <S extends Seq<Object>> S trackSwapRange(int first, int second, int swapLength, S indexes) {
        Object object;
        if (indexes.nonEmpty() && swapLength > 0 && first >= 0 && second >= 0 && first != second && first + swapLength >= 0 && second + swapLength >= 0) {
            int offset = first - second;
            boolean hasLeftOverlap = Math.abs(offset) < swapLength && first < second;
            boolean hasRightOverlap = !hasLeftOverlap && Math.abs(offset) < swapLength && first > second;
            object = (Seq)indexes.map((Function1)(JFunction1 & Serializable)i -> hasLeftOverlap && i >= first && i < second ? -1 : (hasRightOverlap && i >= second + swapLength && i < first + swapLength ? -1 : (i >= second && i < second + swapLength ? i + offset : (i >= first && i < first + swapLength ? i - offset : i))));
        } else {
            object = indexes;
        }
        return object;
    }
}

