/*
 * Decompiled with CFR 0.152.
 */
package com.github.arturopala.bufferandslice;

import com.github.arturopala.bufferandslice.Buffer;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JProcedure1;

public interface Slice<T>
extends Function1<Object, T> {
    public T read(int var1);

    public static Object apply$(Slice $this, int index) {
        return $this.apply(index);
    }

    default public T apply(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("Expected an `apply` index in the interval [0," + this.length() + "), but was " + index + ".");
        }
        return this.read(index);
    }

    public <T1> Slice<T1> update(int var1, T1 var2);

    public int length();

    public static int top$(Slice $this) {
        return $this.top();
    }

    default public int top() {
        return this.length() - 1;
    }

    public static boolean isEmpty$(Slice $this) {
        return $this.isEmpty();
    }

    default public boolean isEmpty() {
        return this.length() <= 0;
    }

    public static boolean nonEmpty$(Slice $this) {
        return $this.nonEmpty();
    }

    default public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public <K> Slice<K> map(Function1<T, K> var1);

    public static int count$(Slice $this, Function1 pred) {
        return $this.count(pred);
    }

    /*
     * WARNING - void declaration
     */
    default public int count(Function1<T, Object> pred) {
        void var2_2;
        int a = 0;
        for (int i = 0; i < this.length(); ++i) {
            if (!BoxesRunTime.unboxToBoolean((Object)pred.apply(this.read(i)))) continue;
            ++a;
        }
        return (int)var2_2;
    }

    public static Object foldLeft$(Slice $this, Object initial, Function2 f) {
        return $this.foldLeft(initial, f);
    }

    /*
     * WARNING - void declaration
     */
    default public <R> R foldLeft(R initial, Function2<R, T, R> f) {
        void var3_3;
        Object acc = initial;
        for (int i = 0; i < this.length(); ++i) {
            acc = f.apply(acc, this.read(i));
        }
        return var3_3;
    }

    public static Object foldRight$(Slice $this, Object initial, Function2 f) {
        return $this.foldRight(initial, f);
    }

    /*
     * WARNING - void declaration
     */
    default public <R> R foldRight(R initial, Function2<T, R, R> f) {
        void var3_3;
        Object acc = initial;
        for (int i = this.length() - 1; i >= 0; --i) {
            acc = f.apply(this.read(i), acc);
        }
        return var3_3;
    }

    public static Object fold$(Slice $this, Object initial, Function2 f) {
        return $this.fold(initial, f);
    }

    /*
     * WARNING - void declaration
     */
    default public T fold(T initial, Function2<T, T, T> f) {
        void var3_3;
        Object acc = initial;
        for (int i = 0; i < this.length(); ++i) {
            acc = f.apply(acc, this.read(i));
        }
        return var3_3;
    }

    public static Object reduce$(Slice $this, Function2 f) {
        return $this.reduce(f);
    }

    /*
     * WARNING - void declaration
     */
    default public T reduce(Function2<T, T, T> f) {
        void var2_2;
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        Object acc = this.head();
        for (int i = 1; i < this.length(); ++i) {
            acc = f.apply(acc, this.read(i));
        }
        return var2_2;
    }

    public static Object head$(Slice $this) {
        return $this.head();
    }

    default public T head() {
        if (this.length() <= 0) {
            throw new NoSuchElementException();
        }
        return this.read(0);
    }

    public static Object last$(Slice $this) {
        return $this.last();
    }

    default public T last() {
        if (this.length() <= 0) {
            throw new NoSuchElementException();
        }
        return this.read(this.length() - 1);
    }

    public static Option headOption$(Slice $this) {
        return $this.headOption();
    }

    default public Option<T> headOption() {
        return this.length() > 0 ? Some$.MODULE$.apply(this.read(0)) : None$.MODULE$;
    }

    public static Option lastOption$(Slice $this) {
        return $this.lastOption();
    }

    default public Option<T> lastOption() {
        return this.length() > 0 ? Some$.MODULE$.apply(this.read(this.length() - 1)) : None$.MODULE$;
    }

    public static Option get$(Slice $this, int index) {
        return $this.get(index);
    }

    default public Option<T> get(int index) {
        return index < 0 || index >= this.length() ? None$.MODULE$ : Some$.MODULE$.apply(this.read(index));
    }

    public static Option find$(Slice $this, Function1 pred) {
        return $this.find(pred);
    }

    /*
     * WARNING - void declaration
     */
    default public Option<T> find(Function1<T, Object> pred) {
        void var2_2;
        None$ result = None$.MODULE$;
        int i = 0;
        while (i < this.length()) {
            T v = this.read(i);
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(v))) {
                result = Some$.MODULE$.apply(v);
                i = this.length() + 1;
                continue;
            }
            ++i;
        }
        return var2_2;
    }

    public static boolean exists$(Slice $this, Function1 pred) {
        return $this.exists(pred);
    }

    default public boolean exists(Function1<T, Object> pred) {
        int i = 0;
        while (i >= 0 && i < this.length()) {
            T v = this.read(i);
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(v))) {
                i = -1;
                continue;
            }
            ++i;
        }
        return i < 0;
    }

    public Slice slice(int var1, int var2);

    public static Slice tail$(Slice $this) {
        return $this.tail();
    }

    default public Slice tail() {
        return this.drop(1);
    }

    public static Slice init$(Slice $this) {
        return $this.init();
    }

    default public Slice init() {
        return this.dropRight(1);
    }

    public static Slice take$(Slice $this, int n) {
        return $this.take(n);
    }

    default public Slice take(int n) {
        return this.slice(0, n);
    }

    public static Slice takeRight$(Slice $this, int n) {
        return $this.takeRight(n);
    }

    default public Slice takeRight(int n) {
        return this.slice(this.length() - n, this.length());
    }

    public static Slice drop$(Slice $this, int n) {
        return $this.drop(n);
    }

    default public Slice drop(int n) {
        return this.slice(n, this.length());
    }

    public static Slice dropRight$(Slice $this, int n) {
        return $this.dropRight(n);
    }

    default public Slice dropRight(int n) {
        return this.slice(0, this.length() - n);
    }

    public static Iterator iterator$(Slice $this) {
        return $this.iterator();
    }

    default public Iterator<T> iterator() {
        return new IterableOnce(this){
            private int i;
            private final Slice $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
            }

            public int i() {
                return this.i;
            }

            public void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.$outer.length();
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                T value = this.$outer.read(this.i());
                this.i_$eq(this.i() + 1);
                return var1_1;
            }
        };
    }

    public static Iterator iterator$(Slice $this, Function1 pred) {
        return $this.iterator(pred);
    }

    default public Iterator<T> iterator(Function1<T, Object> pred) {
        return this.indexIterator(pred).map((Function1)((JFunction1 & Serializable)this::iterator$$anonfun$adapted$1));
    }

    public static Iterator indexIterator$(Slice $this, Function1 pred) {
        return $this.indexIterator(pred);
    }

    default public Iterator<Object> indexIterator(Function1<T, Object> pred) {
        return new IterableOnce(pred, this){
            private final Function1 pred$1;
            private int i;
            private final Slice $outer;
            {
                this.pred$1 = pred$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = 0;
                this.seekNext();
            }

            public int i() {
                return this.i;
            }

            public void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() < this.$outer.length();
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                void var1_1;
                int item = this.i();
                this.i_$eq(this.i() + 1);
                this.seekNext();
                return (int)var1_1;
            }

            public void seekNext() {
                if (this.i() < this.$outer.length()) {
                    T v = this.$outer.read(this.i());
                    while (!BoxesRunTime.unboxToBoolean((Object)this.pred$1.apply(v)) && this.i() < this.$outer.length()) {
                        this.i_$eq(this.i() + 1);
                        if (this.i() >= this.$outer.length()) continue;
                        v = this.$outer.read(this.i());
                    }
                }
            }
        };
    }

    public static Iterator reverseIterator$(Slice $this) {
        return $this.reverseIterator();
    }

    default public Iterator<T> reverseIterator() {
        return new IterableOnce(this){
            private int i;
            private final Slice $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = $outer.length() - 1;
            }

            public int i() {
                return this.i;
            }

            public void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() >= 0;
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                void var1_1;
                T value = this.$outer.read(this.i());
                this.i_$eq(this.i() - 1);
                return var1_1;
            }
        };
    }

    public static Iterator reverseIterator$(Slice $this, Function1 pred) {
        return $this.reverseIterator(pred);
    }

    default public Iterator<T> reverseIterator(Function1<T, Object> pred) {
        return this.reverseIndexIterator(pred).map((Function1)((JFunction1 & Serializable)this::reverseIterator$$anonfun$adapted$1));
    }

    public static Iterator reverseIndexIterator$(Slice $this, Function1 pred) {
        return $this.reverseIndexIterator(pred);
    }

    default public Iterator<Object> reverseIndexIterator(Function1<T, Object> pred) {
        return new IterableOnce(pred, this){
            private final Function1 pred$1;
            private int i;
            private final Slice $outer;
            {
                this.pred$1 = pred$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.i = $outer.length() - 1;
                this.seekNext();
            }

            public int i() {
                return this.i;
            }

            public void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return this.i() >= 0;
            }

            /*
             * WARNING - void declaration
             */
            public int next() {
                void var1_1;
                int item = this.i();
                this.i_$eq(this.i() - 1);
                this.seekNext();
                return (int)var1_1;
            }

            public void seekNext() {
                if (this.i() >= 0) {
                    T v = this.$outer.read(this.i());
                    while (!BoxesRunTime.unboxToBoolean((Object)this.pred$1.apply(v)) && this.i() >= 0) {
                        this.i_$eq(this.i() - 1);
                        if (this.i() < 0) continue;
                        v = this.$outer.read(this.i());
                    }
                }
            }
        };
    }

    public static List toList$(Slice $this) {
        return $this.toList();
    }

    default public List<T> toList() {
        return this.iterator().toList();
    }

    public static Seq toSeq$(Slice $this) {
        return $this.toSeq();
    }

    default public Seq<T> toSeq() {
        return this.iterator().toIndexedSeq();
    }

    public static Iterable asIterable$(Slice $this) {
        return $this.asIterable();
    }

    default public Iterable<T> asIterable() {
        return new AbstractIterable(this){
            private final Slice $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Iterator iterator() {
                return this.$outer.iterator();
            }

            public String toString() {
                return this.$outer.toString();
            }
        };
    }

    public static Object toArray$(Slice $this, ClassTag evidence$1) {
        return $this.toArray(evidence$1);
    }

    /*
     * WARNING - void declaration
     */
    default public <T1> Object toArray(ClassTag<T1> evidence$1) {
        void var2_2;
        Object newArray = Arrays$.MODULE$.newGenericArray(this.length(), evidence$1);
        this.copyToArray(0, newArray);
        return var2_2;
    }

    public Object asArray();

    public Slice detach();

    public static Object copyToArray$(Slice $this, int targetIndex, Object targetArray) {
        return $this.copyToArray(targetIndex, targetArray);
    }

    default public <T1> Object copyToArray(int targetIndex, Object targetArray) {
        for (int i = 0; i < this.length(); ++i) {
            ScalaRunTime$.MODULE$.array_update(targetArray, targetIndex + i, this.read(i));
        }
        return targetArray;
    }

    public <T1> Buffer<T1> toBuffer();

    public Buffer<T> asBuffer();

    public static String toString$(Slice $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.iterator().take(Math.min(20, this.length())).mkString("Slice(", ",", this.length() > 20 ? ", ... )" : ")");
    }

    public static boolean equals$(Slice $this, Object obj) {
        return $this.equals(obj);
    }

    default public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof Slice) {
            Slice other = (Slice)object;
            bl = this.length() == other.length() && this.sameElements(this.iterator(), other.iterator());
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean sameElements(Iterator<T> iterator1, Iterator<T> iterator2) {
        void var3_3;
        boolean result = true;
        while (result && iterator1.hasNext() && iterator2.hasNext()) {
            Object t1 = iterator1.next();
            Object t2 = iterator2.next();
            result = result && BoxesRunTime.equals((Object)t1, (Object)t2);
        }
        return (boolean)var3_3;
    }

    public static int hashCode$(Slice $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        int n;
        IntRef hash = IntRef.create((int)17);
        hash.elem = n = hash.elem * 31 + this.length();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length()).by(Math.max(1, this.length() / 7)).foreach((Function1)(JProcedure1 & Serializable)i -> {
            int n;
            hash$1.elem = n = hash$1.elem * 31 + this.read((int)i).hashCode();
        });
        return hash.elem;
    }

    private /* synthetic */ Object iterator$$anonfun$1(int index) {
        return this.read(index);
    }

    private Object iterator$$anonfun$adapted$1(Object index) {
        return this.iterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)index));
    }

    private /* synthetic */ Object reverseIterator$$anonfun$1(int index) {
        return this.read(index);
    }

    private Object reverseIterator$$anonfun$adapted$1(Object index) {
        return this.reverseIterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)index));
    }
}

