/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator.template.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.test4j.generator.mybatis.config.impl.TableField;
import org.test4j.generator.mybatis.config.impl.TableSetter;
import org.test4j.generator.mybatis.template.BaseTemplate;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.commons.TextBuilder;

public class EntityTemplate
extends BaseTemplate {
    public EntityTemplate() {
        super("templates/entity/Entity.java.vm", "entity/*Entity.java");
    }

    public String getTemplateId() {
        return "entity";
    }

    protected void templateConfigs(TableSetter table, Map<String, Object> templateContext) {
        this.putInterfaces(templateContext, table, table.getEntityInterfaces());
        templateContext.put("primaryKey", this.findPrimaryKey(table));
        HashMap<String, String> annotation = new HashMap<String, String>();
        for (TableField field : table.getFields()) {
            String text = this.fieldAnnotation(table, field);
            annotation.put(field.getName(), text);
        }
        templateContext.put("annotation", annotation);
    }

    private String findPrimaryKey(TableSetter table) {
        for (TableField field : table.getFields()) {
            if (!field.isPrimary()) continue;
            return field.getName();
        }
        return "null";
    }

    private void putInterfaces(Map<String, Object> templateContext, TableSetter table, Map<String, String> interfaces) {
        if (interfaces == null || interfaces.size() == 0) {
            return;
        }
        templateContext.put("interface", interfaces.values().stream().map(i -> "import " + i + ";").collect(Collectors.joining("\n")));
        templateContext.put("interfaceName", interfaces.keySet().stream().map(str -> super.replace(str, table.getContext(), new String[]{"${entity}"})).collect(Collectors.joining(", ", ", ", "")));
    }

    private String fieldAnnotation(TableSetter table, TableField field) {
        TextBuilder text = TextBuilder.build();
        if (field.isPrimary()) {
            text.quotas("@TableId(value = '%s'", new Object[]{field.getColumnName()});
            if (!field.isPrimaryId()) {
                text.append(", auto = false", new Object[0]);
            }
            if (!StringHelper.isBlank((String)table.getSeqName())) {
                text.quotas(", seqName='%s'", new Object[]{table.getSeqName()});
            }
            text.append(")", new Object[0]);
        } else {
            text.quotas("@TableField(value = '%s'", new Object[]{field.getColumnName()});
            if (StringHelper.isNotBlank((String)field.getInsert())) {
                text.quotas(", insert = '%s'", new Object[]{field.getInsert()});
            }
            if (StringHelper.isNotBlank((String)field.getUpdate())) {
                text.quotas(", update = '%s'", new Object[]{field.getUpdate()});
            }
            if (field.getIsLarge() != null && !field.getIsLarge().booleanValue()) {
                text.quotas(", notLarge = false", new Object[0]);
            }
            if (StringHelper.isNotBlank((String)field.getTypeHandler())) {
                text.quotas(", typeHandler = '%s'", new Object[]{field.getTypeHandler()});
            }
            text.append(")", new Object[0]);
        }
        return text.toString();
    }
}

