/*
 * Decompiled with CFR 0.152.
 */
package co.com.bancolombia.secretsmanager.connector;

import co.com.bancolombia.secretsmanager.api.GenericManagerAsync;
import co.com.bancolombia.secretsmanager.api.exceptions.SecretException;
import co.com.bancolombia.secretsmanager.config.AWSParameterStoreConfig;
import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.SsmAsyncClientBuilder;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;

public class AWSParameterStoreConnectorAsync
implements GenericManagerAsync {
    private final AWSParameterStoreConfig config;
    private SsmAsyncClient client;
    private AsyncCache<String, String> cache;
    private Logger logger = Logger.getLogger("connector.AWSSecretManagerConnector");

    public AWSParameterStoreConnectorAsync(AWSParameterStoreConfig config) {
        this.config = config;
        this.client = this.buildClient();
        this.cache = this.initCache();
    }

    public Mono<String> getSecret(String secretName) {
        return Mono.fromFuture((CompletableFuture)this.cache.get((Object)secretName, (s, executor) -> this.getSecretValue(secretName).toFuture().toCompletableFuture()));
    }

    public <T> Mono<T> getSecret(String secretName, Class<T> cls) {
        return Mono.error((Throwable)new UnsupportedOperationException("Serialization doesn't apply for parameter store connector"));
    }

    private Mono<String> getSecretValue(String secretName) {
        GetParameterRequest getParameterRequest = (GetParameterRequest)GetParameterRequest.builder().name(secretName).build();
        return Mono.fromFuture((CompletableFuture)this.client.getParameter(getParameterRequest)).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new SecretException("Secret value is null")))).flatMap(secretResult -> {
            if (secretResult.parameter().value() != null) {
                String result = secretResult.parameter().value();
                return Mono.just((Object)result);
            }
            return Mono.error((Throwable)new SecretException("Secret value is not a String"));
        }).doOnError(err -> this.logger.warning("Error retrieving the secret: " + err.getMessage()));
    }

    private SsmAsyncClient buildClient() {
        SsmAsyncClientBuilder clientBuilder = (SsmAsyncClientBuilder)((SsmAsyncClientBuilder)SsmAsyncClient.builder().credentialsProvider((AwsCredentialsProvider)this.getProviderChain())).region(this.config.getRegion());
        if (!this.config.getEndpoint().equals("")) {
            clientBuilder.endpointOverride(URI.create(this.config.getEndpoint()));
        }
        return (SsmAsyncClient)clientBuilder.build();
    }

    private AsyncCache<String, String> initCache() {
        return Caffeine.newBuilder().maximumSize((long)this.config.getCacheSize()).expireAfterWrite((long)this.config.getCacheSeconds(), TimeUnit.SECONDS).buildAsync();
    }

    private AwsCredentialsProviderChain getProviderChain() {
        return AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)SystemPropertyCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)WebIdentityTokenFileCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)ContainerCredentialsProvider.builder().build()).addCredentialsProvider((AwsCredentialsProvider)InstanceProfileCredentialsProvider.create()).build();
    }
}

