/*
 * Decompiled with CFR 0.152.
 */
package steed.hibernatemaster.domain;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Transient;
import org.hibernate.Hibernate;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.internal.PersistentSet;
import steed.hibernatemaster.domain.BaseDatabaseDomain;
import steed.hibernatemaster.util.DaoUtil;
import steed.hibernatemaster.util.HqlGenerator;
import steed.util.base.BaseUtil;
import steed.util.base.DomainUtil;
import steed.util.logging.LoggerFactory;
import steed.util.reflect.ReflectUtil;

public class BaseRelationalDatabaseDomain
extends BaseDatabaseDomain {
    private static final long serialVersionUID = -3084039108845387366L;
    protected HqlGenerator personalHqlGenerator;
    private boolean trimEmptyDomain;

    @Transient
    public HqlGenerator getPersonalHqlGenerator() {
        return this.personalHqlGenerator;
    }

    public void setPersonalHqlGenerator(HqlGenerator personalHqlGenerator) {
        this.personalHqlGenerator = personalHqlGenerator;
    }

    public void initialize() {
        Hibernate.initialize((Object)this);
    }

    protected void domainInitializeAll(BaseRelationalDatabaseDomain domain) {
        if (domain != null) {
            domain.initializeAll();
        }
    }

    protected void domainInitializeSetAll(Collection<? extends BaseRelationalDatabaseDomain> set) {
        if (set != null) {
            for (BaseRelationalDatabaseDomain baseRelationalDatabaseDomain : set) {
                baseRelationalDatabaseDomain.initializeAll();
            }
        }
    }

    public void initializeAll() {
        this.initialize();
    }

    @Override
    public <T extends BaseDatabaseDomain> T smartGet() {
        return (T)DaoUtil.smartGet(this);
    }

    @Override
    public <T extends BaseDatabaseDomain> T smartLoad() {
        return (T)DaoUtil.smartLoad(this);
    }

    @Override
    public boolean update() {
        this.trimEmptyDomain();
        return DaoUtil.update(this);
    }

    @Override
    public boolean delete() {
        return DaoUtil.delete(this);
    }

    @Transient
    public boolean isTrimEmptyDomain() {
        return this.trimEmptyDomain;
    }

    public void setTrimEmptyDomain(boolean trimEmptyDomain) {
        this.trimEmptyDomain = trimEmptyDomain;
    }

    protected void trimEmptyDomain() {
        if (!this.isTrimEmptyDomain()) {
            return;
        }
        List<Field> notFinalFields = ReflectUtil.getNotFinalFields(this);
        for (Field temp : notFinalFields) {
            if (!BaseRelationalDatabaseDomain.class.isAssignableFrom(temp.getType())) continue;
            try {
                temp.setAccessible(true);
                Object obj = temp.get(this);
                if (obj == null || !BaseUtil.isObjEmpty(obj)) continue;
                temp.set(this, null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean save() {
        this.trimEmptyDomain();
        return DaoUtil.save(this);
    }

    @Override
    public boolean saveOrUpdate() {
        if (BaseUtil.isObjEmpty(DomainUtil.getDomainId(this))) {
            return this.save();
        }
        Object smartGet = this.smartGet();
        if (smartGet != null) {
            DaoUtil.evict(smartGet);
            return this.update();
        }
        return this.save();
    }

    @Override
    public boolean updateNotNullField(List<String> updateEvenNull) {
        return this.updateNotNullField(updateEvenNull, true);
    }

    @Override
    public boolean updateNotNullField(List<String> updateEvenNull, boolean strictlyMode) {
        BaseRelationalDatabaseDomain smartGet = (BaseRelationalDatabaseDomain)this.smartGet();
        DomainUtil.fillDomain(smartGet, this, updateEvenNull, strictlyMode);
        return smartGet.update();
    }

    public <T> List<T> listAll() {
        return DaoUtil.listAllObj(this);
    }

    public BaseRelationalDatabaseDomain hibernateProxCollection2javaCollection() {
        this.initializeAll();
        try {
            for (Field f : ReflectUtil.getNotFinalFields(this)) {
                f.setAccessible(true);
                try {
                    Collection<?> value = f.get(this);
                    if (value instanceof Collection) {
                        Collection temp = value;
                        value = this.getCollection(f.getType(), value);
                        for (Object o : temp) {
                            if (o instanceof BaseRelationalDatabaseDomain) {
                                o = ((BaseRelationalDatabaseDomain)o).hibernateProxCollection2javaCollection();
                            }
                            value.add(o);
                        }
                    } else {
                        if (!(value instanceof BaseRelationalDatabaseDomain)) continue;
                        value = ((BaseRelationalDatabaseDomain)((Object)value)).hibernateProxCollection2javaCollection();
                    }
                    f.set(this, value);
                }
                catch (IllegalAccessException e) {
                    LoggerFactory.getLogger().debug("copyObj", e);
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error("hibernate\u4ee3\u7406Collection\u8f6cjava\u5185\u7f6eCollection\u5931\u8d25!!", e);
        }
        return this;
    }

    protected final Collection<?> getCollection(Class<?> type, Collection<?> value) {
        if (value instanceof PersistentSet && type.isAssignableFrom(HashSet.class)) {
            return new HashSet();
        }
        if (value instanceof PersistentList && type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        return value;
    }
}

