/*
 * Decompiled with CFR 0.152.
 */
package steed.hibernatemaster.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import steed.hibernatemaster.Config;
import steed.hibernatemaster.domain.BaseDatabaseDomain;
import steed.hibernatemaster.domain.BaseDomain;
import steed.hibernatemaster.domain.BaseRelationalDatabaseDomain;
import steed.hibernatemaster.domain.BaseUnionKeyDomain;
import steed.hibernatemaster.domain.Page;
import steed.hibernatemaster.util.HibernateUtil;
import steed.hibernatemaster.util.HqlGenerator;
import steed.util.base.BaseUtil;
import steed.util.base.CollectionsUtil;
import steed.util.base.DomainUtil;
import steed.util.base.RegUtil;
import steed.util.base.StringUtil;
import steed.util.logging.LoggerFactory;
import steed.util.reflect.ReflectResult;
import steed.util.reflect.ReflectUtil;

public class DaoUtil {
    private static final ThreadLocal<Boolean> transactionType = new ThreadLocal();
    private static final ThreadLocal<Exception> exception = new ThreadLocal();
    private static final ThreadLocal<Transaction> currentTransaction = new ThreadLocal();
    public static final String personalHqlGeneratorKey = "personalHqlGenerator";
    private static final ThreadLocal<Boolean> autoManagTransaction = new ThreadLocal();
    public static final String[] indexSuffix = new String[]{"_max_1", "_min_1", "_like_1", "_not_in_1", "_not_equal_1", "_not_join", "_not_null", "_not_compile_param", "personalHqlGenerator"};

    private DaoUtil() {
    }

    public static final Exception getExceptiontype() {
        return exception.get();
    }

    public static final void setException(Exception exception, boolean rollbackTransaction) {
        DaoUtil.exception.set(exception);
        LoggerFactory.getLogger().error("\u6570\u636e\u5e93\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", exception);
    }

    public static final void setException(Exception exception) {
        DaoUtil.setException(exception, false);
    }

    public static final Transaction getCurrentTransaction() {
        return currentTransaction.get();
    }

    public static final void setCurrentTransaction(Transaction currentTransaction) {
        DaoUtil.currentTransaction.set(currentTransaction);
    }

    public static final Boolean getTransactionType() {
        return transactionType.get();
    }

    public static final void setTransactionType(Boolean transactionType) {
        DaoUtil.transactionType.set(transactionType);
    }

    public static final Boolean getAutoManagTransaction() {
        return autoManagTransaction.get();
    }

    public static final ImmediatelyTransactionData immediatelyTransactionBegin() {
        LoggerFactory.getLogger().debug("\u7acb\u5373\u4e8b\u52a1\u5f00\u59cb");
        Session session = DaoUtil.getSession();
        Transaction currentTransaction = DaoUtil.getCurrentTransaction();
        Boolean autoManagTransaction = DaoUtil.getAutoManagTransaction();
        Boolean transactionType = DaoUtil.getTransactionType();
        DaoUtil.setCurrentTransaction(null);
        DaoUtil.setTransactionType(null);
        ImmediatelyTransactionData immediatelyTransactionData = new ImmediatelyTransactionData(currentTransaction, autoManagTransaction, session);
        immediatelyTransactionData.transactionType = transactionType;
        HibernateUtil.setSession(null);
        return immediatelyTransactionData;
    }

    public static final void immediatelyTransactionEnd(ImmediatelyTransactionData immediatelyTransactionData) {
        HibernateUtil.closeSession();
        DaoUtil.setTransactionType(immediatelyTransactionData.transactionType);
        DaoUtil.setCurrentTransaction(immediatelyTransactionData.currentTransaction);
        DaoUtil.setAutoManagTransaction(immediatelyTransactionData.autoManagTransaction);
        HibernateUtil.setSession(immediatelyTransactionData.session);
        LoggerFactory.getLogger().debug("\u7acb\u5373\u4e8b\u52a1\u7ed3\u675f");
    }

    public static final void setAutoManagTransaction(Boolean selfManagTransaction) {
        autoManagTransaction.set(selfManagTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> Page<T> listObj(int pageSize, int currentPage, Class<? extends BaseRelationalDatabaseDomain> t) {
        try {
            StringBuffer hql = DaoUtil.getSelectHql(t, null, null, null, new String[0]);
            Long recordCount = DaoUtil.getRecordCount(null, hql);
            Query query = DaoUtil.getSession().createQuery(hql.toString());
            DaoUtil.faging(pageSize, currentPage, query);
            List list = query.list();
            Page<T> page = DaoUtil.setPage(currentPage, recordCount, pageSize, list);
            return page;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            Page<T> page = null;
            return page;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> List<Serializable> listAllObjKey(Class<? extends BaseRelationalDatabaseDomain> target) {
        try {
            String name = target.getName();
            String keyName = DomainUtil.getDomainIDName(target);
            String hql = "select " + keyName + " from " + name;
            Query query = DaoUtil.getSession().createQuery(hql);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List<Serializable> list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean saveList(List<? extends BaseRelationalDatabaseDomain> list) {
        Session session = null;
        try {
            session = DaoUtil.getSession();
            DaoUtil.beginTransaction();
            for (BaseRelationalDatabaseDomain baseRelationalDatabaseDomain : list) {
                session.save((Object)baseRelationalDatabaseDomain);
            }
            boolean bl = DaoUtil.managTransaction(true);
            return bl;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = DaoUtil.managTransaction(false);
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> List<T> listByKeys(Class<? extends BaseRelationalDatabaseDomain> target, String[] ids) {
        try {
            Object[] serializables;
            if (ids == null || ids.length == 0) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<? extends Serializable> idClass = DomainUtil.getDomainIDClass(target);
            if (idClass == String.class) {
                serializables = ids;
            } else {
                serializables = new Serializable[ids.length];
                for (int i = 0; i < serializables.length; ++i) {
                    serializables[i] = ReflectUtil.convertFromString(idClass, ids[i]);
                }
            }
            map.put(DomainUtil.getDomainIDName(target) + "_not_join", serializables);
            List<? extends BaseRelationalDatabaseDomain> list = DaoUtil.listAllObj(target, map, null, null);
            return list;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List<T> list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean updateList(List<? extends BaseRelationalDatabaseDomain> list) {
        Session session = null;
        try {
            session = DaoUtil.getSession();
            DaoUtil.beginTransaction();
            for (BaseRelationalDatabaseDomain baseRelationalDatabaseDomain : list) {
                session.update((Object)baseRelationalDatabaseDomain);
            }
            boolean bl = DaoUtil.managTransaction(true);
            return bl;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = DaoUtil.managTransaction(false);
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final int updateListNotNullFieldOneByOne(List<? extends BaseRelationalDatabaseDomain> list, List<String> updateEvenNull) {
        int failed = 0;
        for (BaseRelationalDatabaseDomain baseRelationalDatabaseDomain : list) {
            if (DaoUtil.updateNotNullField(baseRelationalDatabaseDomain, updateEvenNull)) continue;
            ++failed;
        }
        return failed;
    }

    public static final void evict(Object obj) {
        DaoUtil.getSession().evict(obj);
        DaoUtil.closeSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean saveOrUpdate(BaseRelationalDatabaseDomain obj) {
        Session session = null;
        try {
            session = DaoUtil.getSession();
            DaoUtil.beginTransaction();
            if (BaseUtil.isObjEmpty(DomainUtil.getDomainId(obj))) {
                boolean bl = DaoUtil.save(obj);
                return bl;
            }
            BaseRelationalDatabaseDomain smartGet22 = DaoUtil.smartGet(obj);
            if (smartGet22 != null) {
                session.evict((Object)smartGet22);
                session.update((Object)obj);
            } else {
                session.save((Object)obj);
            }
            boolean smartGet22 = DaoUtil.managTransaction(true);
            return smartGet22;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = DaoUtil.managTransaction(false);
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final int executeUpdateBySql(String hql, Map<String, ? extends Object> map) {
        return DaoUtil.executeUpdate(hql, map, 1);
    }

    public static final int executeUpdate(String hql, Map<String, ? extends Object> map) {
        return DaoUtil.executeUpdate(hql, map, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getUniqueResult(String hql, String domainSimpleName, Map<String, Object> map) {
        try {
            StringBuffer sb = new StringBuffer(hql);
            if (domainSimpleName != null && map != null) {
                DaoUtil.appendHqlWhere(domainSimpleName, sb, map);
            }
            Query createQuery = DaoUtil.getSession().createQuery(sb.toString());
            if (map != null) {
                DaoUtil.setMapParam(map, createQuery);
            }
            Object object = createQuery.uniqueResult();
            return object;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getQueryResult(String hql, String domainSimpleName, Map<String, Object> map) {
        try {
            StringBuffer sb = new StringBuffer(hql);
            if (domainSimpleName != null && map != null) {
                DaoUtil.appendHqlWhere(domainSimpleName, sb, map);
            }
            Query createQuery = DaoUtil.getSession().createQuery(sb.toString());
            if (map != null) {
                DaoUtil.setMapParam(map, createQuery);
            }
            List list = createQuery.list();
            return list;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Page getQueryResult(String hql, String domainSimpleName, Map<String, Object> map, int pageSize, int currentPage) {
        try {
            StringBuffer sb = new StringBuffer(hql);
            if (map != null && domainSimpleName != null) {
                DaoUtil.appendHqlWhere(domainSimpleName, sb, map);
            }
            Long recordCount = DaoUtil.getRecordCount(map, sb);
            Query createQuery = DaoUtil.getSession().createQuery(sb.toString());
            if (map != null) {
                DaoUtil.setMapParam(map, createQuery);
            }
            DaoUtil.faging(pageSize, currentPage, createQuery);
            Page page = DaoUtil.setPage(currentPage, recordCount, pageSize, createQuery.list());
            return page;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            Page page = null;
            return page;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getQueryResultBysql(String sql, Map<String, ? extends Object> param) {
        try {
            SQLQuery createQuery = DaoUtil.getSession().createSQLQuery(sql);
            if (param != null) {
                DaoUtil.setMapParam(param, (Query)createQuery);
            }
            List list = createQuery.list();
            return list;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getQueryResult(String hql, Map<String, ? extends Object> map, int pageSize, int currentPage) {
        try {
            Query createQuery = DaoUtil.getSession().createQuery(hql);
            if (map != null) {
                DaoUtil.setMapParam(map, createQuery);
            }
            DaoUtil.faging(pageSize, currentPage, createQuery);
            List list = createQuery.list();
            return list;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getQueryResult(String hql, Map<String, ? extends Object> map) {
        try {
            Query createQuery = DaoUtil.getSession().createQuery(hql);
            if (map != null) {
                DaoUtil.setMapParam(map, createQuery);
            }
            List list = createQuery.list();
            return list;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeUpdate(String ql, Map<String, ? extends Object> map, int type) {
        Session session = null;
        try {
            session = DaoUtil.getSession();
            DaoUtil.beginTransaction();
            Object createQuery = type == 0 ? session.createQuery(ql) : session.createSQLQuery(ql);
            if (map != null) {
                DaoUtil.setMapParam(map, createQuery);
            }
            int executeUpdate = createQuery.executeUpdate();
            DaoUtil.managTransaction(true);
            int n = executeUpdate;
            return n;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            DaoUtil.managTransaction(false);
            int n = -1;
            return n;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final int updateByQuery(BaseDomain queryCondition, Map<String, Object> updated) {
        return DaoUtil.updateByQuery(queryCondition.getClass(), DaoUtil.putField2Map(queryCondition), updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int updateByQuery(Class<?> clazz, Map<String, Object> queryCondition, Map<String, Object> updated) {
        try {
            DaoUtil.beginTransaction();
            StringBuffer updateHql = DaoUtil.getUpdateHql(clazz, queryCondition, updated);
            for (Map.Entry<String, Object> temp : updated.entrySet()) {
                queryCondition.put("steedUpdate_" + temp.getKey(), temp.getValue());
            }
            Query query = DaoUtil.createQuery(queryCondition, updateHql);
            int count = query.executeUpdate();
            if (DaoUtil.managTransaction(true)) {
                int n = count;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            DaoUtil.managTransaction(false);
            int n = -1;
            return n;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final int deleteByQuery(BaseRelationalDatabaseDomain obj) {
        HashMap<String, Object> queryCondition = new HashMap<String, Object>();
        DaoUtil.putField2Map(obj, queryCondition, "");
        return DaoUtil.deleteByQuery(obj.getClass(), queryCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int deleteByQuery(Class<? extends BaseRelationalDatabaseDomain> clazz, Map<String, Object> where) {
        try {
            DaoUtil.beginTransaction();
            Query query = DaoUtil.createQuery(where, DaoUtil.getDeleteHql(clazz, where));
            int count = query.executeUpdate();
            if (DaoUtil.managTransaction(true)) {
                int n = count;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Exception e) {
            DaoUtil.managTransaction(false);
            DaoUtil.setException(e);
            int n = -1;
            return n;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    @Deprecated
    public static final boolean cascadeDelete(BaseRelationalDatabaseDomain domain, List<Class<?>> domainSkip) {
        DaoUtil.beginTransaction();
        if (domainSkip == null) {
            domainSkip = new ArrayList();
        }
        boolean delete = DaoUtil.deleteConneced(domain, Integer.MAX_VALUE, domainSkip);
        DaoUtil.managTransaction(delete);
        return delete;
    }

    public static final boolean delete(Class<? extends BaseRelationalDatabaseDomain> clazz, Serializable id) {
        try {
            BaseRelationalDatabaseDomain newInstance = clazz.newInstance();
            DomainUtil.setDomainId(newInstance, id);
            return DaoUtil.delete(newInstance);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LoggerFactory.getLogger().error(clazz + "\u5b9e\u4f8b\u5316\u5931\u8d25\uff01\uff01", e);
            throw new RuntimeException(clazz + "\u5b9e\u4f8b\u5316\u5931\u8d25\uff01\uff01", e);
        }
    }

    public static final int deleteByIds(Class<? extends BaseRelationalDatabaseDomain> clazz, Serializable ... ids) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DomainUtil.getDomainIDName(clazz) + "_not_join", ids);
        return DaoUtil.deleteByQuery(clazz, map);
    }

    public static final int smartDeleteByIds(Class<? extends BaseRelationalDatabaseDomain> clazz, String ... ids) {
        Object[] serializables;
        Class<? extends Serializable> idClass = DomainUtil.getDomainIDClass(clazz);
        if (idClass == String.class) {
            serializables = ids;
        } else {
            serializables = new Serializable[ids.length];
            for (int i = 0; i < serializables.length; ++i) {
                serializables[i] = ReflectUtil.convertFromString(idClass, ids[i]);
            }
        }
        return DaoUtil.deleteByIds(clazz, (Serializable[])serializables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean delete(BaseRelationalDatabaseDomain domain) {
        Session session = null;
        try {
            session = DaoUtil.getSession();
            DaoUtil.beginTransaction();
            session.delete((Object)domain);
            boolean bl = DaoUtil.managTransaction(true);
            return bl;
        }
        catch (NonUniqueObjectException e1) {
            try {
                session.delete((Object)DaoUtil.smartGet(domain));
                boolean bl = DaoUtil.managTransaction(true);
                return bl;
            }
            catch (Exception e) {
                DaoUtil.setException(e);
                boolean bl = DaoUtil.managTransaction(false);
                return bl;
            }
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = DaoUtil.managTransaction(false);
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean deleteConneced(BaseRelationalDatabaseDomain obj, int level, List<Class<?>> domainSkip) {
        if (level-- == 0) {
            return true;
        }
        Session session = null;
        try {
            session = DaoUtil.getSession();
            BaseRelationalDatabaseDomain smartGet = DaoUtil.smartGet(obj);
            if (smartGet == null) {
                boolean bl = true;
                return bl;
            }
            for (Field temp : smartGet.getClass().getDeclaredFields()) {
                Class<?> type;
                block25: {
                    try {
                        type = temp.getType();
                        if (domainSkip.contains(temp)) continue;
                        if (BaseRelationalDatabaseDomain.class.isAssignableFrom(type)) {
                            if (ReflectUtil.getAnnotation(OneToOne.class, smartGet.getClass(), temp) == null) continue;
                            temp.setAccessible(true);
                            BaseRelationalDatabaseDomain object = (BaseRelationalDatabaseDomain)temp.get(smartGet);
                            if (BaseUtil.isObjEmpty(object)) continue;
                            if (!DaoUtil.deleteConneced(object, level, domainSkip)) {
                                boolean bl = false;
                                return bl;
                            }
                            session.delete((Object)object);
                        }
                        break block25;
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!Collection.class.isAssignableFrom(type) || ReflectUtil.getAnnotation(OneToMany.class, smartGet.getClass(), temp) == null) continue;
                temp.setAccessible(true);
                Collection collection = (Collection)temp.get(smartGet);
                Class<?> c = ReflectUtil.getGenericType(temp);
                if (!BaseRelationalDatabaseDomain.class.isAssignableFrom(c)) continue;
                for (Object o : collection) {
                    if (DaoUtil.deleteConneced((BaseRelationalDatabaseDomain)o, level, domainSkip)) continue;
                    boolean bl = false;
                    return bl;
                }
                {
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            session.delete((Object)obj);
            boolean bl = DaoUtil.managTransaction(true);
            return bl;
        }
        catch (NonUniqueObjectException e1) {
            try {
                session.delete((Object)DaoUtil.smartGet(obj));
                boolean bl = DaoUtil.managTransaction(true);
                return bl;
            }
            catch (Exception e) {
                DaoUtil.setException(e);
                int n = DaoUtil.managTransaction(false);
                return n != 0;
            }
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = DaoUtil.managTransaction(false);
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> Page<T> listObj(Class<T> t, int pageSize, int currentPage, List<String> desc, List<String> asc, boolean queryRecordCount) {
        try {
            Page<T> page;
            StringBuffer hql = DaoUtil.getSelectHql(t, null, desc, asc, new String[0]);
            Long recordCount = Long.MAX_VALUE;
            if (queryRecordCount) {
                recordCount = DaoUtil.getRecordCount(null, hql);
            }
            Query query = DaoUtil.createQuery(null, hql);
            DaoUtil.faging(pageSize, currentPage, query);
            List list = query.list();
            Page<T> page2 = page = DaoUtil.setPage(currentPage, recordCount, pageSize, list);
            return page2;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            Page<T> page = null;
            return page;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final <T> Page<T> listObj(Class<T> t, int pageSize, int currentPage, List<String> desc, List<String> asc) {
        return DaoUtil.listObj(t, pageSize, currentPage, desc, asc, true);
    }

    public static final <T extends BaseRelationalDatabaseDomain> List<T> listAllObj(Class<T> t, List<String> desc, List<String> asc) {
        return DaoUtil.listAllObj(t, null, desc, asc);
    }

    public static final <T extends BaseRelationalDatabaseDomain> List<T> listAllObj(Class<T> t) {
        return DaoUtil.listAllObj(t, null, null, null);
    }

    public static final <T> T listOne(T where) {
        return DaoUtil.listOne(where, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T listOne(Class<T> target, Map<String, Object> where, List<String> desc, List<String> asc) {
        try {
            StringBuffer hql = DaoUtil.getSelectHql(target, where, desc, asc, new String[0]);
            Query query = DaoUtil.createQuery(where, hql);
            DaoUtil.faging(1, 1, query);
            Object object = query.uniqueResult();
            return (T)object;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            T t = null;
            return t;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final <T> T listOne(T where, List<String> desc, List<String> asc) {
        return (T)DaoUtil.listOne(where.getClass(), DaoUtil.putField2Map(where), desc, asc);
    }

    public static final void getRefrenceById(BaseDomain target) {
        for (Field f : target.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                Object temp = f.get(target);
                if (!(temp != null & temp instanceof BaseRelationalDatabaseDomain)) continue;
                f.set(target, DaoUtil.smartGet((BaseRelationalDatabaseDomain)temp));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final <T> List<T> listAllObj(T where, List<String> desc, List<String> asc) {
        Class<?> clazz = where.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DaoUtil.putField2Map(where, map, "");
        return DaoUtil.listAllObj(clazz, map, desc, asc);
    }

    public static final <T> List<T> listAllObj(T where) {
        return DaoUtil.listAllObj(where, null, null);
    }

    public static final <T> List<T> listAllObj(Class<T> target, Map<String, Object> where, List<String> desc, List<String> asc) {
        return DaoUtil.listAllCustomField(target, where, desc, asc, new String[0]);
    }

    public static final boolean isResultNull(BaseRelationalDatabaseDomain where) {
        return DaoUtil.isResultNull(where.getClass(), DaoUtil.putField2Map(where));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isResultNull(Class<?> target, Map<String, Object> where) {
        try {
            Query query = DaoUtil.getSession().createQuery(DaoUtil.getCountHql(DaoUtil.getSelectHql(target, where, null, null, new String[0])).toString());
            DaoUtil.setMapParam(where, query);
            DaoUtil.faging(1, 1, query);
            boolean bl = (Long)query.uniqueResult() == 0L;
            return bl;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final long getCount(BaseRelationalDatabaseDomain where) {
        Class<?> t = where.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DaoUtil.putField2Map(where, map, "");
        return DaoUtil.getCount(t, map);
    }

    public static final <T> List<T> listAllCustomField(BaseDomain where, String ... selectedFields) {
        return DaoUtil.listAllCustomField(DaoUtil.putField2Map(where), where.getClass(), selectedFields);
    }

    public static final <T> List<T> listAllCustomField(Map<String, Object> where, Class<?> target, String ... selectedFields) {
        return DaoUtil.listAllCustomField(target, where, null, null, selectedFields);
    }

    public static final <T> List<T> listAllCustomField(Class<?> target, Map<String, Object> where, List<String> desc, List<String> asc, String ... selectedFields) {
        return DaoUtil.listAllCustomField(target, where, desc, asc, null, selectedFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> List<T> listAllCustomField(Class<?> target, Map<String, Object> where, List<String> desc, List<String> asc, String[] groupBy, String ... selectedFields) {
        try {
            Query query = DaoUtil.getSession().createQuery(DaoUtil.getSelectHql(target, where, desc, asc, groupBy, selectedFields).toString());
            DaoUtil.setMapParam(where, query);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<T> list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getCount(Class<? extends BaseRelationalDatabaseDomain> target, Map<String, Object> where) {
        try {
            Query query = DaoUtil.getSession().createQuery(DaoUtil.getCountHql(DaoUtil.getSelectHql(target, where, null, null, new String[0])).toString());
            DaoUtil.setMapParam(where, query);
            long l = (Long)query.uniqueResult();
            return l;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            long l = -1L;
            return l;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final <T> Page<T> listObj(int pageSize, int currentPage, T where, List<String> desc, List<String> asc) {
        Class<?> t = where.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DaoUtil.putField2Map(where, map, "");
        return DaoUtil.listObj(t, pageSize, currentPage, map, desc, asc);
    }

    public static final <T> List<T> randomlistObj(int size, T where) {
        Class<?> t = where.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DaoUtil.putField2Map(where, map, "");
        return DaoUtil.randomlistObj(t, size, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> List<T> randomlistObj(Class<T> target, int size, Map<String, Object> where) {
        try {
            ArrayList<String> randList = new ArrayList<String>(1);
            randList.add("RAND()");
            StringBuffer hql = DaoUtil.getSelectHql(target, where, null, null, new String[0]);
            hql.append(" order by RAND()");
            Query query = DaoUtil.createQuery(where, hql);
            DaoUtil.faging(size, 1, query);
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List<T> list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final <T> Page<T> listObj(Class<T> target, int pageSize, int currentPage, Map<String, Object> where, List<String> desc, List<String> asc, boolean queryRecordCount) {
        return DaoUtil.listCustomField(target, pageSize, currentPage, where, desc, asc, queryRecordCount, new String[0]);
    }

    public static final <T> Page<T> listObj(Class<T> t, int pageSize, int currentPage, Map<String, Object> map, List<String> desc, List<String> asc) {
        return DaoUtil.listObj(t, pageSize, currentPage, map, desc, asc, true);
    }

    public static final <T> Page<T> listCustomField(Class<?> target, int pageSize, int currentPage, Map<String, Object> where, List<String> desc, List<String> asc, boolean queryRecordCount, String ... selectField) {
        return DaoUtil.listCustomField(target, pageSize, currentPage, where, desc, asc, queryRecordCount, null, selectField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> Page<T> listCustomField(Class<?> t, int pageSize, int currentPage, Map<String, Object> constraint, List<String> desc, List<String> asc, boolean queryRecordCount, String[] groupBy, String ... selectField) {
        try {
            StringBuffer hql = DaoUtil.getSelectHql(t, constraint, desc, asc, groupBy, selectField);
            Long recordCount = Long.MAX_VALUE;
            if (queryRecordCount) {
                recordCount = DaoUtil.getRecordCount(constraint, hql);
            }
            Query query = DaoUtil.createQuery(constraint, hql);
            DaoUtil.faging(pageSize, currentPage, query);
            List list = query.list();
            Page<T> page = DaoUtil.setPage(currentPage, recordCount, pageSize, list);
            return page;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            Page<T> page = null;
            return page;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final <T extends BaseRelationalDatabaseDomain> T smartLoad(T domain) {
        return (T)DaoUtil.load(domain.getClass(), DomainUtil.getDomainId(domain));
    }

    public static final <T extends BaseRelationalDatabaseDomain> T smartGet(T domain) {
        return (T)DaoUtil.get(domain.getClass(), DomainUtil.getDomainId(domain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends BaseRelationalDatabaseDomain> T get(Class<T> clazz, Serializable id) {
        try {
            BaseRelationalDatabaseDomain t2;
            BaseRelationalDatabaseDomain baseRelationalDatabaseDomain = t2 = (BaseRelationalDatabaseDomain)DaoUtil.getSession().get(clazz, id);
            return (T)baseRelationalDatabaseDomain;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            T t = null;
            return t;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends BaseRelationalDatabaseDomain> List<T> getList(Class<T> t, Serializable[] keys) {
        try {
            ArrayList<T> list = new ArrayList<T>();
            for (Serializable s : keys) {
                list.add(DaoUtil.get(t, s));
            }
            ArrayList<T> list2 = list;
            return list2;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            List<T> list = null;
            return list;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends BaseRelationalDatabaseDomain> T load(Class<T> clazz, Serializable id) {
        try {
            Session session = DaoUtil.getSession();
            BaseRelationalDatabaseDomain baseRelationalDatabaseDomain = (BaseRelationalDatabaseDomain)session.load(clazz, id);
            return (T)baseRelationalDatabaseDomain;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            T t = null;
            return t;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    private static boolean shouldCommitNow() {
        return autoManagTransaction.get() == null && Config.autoCommitTransaction || Boolean.TRUE == autoManagTransaction.get();
    }

    private static boolean managTransaction(Boolean isCommit) {
        if (DaoUtil.shouldCommitNow()) {
            if (isCommit == null || isCommit.booleanValue()) {
                DaoUtil.commitTransaction();
                return true;
            }
            DaoUtil.rollbackTransaction();
            return isCommit;
        }
        if (isCommit != null) {
            Boolean type = transactionType.get();
            if (type == null) {
                transactionType.set(isCommit);
            } else {
                transactionType.set(type != false && isCommit != false);
            }
            return transactionType.get();
        }
        return true;
    }

    public static final void beginTransaction() {
        if (currentTransaction.get() == null) {
            LoggerFactory.getLogger().debug("\u5f00\u542f\u4e8b\u52a1.....");
            currentTransaction.set(HibernateUtil.getSession().beginTransaction());
        }
    }

    private static Transaction getTransaction() {
        return currentTransaction.get();
    }

    public static final boolean managTransaction() {
        Boolean boolean1 = transactionType.get();
        try {
            if (boolean1 == null) {
                if (currentTransaction.get() != null) {
                    LoggerFactory.getLogger().debug("\u5f53\u524d\u4e8b\u52a1\u672a\u8fdb\u884c\u5199\u64cd\u4f5c,\u56de\u6eda\u4e8b\u52a1,\u9632\u6b62\u5bf9\u67e5\u8be2\u51fa\u6765\u7684\u5b9e\u4f53\u7c7b\u7684\u66f4\u6539\u4fdd\u5b58\u5230\u6570\u636e\u5e93..");
                    DaoUtil.rollbackTransaction();
                }
                boolean bl = true;
                return bl;
            }
            if (boolean1.booleanValue()) {
                DaoUtil.commitTransaction();
            } else {
                DaoUtil.rollbackTransaction();
            }
            boolean bl = boolean1;
            return bl;
        }
        catch (Exception e) {
            try {
                DaoUtil.rollbackTransaction();
            }
            catch (Exception e2) {
                DaoUtil.setException(e2);
            }
            DaoUtil.setException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            DaoUtil.relese();
        }
    }

    public static final void relese() {
        transactionType.remove();
        autoManagTransaction.remove();
        currentTransaction.remove();
        exception.remove();
    }

    public static final void commitTransaction() {
        Transaction transaction = DaoUtil.getTransaction();
        if (transaction != null) {
            transaction.commit();
            LoggerFactory.getLogger().debug("\u63d0\u4ea4\u4e8b\u52a1.....");
        }
        currentTransaction.remove();
    }

    public static final void rollbackTransaction() {
        Transaction transaction = DaoUtil.getTransaction();
        if (transaction != null) {
            transaction.rollback();
            LoggerFactory.getLogger().debug("\u56de\u6eda\u4e8b\u52a1.....");
        }
        currentTransaction.remove();
    }

    public static final boolean save(BaseRelationalDatabaseDomain domain) {
        try {
            Session session = DaoUtil.getSession();
            DaoUtil.beginTransaction();
            session.save((Object)domain);
            boolean bl = DaoUtil.managTransaction(true);
            return bl;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = DaoUtil.managTransaction(false);
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final boolean updateNotNullField(BaseRelationalDatabaseDomain domain, List<String> updateEvenNull) {
        return DaoUtil.updateNotNullField(domain, updateEvenNull, false);
    }

    public static final boolean updateNotNullField(BaseRelationalDatabaseDomain domain, List<String> updateEvenNull, boolean strictlyMode) {
        BaseRelationalDatabaseDomain smartGet = DaoUtil.smartGet(domain);
        DomainUtil.fillDomain(smartGet, domain, updateEvenNull, strictlyMode);
        return smartGet.update();
    }

    public static final boolean update(BaseRelationalDatabaseDomain domain) {
        try {
            Session session = DaoUtil.getSession();
            DaoUtil.beginTransaction();
            session.update((Object)domain);
            boolean bl = DaoUtil.managTransaction(true);
            return bl;
        }
        catch (Exception e) {
            DaoUtil.setException(e);
            boolean bl = DaoUtil.managTransaction(false);
            return bl;
        }
        finally {
            DaoUtil.closeSession();
        }
    }

    public static final int updateListOneByOne(List<? extends BaseRelationalDatabaseDomain> list) {
        int failed = 0;
        for (BaseRelationalDatabaseDomain baseRelationalDatabaseDomain : list) {
            if (DaoUtil.update(baseRelationalDatabaseDomain)) continue;
            ++failed;
        }
        return failed;
    }

    public static final <T> StringBuffer getUpdateHql(Class<T> t, Map<String, Object> queryCondition, Map<String, Object> updated) {
        String fullClassName = t.getName();
        StringBuffer hql = new StringBuffer();
        String domainSimpleName = DaoUtil.getDomainSimpleName(fullClassName);
        hql.append(" update ").append(fullClassName).append(" ").append(domainSimpleName);
        hql.append(" set ");
        DaoUtil.appendHqlUpdateSet(hql, domainSimpleName, updated);
        hql.append(" where 1=1 ");
        DaoUtil.appendHqlWhere(domainSimpleName, hql, queryCondition);
        LoggerFactory.getLogger().debug("hql------>" + hql.toString());
        return hql;
    }

    public static final StringBuffer getDeleteHql(Class<? extends BaseRelationalDatabaseDomain> t, Map<String, Object> map) {
        return DaoUtil.getHql(t, map, null, null, "delete", new String[0]);
    }

    public static final <T> StringBuffer getSelectHql(Class<T> t, Map<String, Object> map, List<String> desc, List<String> asc, String ... selectedFields) {
        return DaoUtil.getHql(t, map, desc, asc, "select", null, selectedFields);
    }

    public static final <T> StringBuffer getSelectHql(Class<T> t, Map<String, Object> map, List<String> desc, List<String> asc, String[] groupBy, String ... selectedFields) {
        return DaoUtil.getHql(t, map, desc, asc, "select", groupBy, selectedFields);
    }

    public static final <T> StringBuffer getHql(Class<T> t, Map<String, Object> queryMap, List<String> desc, List<String> asc, String prefix, String ... selectedFields) {
        return DaoUtil.getHql(t, queryMap, desc, asc, prefix, null, selectedFields);
    }

    public static final <T> StringBuffer getHql(Class<T> t, Map<String, Object> queryMap, List<String> desc, List<String> asc, String prefix, String[] groupBy, String ... selectedFields) {
        String fullClassName = t.getName();
        StringBuffer hql = new StringBuffer();
        String domainSimpleName = DaoUtil.getDomainSimpleName(fullClassName);
        hql.append(prefix).append(" ");
        HashSet<String> domainSelected = new HashSet<String>();
        HashSet<String> innerJoin = new HashSet<String>();
        if ("select".equals(prefix)) {
            if (selectedFields == null || selectedFields.length == 0) {
                hql.append(domainSimpleName);
            } else {
                if (selectedFields.length > 1) {
                    hql.append("new map( ");
                }
                for (String temp : selectedFields) {
                    Matcher fieldMatcher;
                    Matcher matcher = RegUtil.getPattern(".+\\((.+)\\)").matcher(temp);
                    String selectedField = temp;
                    if (matcher.find()) {
                        selectedField = matcher.group(1);
                    }
                    if ((fieldMatcher = RegUtil.getPattern("\\s*(\\S+)\\s*(\\S*)\\s*").matcher(selectedField)).find()) {
                        selectedField = fieldMatcher.group(2);
                    }
                    if (StringUtil.isStringEmpty(selectedField)) {
                        selectedField = fieldMatcher.group(1);
                    }
                    String replace = selectedField.replace("/", "/" + domainSimpleName + ".").replace("+", "+" + domainSimpleName + ".").replace("-", "-" + domainSimpleName + ".").replace("*", "*" + domainSimpleName + ".");
                    String dealedSelectedField = temp.replace(selectedField, domainSimpleName + "." + replace);
                    DaoUtil.addSelectedDomain(t, domainSelected, selectedField);
                    hql.append(dealedSelectedField).append(" as ").append(DaoUtil.dealSpecialChar(selectedField)).append(",");
                }
                hql.deleteCharAt(hql.length() - 1);
                if (selectedFields.length > 1) {
                    hql.append(" )");
                }
            }
        }
        DaoUtil.dealSortFieldsJoin(t, desc, domainSelected);
        DaoUtil.dealSortFieldsJoin(t, asc, domainSelected);
        if (queryMap != null) {
            for (String temp : queryMap.keySet()) {
                String chain;
                if (!temp.contains(".") || (chain = DaoUtil.getMaxDepthDomainChain(temp, t)) == null) continue;
                innerJoin.add(chain);
                domainSelected.remove(chain);
            }
        }
        hql.append(" from ").append(fullClassName).append(" ").append(domainSimpleName);
        for (String temp : domainSelected) {
            hql.append(" left join ").append(domainSimpleName).append(".").append(temp).append(" ");
        }
        for (String temp : innerJoin) {
            hql.append(" inner join ").append(domainSimpleName).append(".").append(temp).append(" ");
        }
        hql.append(" where  1=1 ");
        hql = DaoUtil.appendHqlWhere(domainSimpleName, hql, queryMap);
        if (groupBy != null && groupBy.length > 0) {
            int i = 0;
            hql.append(" group by ");
            for (String temp : groupBy) {
                hql.append(" ").append(domainSimpleName).append(".").append(temp).append(" ");
                if (++i >= groupBy.length) continue;
                hql.append(",");
            }
        }
        DaoUtil.appendHqlOrder(hql, desc, asc, domainSimpleName);
        LoggerFactory.getLogger().debug("hql------>%s", hql.toString());
        LoggerFactory.getLogger().debug("\u53c2\u6570------>%s", queryMap == null ? null : queryMap.toString());
        return hql;
    }

    private static <T> void addSelectedDomain(Class<T> t, Set<String> domainSelected, String selectedField) {
        String chain;
        if (selectedField.contains(".") && (chain = DaoUtil.getMaxDepthDomainChain(selectedField, t)) != null) {
            domainSelected.add(chain);
        }
    }

    private static <T> void dealSortFieldsJoin(Class<T> t, List<String> desc, Set<String> domainSelected) {
        if (desc != null) {
            for (String temp : desc) {
                String chain;
                if (!temp.contains(".") || (chain = DaoUtil.getMaxDepthDomainChain(temp, t)) == null) continue;
                domainSelected.add(chain);
            }
        }
    }

    private static String dealSpecialChar(String group) {
        return group.replace(".", "__").replace("\r", "").replace("*", "_").replace("/", "_").replace("-", "_").replace("+", "_");
    }

    private static String getMaxDepthDomainChain(String chain, Class<?> clazz) {
        return DaoUtil.getMaxDepthDomainChain(clazz, DaoUtil.getNoSelectIndexFieldName(chain));
    }

    private static String getMaxDepthDomainChain(Class<?> clazz, String chain) {
        Method iDmethod;
        if (StringUtil.isStringEmpty(chain)) {
            return null;
        }
        ReflectResult chainField = ReflectUtil.getChainField(clazz, chain);
        boolean isId = false;
        if (chainField != null && BaseDatabaseDomain.class.isAssignableFrom(chainField.getTarget()) && !(isId = chainField.getField().getAnnotation(Id.class) != null) && (iDmethod = DomainUtil.getIDmethod(chainField.getTarget())) != null) {
            String fieldName = chainField.getField().getName();
            boolean bl = isId = StringUtil.getFieldGetterName(fieldName).equals(iDmethod.getName()) || StringUtil.getFieldIsMethodName(fieldName).equals(iDmethod.getName());
        }
        if (isId && chain.contains(".")) {
            chain = chain.substring(0, chain.lastIndexOf("."));
        }
        if (!isId && chainField != null && BaseDatabaseDomain.class.isAssignableFrom(chainField.getField().getType())) {
            return chain;
        }
        if (chain.contains(".")) {
            return DaoUtil.getMaxDepthDomainChain(clazz, chain.substring(0, chain.lastIndexOf(".")));
        }
        return null;
    }

    public static final StringBuffer getSelectHql(BaseRelationalDatabaseDomain domain, List<String> desc, List<String> asc) {
        Class<?> clazz = domain.getClass();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DaoUtil.putField2Map(domain, map, "");
        return DaoUtil.getSelectHql(clazz, map, desc, asc, new String[0]);
    }

    public static final StringBuffer getCountHql(StringBuffer hql) {
        return DaoUtil.changeSelectHql(hql, "count(*)");
    }

    public static final StringBuffer changeSelectHql(StringBuffer hql, String selectedField) {
        StringBuffer countHql = new StringBuffer(hql);
        Pattern p = RegUtil.getPattern("select .+? from");
        Matcher m = p.matcher(countHql);
        if (m.find()) {
            countHql.replace(m.start(0), m.end(0), "select " + selectedField + " from");
        } else {
            countHql.insert(0, "select " + selectedField + " ");
        }
        LoggerFactory.getLogger().debug("countHql--->" + countHql);
        return countHql;
    }

    public static final Query createQuery(Map<String, Object> map, StringBuffer hql) {
        LoggerFactory.getLogger().debug("hql---->" + hql.toString());
        LoggerFactory.getLogger().debug("\u53c2\u6570---->" + map);
        Query query = DaoUtil.getSession().createQuery(hql.toString());
        DaoUtil.setMapParam(map, query);
        return query;
    }

    public static final Query createSQLQuery(Map<String, Object> map, StringBuffer sql) {
        LoggerFactory.getLogger().debug("sql---->" + sql.toString());
        LoggerFactory.getLogger().debug("\u53c2\u6570---->" + map);
        SQLQuery query = DaoUtil.getSession().createSQLQuery(sql.toString());
        DaoUtil.setMapParam(map, (Query)query);
        return query;
    }

    public static final Session getSession() {
        Session session = HibernateUtil.getSession();
        if (Config.autoBeginTransaction) {
            DaoUtil.beginTransaction();
        }
        return session;
    }

    public static final StringBuffer appendHqlOrder(StringBuffer hql, List<String> desc, List<String> asc, String domainSimpleName) {
        boolean hasOrderByAppened = false;
        if (desc != null && !desc.isEmpty()) {
            for (String name : desc) {
                if (!hasOrderByAppened) {
                    hql.append("order by ");
                    hasOrderByAppened = true;
                } else {
                    hql.append(", ");
                }
                hql.append(domainSimpleName).append(".").append(name).append(" desc");
            }
        }
        if (asc != null && !asc.isEmpty()) {
            for (String name : asc) {
                if (!hasOrderByAppened) {
                    hql.append("order by ");
                    hasOrderByAppened = true;
                } else {
                    hql.append(", ");
                }
                hql.append(domainSimpleName).append(".").append(name).append(" asc");
            }
        }
        return hql;
    }

    private static void closeSession() {
        DaoUtil.managTransaction(null);
        if (HibernateUtil.getColseSession() && DaoUtil.shouldCommitNow()) {
            DaoUtil.managTransaction();
            HibernateUtil.closeSession();
        }
    }

    public static final void closeSessionNow() {
        DaoUtil.managTransaction();
        HibernateUtil.closeSession();
    }

    private static String getDomainSimpleName(String fullClassName) {
        String domainSimpleName = StringUtil.firstChar2LowerCase(StringUtil.getClassSimpleName(fullClassName) + "_steed_00");
        return domainSimpleName;
    }

    public static final Map<String, Object> putField2Map(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DaoUtil.putField2Map(obj, map, "");
        return map;
    }

    public static final void putField2Map(Object obj, Map<String, Object> map, String prefixName) {
        DaoUtil.putField2Map(obj, map, prefixName, true);
    }

    public static final void putField2Map(Object obj, Map<String, Object> map, String prefixName, boolean getFieldByGetter) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PutField2MapIntercepter && !((PutField2MapIntercepter)obj).beforePutField2Map(map, prefixName, getFieldByGetter)) {
            return;
        }
        try {
            Class<?> objClass = obj.getClass();
            List<Field> Fields = ReflectUtil.getNotFinalFields(obj);
            for (Field f : Fields) {
                String fieldName = f.getName();
                if (map.containsKey(prefixName + fieldName) || DaoUtil.isSelectIndex(fieldName) == 0 && (ReflectUtil.getAnnotation(Transient.class, objClass, f) != null || ReflectUtil.getDeclaredMethod(objClass, StringUtil.getFieldGetterName(fieldName)) == null && ReflectUtil.getDeclaredMethod(objClass, StringUtil.getFieldIsMethodName(fieldName)) == null)) continue;
                Object value = null;
                if (getFieldByGetter) {
                    value = ReflectUtil.getFieldValueByGetter(obj, fieldName);
                }
                if (value == null) {
                    f.setAccessible(true);
                    value = f.get(obj);
                }
                if (!BaseUtil.isObjEmpty(value)) {
                    if (value instanceof BaseRelationalDatabaseDomain) {
                        JoinColumn annotation = ReflectUtil.getAnnotation(JoinColumn.class, objClass, f);
                        if (annotation != null && !annotation.insertable() && !annotation.updatable()) continue;
                        map.put(prefixName + fieldName, value);
                        continue;
                    }
                    map.put(prefixName + fieldName, value);
                    continue;
                }
                if (!(value instanceof BaseRelationalDatabaseDomain) || value instanceof BaseUnionKeyDomain || !BaseUtil.isObjEmpty(DomainUtil.getDomainId((BaseDomain)value))) continue;
                DaoUtil.putField2Map(value, map, prefixName + fieldName + ".");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LoggerFactory.getLogger().debug("putField2Map\u51fa\u9519", e);
        }
        if (obj instanceof PutField2MapIntercepter) {
            ((PutField2MapIntercepter)obj).afterPutField2Map(map, prefixName, getFieldByGetter);
        }
    }

    public static final int isSelectIndex(String fieldName) {
        for (String suffix : indexSuffix) {
            if (!fieldName.endsWith(suffix)) continue;
            return suffix.length();
        }
        return 0;
    }

    public static final String getNoSelectIndexFieldName(String fieldName) {
        int selectIndex = DaoUtil.isSelectIndex(fieldName);
        if (selectIndex == 0) {
            return fieldName;
        }
        return fieldName.substring(0, fieldName.length() - selectIndex);
    }

    public static final StringBuffer appendHqlWhere(String domainSimpleName, StringBuffer hql, Map<String, Object> map) {
        if (map == null) {
            return hql;
        }
        Object object = map.get(personalHqlGeneratorKey);
        if (object != null && object instanceof HqlGenerator) {
            map.remove(personalHqlGeneratorKey);
            StringBuffer appendHqlWhere = ((HqlGenerator)object).appendHqlWhere(domainSimpleName, hql, map);
            map.put(personalHqlGeneratorKey, object);
            return appendHqlWhere;
        }
        return Config.defaultHqlGenerator.appendHqlWhere(domainSimpleName, hql, map);
    }

    private static void appendHqlUpdateSet(StringBuffer hql, String domainSimpleName, Map<String, Object> updated) {
        for (String temp : updated.keySet()) {
            hql.append(domainSimpleName).append(".").append(temp).append("=:steedUpdate_").append(temp).append(", ");
        }
        hql.deleteCharAt(hql.length() - 2);
    }

    private static long getRecordCount(Map<String, Object> where, StringBuffer selectHql) {
        Query query = DaoUtil.createQuery(where, DaoUtil.getCountHql(selectHql));
        try {
            return (Long)query.uniqueResult();
        }
        catch (NonUniqueResultException e) {
            return query.list().size();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    private static <T> Page<T> setPage(int currentPage, Long recordCount, int pageSize, List<T> list) {
        Page<T> page = new Page<T>();
        page.setCurrentPage(currentPage);
        page.setPageSize(pageSize);
        page.setRecordCount(recordCount);
        page.setDomainCollection(list);
        return page;
    }

    private static void setMapParam(Map<String, ? extends Object> map, Query query) {
        if (CollectionsUtil.isCollectionsEmpty(map)) {
            return;
        }
        for (Map.Entry<String, ? extends Object> e : map.entrySet()) {
            String key = e.getKey();
            if (personalHqlGeneratorKey.equals(key)) continue;
            Object value = e.getValue();
            if (value == null) {
                query.setParameter(key.replace(".", "__"), value);
                continue;
            }
            if (value instanceof Collection) {
                query.setParameterList(key.replace(".", "__"), (Collection)value);
                continue;
            }
            if (value.getClass().isArray()) {
                query.setParameterList(key.replace(".", "__"), (Object[])value);
                continue;
            }
            query.setParameter(key.replace(".", "__"), value);
        }
    }

    public static final void faging(int pageSize, int currentPage, Query query) {
        query.setFirstResult((currentPage - 1) * pageSize);
        query.setMaxResults(pageSize);
    }

    public static final class ImmediatelyTransactionData {
        Transaction currentTransaction;
        Boolean autoManagTransaction;
        Session session;
        Boolean transactionType;

        public ImmediatelyTransactionData(Transaction currentTransaction, Boolean autoManagTransaction, Session session) {
            this.currentTransaction = currentTransaction;
            this.autoManagTransaction = autoManagTransaction;
            this.session = session;
        }
    }

    public static interface PutField2MapIntercepter {
        public boolean beforePutField2Map(Map<String, Object> var1, String var2, boolean var3);

        default public void afterPutField2Map(Map<String, Object> map, String prefixName, boolean getFieldByGetter) {
        }
    }

    public static interface CRUDListener<T> {
        default public void onDelete(T t) {
        }

        default public void onSave(T t) {
        }

        default public void onUpdate() {
        }
    }
}

