/*
 * Decompiled with CFR 0.152.
 */
package steed.hibernatemaster.util;

import java.util.HashMap;
import java.util.Map;
import steed.hibernatemaster.domain.BaseDomain;
import steed.hibernatemaster.util.DaoUtil;
import steed.hibernatemaster.util.HqlGenerator;

public class QueryBuilder {
    private Map<String, Object> queryMap;

    public QueryBuilder() {
        this.queryMap = new HashMap<String, Object>();
    }

    public QueryBuilder(BaseDomain domain) {
        this.queryMap = DaoUtil.putField2Map(domain);
    }

    public QueryBuilder add(String key, Object value) {
        this.queryMap.put(key, value);
        return this;
    }

    public QueryBuilder addNotEqual(String key, Object value) {
        this.queryMap.put(key + "_not_equal_1", value);
        return this;
    }

    public QueryBuilder addHqlGenerator(HqlGenerator generator) {
        this.queryMap.put("personalHqlGenerator", generator);
        return this;
    }

    public QueryBuilder addIn(String key, Object value) {
        this.queryMap.put(key + "_not_join", value);
        return this;
    }

    public <T> QueryBuilder addIn(String key, T ... value) {
        this.queryMap.put(key + "_not_join", value);
        return this;
    }

    public QueryBuilder addNotNull(String key, boolean notNull) {
        this.queryMap.put(key + "_not_null", notNull);
        return this;
    }

    public QueryBuilder addLessThan(String key, Object value) {
        this.queryMap.put(key + "_max_1", value);
        return this;
    }

    public QueryBuilder addMoreThan(String key, Object value) {
        this.queryMap.put(key + "_min_1", value);
        return this;
    }

    public Map<String, Object> getQueryMap() {
        return this.queryMap;
    }
}

