/*
 * Decompiled with CFR 0.152.
 */
package steed.hibernatemaster.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import steed.hibernatemaster.Config;
import steed.hibernatemaster.domain.BaseDatabaseDomain;
import steed.hibernatemaster.domain.BaseRelationalDatabaseDomain;
import steed.hibernatemaster.domain.DomainScanner;
import steed.util.base.PathUtil;
import steed.util.file.FileUtil;
import steed.util.logging.LoggerFactory;

public class SingleDomainScanner
implements DomainScanner {
    @Override
    public List<Class<? extends BaseDatabaseDomain>> scan(String configFile) {
        ArrayList<Class<? extends BaseDatabaseDomain>> list = new ArrayList<Class<? extends BaseDatabaseDomain>>();
        if (!Config.isSignalDatabase) {
            return list;
        }
        String classesPath = PathUtil.getClassesPath();
        ArrayList<File> allFile = new ArrayList<File>();
        allFile.addAll(new FileUtil().getAllFile(classesPath, null));
        if (classesPath.contains("test-classes")) {
            allFile.addAll(new FileUtil().getAllFile(classesPath.replaceFirst("test-classes", "classes"), null));
        } else {
            allFile.addAll(new FileUtil().getAllFile(classesPath.replaceFirst("classes", "test-classes"), null));
        }
        for (File f : allFile) {
            String absolutePath = f.getAbsolutePath();
            if (!absolutePath.endsWith(".class") || !absolutePath.contains("domain") && !absolutePath.contains("model")) continue;
            String replaceAll = absolutePath.substring(absolutePath.indexOf("classes") + "classes.".length()).replace("\\", ".").replace("/", ".");
            try {
                String domainClassName = replaceAll.substring(0, replaceAll.length() - 6);
                LoggerFactory.getLogger().debug("\u626b\u63cf%s", domainClassName);
                Class<?> domainClass = Class.forName(domainClassName);
                if (!BaseRelationalDatabaseDomain.class.isAssignableFrom(domainClass) || domainClass.getAnnotation(Entity.class) == null) continue;
                list.add(domainClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

