/*
 * Decompiled with CFR 0.152.
 */
package steed.hibernatemaster.util;

import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import steed.hibernatemaster.Config;
import steed.hibernatemaster.domain.BaseDatabaseDomain;
import steed.hibernatemaster.domain.DomainScanner;
import steed.hibernatemaster.util.FactoryEngine;
import steed.hibernatemaster.util.SingleDomainScanner;
import steed.util.logging.LoggerFactory;

public class SingleFactoryEngine
implements FactoryEngine {
    @Override
    public SessionFactory buildFactory(String configFile) {
        try {
            StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().configure(configFile).build();
            MetadataSources metadataSources = new MetadataSources((ServiceRegistry)standardRegistry);
            DomainScanner instanceFromProperties = this.getScanner(configFile);
            List<Class<? extends BaseDatabaseDomain>> scan = instanceFromProperties.scan(configFile);
            for (Class<? extends BaseDatabaseDomain> temp : scan) {
                metadataSources.addAnnotatedClass(temp);
            }
            Metadata metadata = metadataSources.getMetadataBuilder().applyImplicitNamingStrategy(ImplicitNamingStrategyJpaCompliantImpl.INSTANCE).build();
            SessionFactory factory2 = metadata.getSessionFactoryBuilder().build();
            return factory2;
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error("\u521b\u5efasessionFactory\u5931\u8d25", e);
            return null;
        }
    }

    @Override
    public DomainScanner getScanner(String configFile) {
        if (!Config.isSignalDatabase) {
            throw new RuntimeException("\u5f53\u524d\u4e3a\u591a\u6570\u636e\u5e93\u6a21\u5f0f,\u8bf7\u8bbe\u7f6esteed.hibernatemaster.Config.factoryEngine\u4e3a\u4f60\u81ea\u5b9a\u4e49\u7684\u591a\u6570\u636e\u5e93sessionFactory\u751f\u6210\u5668!");
        }
        return new SingleDomainScanner();
    }
}

