/*
 * Decompiled with CFR 0.152.
 */
package steed.util.base;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionsUtil {
    public static final int array = 0;
    public static final int collection = 1;
    public static final int map = 3;

    public static boolean isObjCollections(Object object) {
        return object instanceof Collection || object instanceof Map;
    }

    public static boolean isCollectionsEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        CollectionsUtil.throwNotCollectionsException(obj);
        return false;
    }

    private static void throwNotCollectionsException(Object obj) {
        String message = obj == null ? "\u6240\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u662f\u96c6\u5408\u7c7b\u578b\uff01" : obj.getClass().getName() + "\u4e0d\u662f\u96c6\u5408\u7c7b\u578b\uff01";
        throw new RuntimeException(message);
    }

    public List<Object> map2List(Map<?, ?> map) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (Object o : map.keySet()) {
            returnList.add(map.get(o));
        }
        return returnList;
    }

    public static boolean isObjArray(Object obj) {
        return obj.getClass().isArray();
    }

    public static Object[] collections2Array(Object object) {
        if (!CollectionsUtil.isObjCollections(object)) {
            CollectionsUtil.throwNotCollectionsException(object);
        }
        if (object == null) {
            return null;
        }
        if (CollectionsUtil.isObjArray(object)) {
            return (Object[])object;
        }
        if (object instanceof Collection) {
            Collection tempCollection = (Collection)object;
            return tempCollection.toArray();
        }
        Map tempMap = (Map)object;
        Object[] returned = new Object[tempMap.size()];
        int index = 0;
        for (Object o : tempMap.keySet()) {
            returned[index++] = tempMap.get(o);
        }
        return returned;
    }

    public static int getCollectionLength(Object obj) {
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (CollectionsUtil.isObjArray(obj)) {
            return Array.getLength(obj);
        }
        CollectionsUtil.throwNotCollectionsException(obj);
        return 0;
    }

    public static int getCollectionType(Object obj) {
        if (obj instanceof Collection) {
            return 1;
        }
        if (obj instanceof Map) {
            return 3;
        }
        if (obj.getClass().isArray()) {
            return 0;
        }
        CollectionsUtil.throwNotCollectionsException(obj);
        return -1;
    }

    public static boolean isListEmpty(List<?> list) {
        return null == list || list.size() == 0;
    }

    public static boolean isMapEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isSetEmpty(Set<?> set) {
        return null == set || set.isEmpty();
    }
}

