/*
 * Decompiled with CFR 0.152.
 */
package steed.util.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.UUID;

public class StringUtil {
    public static boolean isStringEmpty(String str) {
        return null == str || "".equals(str);
    }

    public static String formatNumber(double d, int precision) {
        return String.format("%." + precision + "f", d);
    }

    public static String formatNumber(float f, int precision) {
        return String.format("%." + precision + "f", Float.valueOf(f));
    }

    public static String safeSubString(String str, int begin, int end) {
        if (str == null) {
            return null;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (begin < 0) {
            begin = 0;
        }
        return str.substring(begin, end);
    }

    public static String getFileName(String path) {
        path = path.substring(path.indexOf("/") + 1, path.length());
        return path.substring(path.indexOf("\\") + 1, path.length());
    }

    public static String getString(InputStream in) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StringUtil.getCharacterSet()));
            StringBuffer sb = new StringBuffer();
            String readLine = null;
            while ((readLine = bufferedReader.readLine()) != null) {
                sb.append(readLine);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static String getNotNullString(String str) {
        return str == null ? "" : str;
    }

    public static String getClassSimpleName(String classFullName) {
        return classFullName.substring(classFullName.lastIndexOf(".") + 1, classFullName.length());
    }

    public static String getFieldSetterName(String fieldName) {
        StringBuffer sb = new StringBuffer("set");
        sb.append(StringUtil.firstChar2UpperCase(fieldName));
        return sb.toString();
    }

    public static String getFieldGetterName(String fieldName) {
        StringBuffer sb = new StringBuffer("get");
        sb.append(StringUtil.firstChar2UpperCase(fieldName));
        return sb.toString();
    }

    public static String getFieldIsMethodName(String fieldName) {
        StringBuffer sb = new StringBuffer("is");
        sb.append(StringUtil.firstChar2UpperCase(fieldName));
        return sb.toString();
    }

    public static String firstChar2UpperCase(String str) {
        StringBuffer sb = new StringBuffer(String.valueOf(str.charAt(0)).toUpperCase());
        sb.append(str.substring(1, str.length()));
        return sb.toString();
    }

    public static String firstChar2LowerCase(String str) {
        StringBuffer sb = new StringBuffer(String.valueOf(str.charAt(0)).toLowerCase());
        sb.append(str.substring(1, str.length()));
        return sb.toString();
    }

    public static String transferrCharacter(String str) {
        char[] content = str.toCharArray();
        StringBuffer sb = new StringBuffer(content.length + 30);
        block7: for (char temp : content) {
            switch (temp) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(temp);
                }
            }
        }
        return sb.toString();
    }

    public static byte[] getSystemCharacterSetBytes(String str) {
        try {
            return str.getBytes(StringUtil.getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("\u4e0d\u652f\u6301%s\u7f16\u7801!!", StringUtil.getCharacterSet()));
        }
    }

    public static String getCharacterSet() {
        return "UTF-8";
    }

    public static boolean isStringInArray(String str, String[] strs) {
        if (strs == null) {
            return false;
        }
        for (String temp : strs) {
            if (!str.equals(temp)) continue;
            return true;
        }
        return false;
    }

    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, StringUtil.getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("config.properties\u4e2d\u7684\u9879\u76ee\u7f16\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff01\uff01\uff01", e);
        }
    }

    public static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, StringUtil.getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("config.properties\u4e2d\u7684\u9879\u76ee\u7f16\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff01\uff01\uff01", e);
        }
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getSystemCharacterSetString(byte[] bytes) {
        try {
            return new String(bytes, StringUtil.getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("\u4e0d\u652f\u6301%s\u7f16\u7801!!", StringUtil.getCharacterSet()));
        }
    }
}

