/*
 * Decompiled with CFR 0.152.
 */
package steed.util.logging;

import steed.util.logging.Logger;
import steed.util.logging.impl.JdkLoggerFactory;

public class LoggerFactory {
    private static InternalLoggerFactory factory;
    private static Logger logger;

    public static void setLoggerFactory(InternalLoggerFactory factory) {
        if (factory != null) {
            LoggerFactory.factory = factory;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return factory.getLogger(clazz);
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = factory.getLogger(LoggerFactory.class);
        }
        return logger;
    }

    public static Logger getLogger(String name) {
        return factory.getLogger(name);
    }

    public static void initDefaultFactory() {
        if (factory != null) {
            return;
        }
        try {
            Class.forName("org.slf4j.Logger");
            String defaultFactory = String.format("%s.impl.Sl4jLoggerFactory", Logger.class.getPackage().getName());
            Class<?> factoryClass = Class.forName(defaultFactory);
            factory = (InternalLoggerFactory)factoryClass.newInstance();
            return;
        }
        catch (Exception defaultFactory) {
            try {
                Class.forName("org.apache.log4j.Logger");
                String defaultFactory2 = String.format("%s.impl.Log4jLoggerFactory", Logger.class.getPackage().getName());
                Class<?> factoryClass = Class.forName(defaultFactory2);
                factory = (InternalLoggerFactory)factoryClass.newInstance();
                return;
            }
            catch (Exception exception) {
                if (factory == null) {
                    factory = new JdkLoggerFactory();
                }
                return;
            }
        }
    }

    static {
        LoggerFactory.initDefaultFactory();
    }

    public static interface InternalLoggerFactory {
        public Logger getLogger(Class<?> var1);

        public Logger getLogger(String var1);
    }
}

