/*
 * Decompiled with CFR 0.152.
 */
package steed.util.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import steed.util.base.BaseUtil;
import steed.util.base.StringUtil;
import steed.util.logging.LoggerFactory;
import steed.util.reflect.ReflectResult;

public class ReflectUtil {
    public static void copySameField(Object copy, Object copyed) {
        List<Field> fields = ReflectUtil.getNotFinalFields(copyed);
        for (Field f : fields) {
            try {
                f.setAccessible(true);
                Object value = f.get(copyed);
                if (value == null) continue;
                try {
                    Field declaredField = ReflectUtil.getDeclaredField(copy.getClass(), f.getName());
                    if (declaredField == null) continue;
                    if (!declaredField.getType().isAssignableFrom(f.getType())) {
                        value = ReflectUtil.convertFromString(declaredField.getType(), value.toString());
                    }
                    declaredField.setAccessible(true);
                    declaredField.set(copy, value);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LoggerFactory.getLogger().debug("copyDomainSameField", e);
            }
        }
    }

    public static <T> T copyObj(T copyed) {
        Class<?> clazz = copyed.getClass();
        try {
            Object domain = clazz.newInstance();
            for (Field f : ReflectUtil.getNotFinalFields(copyed)) {
                f.setAccessible(true);
                try {
                    Object value = f.get(copyed);
                    f.set(domain, value);
                }
                catch (IllegalAccessException e) {
                    LoggerFactory.getLogger().debug("copyObj", e);
                }
            }
            return (T)domain;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LoggerFactory.getLogger().error("\u590d\u5236" + copyed.getClass().getName() + "\u5931\u8d25!!", e);
            throw new RuntimeException(e);
        }
    }

    public static Serializable convertFromString(Class<?> baseType, String str) {
        if (str == null) {
            return null;
        }
        if (baseType == String.class) {
            return str;
        }
        if (baseType == Integer.class || baseType == Integer.TYPE) {
            return Integer.valueOf(Integer.parseInt(str));
        }
        if (baseType == Long.class || baseType == Long.TYPE) {
            return Long.valueOf(Long.parseLong(str));
        }
        if (baseType == Double.class || baseType == Double.TYPE) {
            return Double.valueOf(Double.parseDouble(str));
        }
        if (baseType == Float.class || baseType == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(str));
        }
        if (baseType == Short.class || baseType == Short.TYPE) {
            return Short.valueOf(Short.parseShort(str));
        }
        if (baseType == Boolean.class || baseType == Boolean.TYPE) {
            return Boolean.valueOf(Boolean.parseBoolean(str));
        }
        return null;
    }

    public static boolean isClassBaseID(Class<?> clazz) {
        return clazz == String.class || clazz == Short.class || clazz == Integer.class || clazz == Float.class || clazz == Long.class || clazz == Character.class;
    }

    public static boolean isClassBaseType(Class<?> clazz) {
        return clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Float.class || clazz == Boolean.class || clazz == Character.class || clazz == Double.class || Date.class.isAssignableFrom(clazz) || clazz == Long.class;
    }

    public static boolean isObjBaseType(Object obj) {
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Float || obj instanceof Boolean || obj instanceof Character || obj instanceof Long || obj instanceof Date || obj instanceof Double;
    }

    public static boolean isFieldFinal(Field field) {
        return (field.getModifiers() & 0x10) == 16;
    }

    public static Map<String, Object> field2Map(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return ReflectUtil.field2Map(0, obj, map);
    }

    public static Map<String, Object> field2Map(int classDdeep, Object obj, Map<String, Object> map) {
        Class<?> tempClass = obj.getClass();
        for (int i = 0; i < classDdeep; ++i) {
            tempClass = tempClass.getSuperclass();
        }
        if (tempClass == Object.class) {
            return map;
        }
        for (Field temp : tempClass.getDeclaredFields()) {
            temp.setAccessible(true);
            try {
                Object obj2 = temp.get(obj);
                if (BaseUtil.isObjEmpty(obj2)) continue;
                map.put(temp.getName(), obj2);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ReflectUtil.field2Map(++classDdeep, obj, map);
    }

    public static void setValue(String fieldName, Object obj, Object value) {
        try {
            Field declaredField = ReflectUtil.getDeclaredField(obj.getClass(), fieldName);
            if (value instanceof String) {
                value = ReflectUtil.convertFromString(declaredField.getType(), (String)value);
            }
            declaredField.setAccessible(true);
            declaredField.set(obj, value);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            LoggerFactory.getLogger().warn("\u628a" + value + "\u8bbe\u7f6e\u5230" + obj.getClass().getName() + "\u7684" + fieldName + "\u5b57\u6bb5\u5931\u8d25", e);
            return;
        }
    }

    public static Object getChainValue(String fieldName, Object obj) {
        String[] fields = fieldName.split("\\.");
        Object target = obj;
        for (String temp : fields) {
            if ((target = ReflectUtil.getValue(temp, target)) != null) continue;
            return null;
        }
        return target;
    }

    public static Object getValue(String fieldName, Object obj) {
        try {
            Field declaredField = ReflectUtil.getDeclaredField(obj.getClass(), fieldName);
            declaredField.setAccessible(true);
            return declaredField.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            LoggerFactory.getLogger().warn("\u83b7\u53d6" + obj.getClass().getName() + "\u7684" + fieldName + "\u5b57\u6bb5\u5931\u8d25-->", e.getMessage());
            return null;
        }
    }

    public static Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LoggerFactory.getLogger().error(className + "\u5b9e\u4f8b\u5316\u5931\u8d25\uff01\uff01", e);
            throw new RuntimeException(className + "\u5b9e\u4f8b\u5316\u5931\u8d25\uff01\uff01", e);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<? extends Object> objClass, Field field) {
        T annotation = field.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        String name = field.getName();
        String fieldGetterName = StringUtil.getFieldGetterName(name);
        T methodAnnotation = ReflectUtil.getMethodAnnotation(annotationClass, objClass, fieldGetterName);
        if (methodAnnotation == null) {
            String fieldIsMethodName = StringUtil.getFieldIsMethodName(name);
            methodAnnotation = ReflectUtil.getMethodAnnotation(annotationClass, objClass, fieldIsMethodName);
        }
        return methodAnnotation;
    }

    private static <T extends Annotation> T getMethodAnnotation(Class<T> annotationClass, Class<? extends Object> objClass, String fieldIsMethodName) {
        try {
            Method declaredMethod3 = ReflectUtil.getDeclaredMethod(objClass, fieldIsMethodName);
            if (declaredMethod3 != null) {
                declaredMethod3.setAccessible(true);
                T annotation3 = declaredMethod3.getAnnotation(annotationClass);
                if (annotation3 != null) {
                    return annotation3;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static List<Annotation> getAnnotations(Class<? extends Object> objClass, Field field) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        Collections.addAll(list, field.getDeclaredAnnotations());
        String name = field.getName();
        String fieldGetterName = StringUtil.getFieldGetterName(name);
        try {
            Method declaredMethod = objClass.getDeclaredMethod(fieldGetterName, new Class[0]);
            Collections.addAll(list, declaredMethod.getAnnotations());
        }
        catch (NoSuchMethodException | SecurityException declaredMethod) {
            // empty catch block
        }
        String fieldIsMethodName = StringUtil.getFieldIsMethodName(name);
        try {
            Method declaredMethod3 = objClass.getDeclaredMethod(fieldIsMethodName, new Class[0]);
            Collections.addAll(list, declaredMethod3.getAnnotations());
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return list;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName) {
        while (clazz != Object.class) {
            try {
                Method declaredMethod = clazz.getDeclaredMethod(methodName, new Class[0]);
                if (declaredMethod != null) {
                    return declaredMethod;
                }
            }
            catch (NoSuchMethodException | SecurityException e) {
                LoggerFactory.getLogger().info("\u83b7\u53d6\u65b9\u6cd5\u51fa\u9519!%s", e.getMessage());
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Object getFieldValueByGetter(Object obj, String fieldName) {
        Method declaredMethod;
        if (obj == null) {
            return null;
        }
        try {
            String fieldGetterName = StringUtil.getFieldGetterName(fieldName);
            declaredMethod = ReflectUtil.getDeclaredMethod(obj.getClass(), fieldGetterName);
            if (declaredMethod != null) {
                return declaredMethod.invoke(obj, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger().warn("\u83b7\u53d6\u5b57\u6bb5\u503c\u51fa\u9519!{}", e);
        }
        try {
            String fieldIsMethodName = StringUtil.getFieldIsMethodName(fieldName);
            declaredMethod = ReflectUtil.getDeclaredMethod(obj.getClass(), fieldIsMethodName);
            if (declaredMethod != null) {
                return declaredMethod.invoke(obj, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger().info("\u83b7\u53d6\u5b57\u6bb5\u4e4b\u51fa\u9519!{}", e.getMessage());
        }
        LoggerFactory.getLogger().info("{}\u6ca1\u6709{} getter\u65b9\u6cd5,\u901a\u8fc7gett\u83b7\u53d6\u503c\u5931\u8d25", obj.getClass().getName(), fieldName);
        return null;
    }

    public static Class<?> getGenericType(Field f) {
        try {
            Type mapMainType = f.getGenericType();
            if (mapMainType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)mapMainType;
                Type[] types = parameterizedType.getActualTypeArguments();
                return (Class)types[0];
            }
            throw new RuntimeException(String.format("\u5728%s\u5b57\u6bb5\u627e\u4e0d\u5230\u6cdb\u578b\u4fe1\u606f\uff01\uff01", f.getName()));
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Field> getNotFinalFields(Object object) {
        List<Field> fieldList = ReflectUtil.getAllFields(object);
        Iterator<Field> iterator = fieldList.iterator();
        while (iterator.hasNext()) {
            if (!ReflectUtil.isFieldFinal(iterator.next())) continue;
            iterator.remove();
        }
        return fieldList;
    }

    public static List<Field> getAllFields(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> class1 = object instanceof Class ? (Class<?>)object : object.getClass(); class1 != Object.class; class1 = class1.getSuperclass()) {
            Collections.addAll(fieldList, class1.getDeclaredFields());
        }
        return fieldList;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Class<?> class4Log = clazz;
        while (clazz != Object.class) {
            try {
                return clazz.getField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                clazz = clazz.getSuperclass();
            }
        }
        LoggerFactory.getLogger().warn(class4Log.getName() + "\u4e2d\u627e\u4e0dpublic\u7684" + fieldName + "\u5b57\u6bb5");
        return null;
    }

    public static ReflectResult getChainField(Class<?> clazz, String fieldName) {
        String[] fields = fieldName.split("\\.");
        Field field = null;
        Class<?> target = clazz;
        ReflectResult result = new ReflectResult();
        for (String temp : fields) {
            field = ReflectUtil.getDeclaredField(target, temp);
            if (field == null) {
                return null;
            }
            result.setTarget(target);
            target = field.getType();
        }
        result.setField(field);
        return result;
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        Class<?> class4Log = clazz;
        while (clazz != Object.class) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                clazz = clazz.getSuperclass();
            }
        }
        LoggerFactory.getLogger().warn(class4Log.getName() + "\u4e2d\u627e\u4e0d\u5230" + fieldName + "\u5b57\u6bb5");
        return null;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        while (clazz != Object.class) {
            try {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException | SecurityException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static boolean isObjBaseData(Object obj) {
        return ReflectUtil.isClassBaseData(obj.getClass());
    }

    public static boolean isClassBaseData(Class<?> clazz) {
        return ReflectUtil.isClassBaseType(clazz) || clazz == String.class || Date.class.isAssignableFrom(clazz);
    }
}

