/*
 * Decompiled with CFR 0.152.
 */
package steed.hibernatemaster.util;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import steed.hibernatemaster.Config;

public class HibernateUtil {
    private static ThreadLocal<Session> threadLocal = new ThreadLocal();
    private static SessionFactory factory;
    private static ThreadLocal<Boolean> closeSession;
    private static ThreadLocal<String> currentDatabase;
    private static ThreadLocal<Map<String, Session>> sessionStory;
    private static Map<String, SessionFactory> factoryMap;
    public static final String mainFactory = "hibernate.cfg.xml";

    public static boolean getColseSession() {
        Boolean closeSession = HibernateUtil.closeSession.get();
        if (closeSession == null) {
            return true;
        }
        return closeSession;
    }

    public static void setCloseSession(boolean closeSession) {
        HibernateUtil.closeSession.set(closeSession);
    }

    public static void setSession(Session session) {
        threadLocal.set(session);
    }

    private static void buildFactory() {
        factory = HibernateUtil.buildFactory(mainFactory);
    }

    private static SessionFactory buildFactory(String configFile) {
        SessionFactory buildFactory = Config.factoryEngine.buildFactory(configFile);
        factoryMap.put(configFile, buildFactory);
        return buildFactory;
    }

    public static Session getSession() {
        Session session = null;
        session = Config.isSignalDatabase ? threadLocal.get() : HibernateUtil.getSessionMap().get(HibernateUtil.getCurrentDatabase());
        if (session == null) {
            session = HibernateUtil.getFactory().openSession();
            if (Config.isSignalDatabase) {
                threadLocal.set(session);
            } else {
                HibernateUtil.getSessionMap().put(HibernateUtil.getCurrentDatabase(), session);
            }
        }
        return session;
    }

    private static Map<String, Session> getSessionMap() {
        if (sessionStory.get() == null) {
            sessionStory.set(new HashMap());
        }
        return sessionStory.get();
    }

    private static String getCurrentDatabase() {
        return currentDatabase.get() == null ? mainFactory : currentDatabase.get();
    }

    public static SessionFactory getFactory() {
        if (Config.isSignalDatabase) {
            return factory;
        }
        SessionFactory sessionFactory = factoryMap.get(HibernateUtil.getCurrentDatabase());
        if (sessionFactory == null) {
            return HibernateUtil.buildFactory(currentDatabase.get());
        }
        return sessionFactory;
    }

    public static void switchDatabase(String configFile) {
        currentDatabase.set(configFile);
    }

    public static void closeSession() {
        Session session = null;
        session = Config.isSignalDatabase ? threadLocal.get() : HibernateUtil.getSessionMap().get(HibernateUtil.getCurrentDatabase());
        if (session != null && session.isOpen()) {
            session.close();
        }
        threadLocal.remove();
        closeSession.remove();
    }

    public static void release() {
        HibernateUtil.closeSession();
        for (Map.Entry<String, Session> e : HibernateUtil.getSessionMap().entrySet()) {
            Session value = e.getValue();
            if (value == null || !value.isOpen()) continue;
            value.close();
        }
        currentDatabase.remove();
        sessionStory.remove();
    }

    static {
        closeSession = new ThreadLocal();
        currentDatabase = new ThreadLocal();
        sessionStory = new ThreadLocal();
        factoryMap = new HashMap<String, SessionFactory>();
        try {
            HibernateUtil.buildFactory();
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }
}

