/*
 * Decompiled with CFR 0.152.
 */
package steed.hibernatemaster.util;

import java.util.HashMap;
import java.util.Map;
import steed.hibernatemaster.domain.BaseDatabaseDomain;
import steed.hibernatemaster.domain.BaseDomain;
import steed.hibernatemaster.util.DaoUtil;
import steed.hibernatemaster.util.HqlGenerator;

public class QueryBuilder {
    private Map<String, Object> queryMap;
    private Class<? extends BaseDatabaseDomain> target;
    private String[] groupBy;
    private String[] selectedField;

    public QueryBuilder() {
        this.queryMap = new HashMap<String, Object>();
    }

    public QueryBuilder(BaseDomain domain) {
        this.queryMap = DaoUtil.putField2Map(domain);
    }

    public QueryBuilder(BaseDatabaseDomain domain) {
        this.queryMap = DaoUtil.putField2Map(domain);
        this.target = domain.getClass();
    }

    private void setGroupBy(String ... groupBy) {
        this.groupBy = groupBy;
    }

    private void setSelectedField(String ... selectedField) {
        this.selectedField = selectedField;
    }

    private QueryBuilder setTarget(Class<? extends BaseDatabaseDomain> target) {
        this.target = target;
        return this;
    }

    public QueryBuilder add(String key, Object value) {
        this.queryMap.put(key, value);
        return this;
    }

    public QueryBuilder addNotEqual(String key, Object value) {
        this.queryMap.put(key + "_not_equal_1", value);
        return this;
    }

    public QueryBuilder addHqlGenerator(HqlGenerator generator) {
        this.queryMap.put("personalHqlGenerator", generator);
        return this;
    }

    public <T> QueryBuilder addNotIn(String key, T ... value) {
        this.queryMap.put(key + "_not_in_1", value);
        return this;
    }

    public <T> QueryBuilder addIn(String key, T ... value) {
        this.queryMap.put(key + "_not_join", value);
        return this;
    }

    public QueryBuilder addNotNull(String key, boolean notNull) {
        this.queryMap.put(key + "_not_null", notNull);
        return this;
    }

    public QueryBuilder addLessThanNoEqual(String key, Object value) {
        this.queryMap.put(key + "_lessThan", value);
        return this;
    }

    public QueryBuilder addMoreThanNoEqual(String key, Object value) {
        this.queryMap.put(key + "_greaterThan", value);
        return this;
    }

    public QueryBuilder addRawHqlPart(String rawHqlPart) {
        this.queryMap.put("_raw_hql_part", rawHqlPart);
        return this;
    }

    private QueryBuilder addGroup(String groupId, String key, Object value) {
        this.queryMap.put(key + "_" + groupId + "_OrGroup", value);
        return this;
    }

    public QueryBuilder addLessThan(String key, Object value) {
        this.queryMap.put(key + "_max_1", value);
        return this;
    }

    public QueryBuilder addMoreThan(String key, Object value) {
        this.queryMap.put(key + "_min_1", value);
        return this;
    }

    @Deprecated
    public Map<String, Object> getQueryMap() {
        return this.queryMap;
    }

    public Map<String, Object> getWhere() {
        return this.queryMap;
    }
}

