/*
 * Decompiled with CFR 0.152.
 */
package steed.util.base;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Id;
import javax.persistence.IdClass;
import org.slf4j.Logger;
import steed.hibernatemaster.annotation.FuzzyQuery;
import steed.hibernatemaster.domain.BaseDomain;
import steed.hibernatemaster.domain.BaseRelationalDatabaseDomain;
import steed.hibernatemaster.domain.UnionKeyDomain;
import steed.hibernatemaster.exception.DomainIdAnnotationNotFoundException;
import steed.hibernatemaster.util.DaoUtil;
import steed.util.base.BaseUtil;
import steed.util.base.DifferenceField;
import steed.util.base.StringUtil;
import steed.util.logging.LoggerFactory;
import steed.util.reflect.ReflectUtil;

public class DomainUtil {
    private static Logger logger = org.slf4j.LoggerFactory.getLogger(DomainUtil.class);

    public static int domainHashCode(BaseDomain baseDomain) {
        if (baseDomain == null) {
            return 0;
        }
        try {
            Serializable tempObject = DomainUtil.getDomainId(baseDomain);
            if (tempObject == null) {
                return -1;
            }
            return tempObject.hashCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void purify(BaseDomain domain) {
        List<Field> allFields = ReflectUtil.getAllFields(domain);
        for (Field temp : allFields) {
            if (!BaseDomain.class.isAssignableFrom(temp.getType())) continue;
            temp.setAccessible(true);
            try {
                temp.set(domain, null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LoggerFactory.getLogger().warn("\u51c0\u5316\u5b9e\u4f53\u7c7b\u51fa\u9519", e);
            }
        }
    }

    public static String getDomainIDName(Class<? extends BaseDomain> clazz) {
        if (clazz.getAnnotation(IdClass.class) != null) {
            return "domainID";
        }
        try {
            Method m = DomainUtil.getIDmethod(clazz);
            if (m != null) {
                String name = m.getName();
                if (name.startsWith("is")) {
                    return name.substring(2, 3).toLowerCase() + name.substring(3);
                }
                return name.substring(3, 4).toLowerCase() + name.substring(4);
            }
        }
        catch (Exception e) {
            throw DomainUtil.createFindIdException(clazz, e);
        }
        try {
            Field f = DomainUtil.getIDfield(clazz);
            if (f != null) {
                return f.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw DomainUtil.createFindIdException(clazz, e);
        }
        throw DomainUtil.createIDNotfoundException(clazz);
    }

    public static Class<? extends Serializable> getDomainIDClass(Class<? extends BaseDomain> clazz) {
        IdClass annotation = clazz.getAnnotation(IdClass.class);
        if (annotation != null) {
            return annotation.value();
        }
        try {
            Field f = ReflectUtil.getDeclaredField(clazz, DomainUtil.getDomainIDName(clazz));
            if (f != null) {
                return f.getType();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw DomainUtil.createFindIdException(clazz, e);
        }
        throw DomainUtil.createIDNotfoundException(clazz);
    }

    public static BaseDomain fillID2Domain(Serializable id, BaseDomain baseDomain) {
        Class<?> domainClass = baseDomain.getClass();
        Field iDfield = DomainUtil.getIDfield(domainClass);
        try {
            if (iDfield != null) {
                iDfield.setAccessible(true);
                iDfield.set(baseDomain, id);
                return baseDomain;
            }
            Method iDmethod = DomainUtil.getIDmethod(domainClass);
            if (iDmethod != null) {
                domainClass.getMethod(iDmethod.getName().replaceFirst("get", "set"), iDmethod.getReturnType()).invoke((Object)baseDomain, id);
                return baseDomain;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(domainClass.getName() + "\u4e2d\u6ca1\u6709id\u5b57\u6bb5\u6216ID\u7684set\u65b9\u6cd5\uff01\uff01");
        }
        throw new RuntimeException(domainClass.getName() + "\u4e2d\u6ca1\u6709id\u5b57\u6bb5\u6216ID\u7684set\u65b9\u6cd5\uff01\uff01");
    }

    public static Serializable getDomainId(BaseDomain baseDomain) {
        if (baseDomain instanceof UnionKeyDomain) {
            return ((UnionKeyDomain)((Object)baseDomain)).getDomainID();
        }
        Class<?> clazz = baseDomain.getClass();
        try {
            Method m = DomainUtil.getIDmethod(clazz);
            if (m != null) {
                return (Serializable)m.invoke((Object)baseDomain, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw DomainUtil.createFindIdException(clazz, e);
        }
        try {
            Field f = DomainUtil.getIDfield(clazz);
            if (f != null) {
                return (Serializable)f.get(baseDomain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw DomainUtil.createFindIdException(clazz, e);
        }
        throw DomainUtil.createIDNotfoundException(clazz);
    }

    private static RuntimeException createFindIdException(Class<? extends BaseDomain> clazz, Exception e) {
        logger.error("\u5728" + clazz.getName() + "\u627e\u5230\u542b\u6709" + Id.class.getName() + "\u6ce8\u89e3\u7684get\u65b9\u6cd5,\u6216\u5b57\u6bb5\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
        return new RuntimeException("\u5728" + clazz.getName() + "\u627e\u5230\u542b\u6709" + Id.class.getName() + "\u6ce8\u89e3\u7684get\u65b9\u6cd5,\u6216\u5b57\u6bb5\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", e);
    }

    private static DomainIdAnnotationNotFoundException createIDNotfoundException(Class<? extends Object> clazz) {
        logger.error("\u5728" + clazz.getName() + "\u4e2d\u627e\u4e0d\u5230\u542b\u6709" + Id.class.getName() + "\u6ce8\u89e3\u7684get\u65b9\u6cd5,\u6216\u5b57\u6bb5\u3002");
        DomainIdAnnotationNotFoundException exception = new DomainIdAnnotationNotFoundException("\u5728" + clazz.getName() + "\u4e2d\u627e\u4e0d\u5230\u542b\u6709" + Id.class.getName() + "\u6ce8\u89e3\u7684get\u65b9\u6cd5,\u6216\u5b57\u6bb5\u3002");
        exception.printStackTrace();
        return exception;
    }

    public static boolean domainEquals(BaseDomain baseDomain, Object obj2) {
        if (baseDomain == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        Class<?> clazz2 = obj2.getClass();
        if (BaseDomain.class.isAssignableFrom(clazz2)) {
            Serializable domainId = DomainUtil.getDomainId(baseDomain);
            Serializable id2 = DomainUtil.getDomainId((BaseDomain)obj2);
            if (domainId == null) {
                return id2 == null;
            }
            if (id2 == null) {
                return false;
            }
            return id2.equals(domainId);
        }
        if (ReflectUtil.isObjBaseData(obj2)) {
            Serializable domainId = DomainUtil.getDomainId(baseDomain);
            return obj2.equals(domainId);
        }
        return false;
    }

    public static Field getIDfield(Class<? extends BaseDomain> clazz) {
        Field[] fields;
        if (clazz.getAnnotation(IdClass.class) != null) {
            StringBuffer sb = new StringBuffer("\u6309\u7167\u7ea6\u5b9a\u542b\u6709");
            sb.append(IdClass.class.getName());
            sb.append("\u6ce8\u89e3\u7684domain\u4e0d\u80fd\u6709ID\u5b57\u6bb5!!!\u53ea\u80fd\u6709getDomainID()\u65b9\u6cd5\u3002");
            throw new RuntimeException(sb.toString());
        }
        for (Field f : fields = clazz.getDeclaredFields()) {
            f.setAccessible(true);
            Id temp = f.getAnnotation(Id.class);
            if (temp == null) continue;
            return f;
        }
        if (clazz == BaseDomain.class) {
            return null;
        }
        return DomainUtil.getIDfield(clazz.getSuperclass());
    }

    public static Method getIDmethod(Class<? extends BaseDomain> clazz) {
        Method[] methods;
        if (clazz.getAnnotation(IdClass.class) != null) {
            try {
                return clazz.getDeclaredMethod("getDomainID", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("\u542b\u6709" + IdClass.class.getName() + "\u7684domain\u5fc5\u987b\u5b9e\u73b0" + UnionKeyDomain.class.getName() + "\u63a5\u53e3!!!", e);
            }
        }
        for (Method m : methods = clazz.getDeclaredMethods()) {
            Id aa = m.getAnnotation(Id.class);
            if (aa == null) continue;
            return m;
        }
        if (clazz == BaseDomain.class) {
            return null;
        }
        return DomainUtil.getIDmethod(clazz.getSuperclass());
    }

    public static <T> void fillDomain(T filled, T fill, Collection<String> fieldsNotSkip) {
        DomainUtil.fillDomain(filled, fill, fieldsNotSkip, false);
    }

    public static <T> List<DifferenceField> getDifferenceField(T oldObject, T newObj, Collection<String> fieldsNotSkip, boolean strictlyMode) {
        List<Field> fields = ReflectUtil.getAllFields(newObj);
        ArrayList<DifferenceField> differenceFields = new ArrayList<DifferenceField>();
        try {
            if (fieldsNotSkip == null) {
                fieldsNotSkip = new ArrayList<String>();
            }
            for (Field f : fields) {
                if (ReflectUtil.isFieldFinal(f)) continue;
                f.setAccessible(true);
                Object newField = DomainUtil.getFieldValue(newObj, f);
                boolean isNull = strictlyMode ? newField == null : BaseUtil.isObjEmpty(newField);
                if (isNull && !fieldsNotSkip.contains(f.getName())) continue;
                Object oldField = DomainUtil.getFieldValue(oldObject, f);
                if ((newField != null || oldField == null) && (newField == null || newField.equals(oldField))) continue;
                differenceFields.add(new DifferenceField(f.getName(), newObj.getClass(), newField, oldField, f));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LoggerFactory.getLogger().info("\u83b7\u53d6\u5b57\u6bb5\u503c\u51fa\u9519", e);
        }
        return differenceFields;
    }

    private static <T> Object getFieldValue(T target, Field f) throws IllegalAccessException {
        Object field = ReflectUtil.getFieldValueByGetter(target, f.getName());
        if (field == null) {
            field = f.get(target);
        }
        return field;
    }

    public static <T> List<DifferenceField> fillDomain(T filled, T fill, Collection<String> fieldsNotSkip, boolean strictlyMode) {
        List<DifferenceField> differenceField = DomainUtil.getDifferenceField(filled, fill, fieldsNotSkip, strictlyMode);
        for (DifferenceField temp : differenceField) {
            try {
                temp.getField().set(filled, temp.getNewField());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LoggerFactory.getLogger().info("\u8bbe\u7f6e\u5b57\u6bb5\u51fa\u9519", e);
            }
        }
        return differenceField;
    }

    private static void fuzzyQueryInitialize(String prefix, BaseDomain obj, boolean skipId, String ... fieldsSkip) {
        ArrayList fieldsSkipList = new ArrayList();
        Collections.addAll(fieldsSkipList, fieldsSkip);
        List<Field> allFields = ReflectUtil.getAllFields(obj);
        for (Field f : allFields) {
            try {
                if (DaoUtil.isSelectIndex(f.getName()) > 0) continue;
                f.setAccessible(true);
                Object value = f.get(obj);
                if (fieldsSkipList.contains(prefix + f.getName())) continue;
                if (value instanceof String && !StringUtil.isStringEmpty((String)value)) {
                    if (skipId && ReflectUtil.getAnnotation(Id.class, obj.getClass(), f) != null) continue;
                    FuzzyQuery annotation = ReflectUtil.getAnnotation(FuzzyQuery.class, obj.getClass(), f);
                    if (annotation == null) {
                        f.set(obj, "%" + value + "%");
                        continue;
                    }
                    FuzzyQuery.FuzzyQuerystrategy value2 = annotation.value();
                    switch (value2) {
                        case left: {
                            f.set(obj, "%" + value);
                            break;
                        }
                        case right: {
                            f.set(obj, value + "%");
                            break;
                        }
                        case both: {
                            f.set(obj, "%" + value + "%");
                            break;
                        }
                    }
                    continue;
                }
                if (!(value instanceof BaseDomain) || !BaseUtil.isObjEmpty(DomainUtil.getDomainId((BaseDomain)value))) continue;
                DomainUtil.fuzzyQueryInitialize(f.getName() + ".", (BaseDomain)value, skipId, fieldsSkip);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void fuzzyQueryInitialize(BaseDomain obj, String ... fieldsSkip) {
        DomainUtil.fuzzyQueryInitialize(obj, true, fieldsSkip);
    }

    public static void fuzzyQueryInitialize(BaseDomain obj, boolean skipId, String ... fieldsSkip) {
        DomainUtil.fuzzyQueryInitialize("", obj, skipId, fieldsSkip);
    }

    public static Map<String, Object> putField2Map(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DomainUtil.putField2Map(obj, map, "");
        return map;
    }

    public static void putField2Map(Object obj, Map<String, Object> map, String prefixName) {
        DomainUtil.putField2Map(obj, map, prefixName, true);
    }

    public static void putField2Map(Object obj, Map<String, Object> map, String prefixName, boolean getFieldByGetter) {
        try {
            List<Field> Fields = ReflectUtil.getNotFinalFields(obj);
            for (Field f : Fields) {
                String fieldName = f.getName();
                Object value = null;
                if (getFieldByGetter) {
                    value = ReflectUtil.getFieldValueByGetter(obj, fieldName);
                }
                if (value == null) {
                    f.setAccessible(true);
                    value = f.get(obj);
                }
                if (value == null) continue;
                if (!(value instanceof BaseRelationalDatabaseDomain)) {
                    map.put(prefixName + fieldName, value);
                    continue;
                }
                DomainUtil.putField2Map(value, map, prefixName + fieldName + ".");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LoggerFactory.getLogger().debug("putField2Map\u51fa\u9519", e);
        }
    }

    public static void setDomainId(BaseDomain baseDomain, Serializable serializable) {
        Class<?> class1 = baseDomain.getClass();
        String domainIDName = DomainUtil.getDomainIDName(class1);
        String fieldSetterName = StringUtil.getFieldSetterName(domainIDName);
        try {
            Method method = class1.getMethod(fieldSetterName, serializable.getClass());
            method.invoke((Object)baseDomain, serializable);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(class1 + "\u4e2d\u6ca1\u6709" + fieldSetterName + "\u65b9\u6cd5", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(class1 + "\u4e2d\u7684" + fieldSetterName + "\u65b9\u6cd5\u6709\u8bef", e);
        }
    }
}

