/*
 * Decompiled with CFR 0.152.
 */
package steed.util.base;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import steed.util.base.StringUtil;

public class RegUtil {
    public static final String regChineseAndChar = "([\\u4E00-\\u9FA5]*\\w*_*)*";
    public static final String regChinese = "[\\u4E00-\\u9FFF]+";
    public static final String regIpAddress = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    public static final String regEmail = "\\S+\\@\\S+\\.\\S+";
    public static final String regNotStrictEmail = "\\S+\\@\\S+";
    public static final String mobilePhoneNumber = "1\\d{10}";
    public static final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    public static boolean validate(String reg, String str) {
        if (!reg.startsWith("^")) {
            reg = "^" + reg;
        }
        if (!reg.endsWith("$")) {
            reg = reg + "$";
        }
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(StringUtil.getNotNullString(str));
        return m.find();
    }

    public static Pattern getPattern(String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern != null) {
            return pattern;
        }
        pattern = Pattern.compile(regex);
        patternCache.put(regex, pattern);
        return pattern;
    }
}

