/*
 * Decompiled with CFR 0.152.
 */
package steed.util.logging.impl;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.ReflectionUtil;
import steed.util.logging.Logger;

class Log4jLogger
extends Logger {
    private org.apache.logging.log4j.Logger log;

    protected LoggerContext getContext(Class<?> callerClass) {
        ClassLoader cl = null;
        if (callerClass != null) {
            cl = callerClass.getClassLoader();
        }
        if (cl == null) {
            cl = LoaderUtil.getThreadContextClassLoader();
        }
        return LogManager.getContext((ClassLoader)cl, (boolean)false);
    }

    protected LoggerContext getContext() {
        Class anchor = ReflectionUtil.getCallerClass((String)Logger.class.getName(), (String)"steed.util.logging");
        return anchor == null ? LogManager.getContext() : this.getContext(ReflectionUtil.getCallerClass((Class)anchor));
    }

    Log4jLogger(Class<?> clazz) {
        this.log = this.getContext().getLogger(clazz.getName());
    }

    Log4jLogger(String name) {
        this.log = LogManager.getLogger((String)name);
    }

    @Override
    public void debug(String format, Object ... args) {
        String msg = String.format(format, args);
        this.log.log(Level.DEBUG, msg);
    }

    @Override
    public void info(String format, Object ... args) {
        String msg = String.format(format, args);
        this.log.log(Level.INFO, msg);
    }

    @Override
    public void warn(String format, Object ... args) {
        String msg = String.format(format, args);
        this.log.log(Level.WARN, msg);
    }

    @Override
    public void error(String format, Object ... args) {
        String msg = String.format(format, args);
        this.log.log(Level.ERROR, msg);
    }

    @Override
    public void info(String message) {
        this.log.log(Level.INFO, message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.log(Level.INFO, message, t);
    }

    @Override
    public void debug(String message) {
        this.log.log(Level.DEBUG, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log.log(Level.DEBUG, message, t);
    }

    @Override
    public void warn(String message) {
        this.log.log(Level.WARN, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.log(Level.WARN, message, t);
    }

    @Override
    public void error(String message) {
        this.log.log(Level.ERROR, message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.log(Level.ERROR, message, t);
    }

    @Override
    public void fatal(String message) {
        this.log.log(Level.FATAL, message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log.log(Level.FATAL, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabled(Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isEnabled(Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isEnabled(Level.FATAL);
    }

    @Override
    public void trace(String message) {
        this.log.log(Level.TRACE, message);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.log.log(Level.TRACE, message, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }
}

