/*
 * Decompiled with CFR 0.152.
 */
package com.bigeek.flink.batch.connectors.ethereum;

import com.bigeek.flink.utils.EthereumWrapper;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.response.EthBlock;

public class EthereumInputSource
extends RichInputFormat<EthBlock, GenericInputSplit> {
    private Logger logger = LoggerFactory.getLogger(EthereumInputSource.class);
    private Integer start;
    private Integer end;
    private Integer tries = 0;
    private boolean reachedEnd = false;
    private String clientAddress;
    private Integer split;
    private Long timeoutSeconds;

    public EthereumInputSource(String clientAddress, Integer start, Integer end) {
        this.start = start;
        this.end = end;
        this.clientAddress = clientAddress;
    }

    public EthereumInputSource(String clientAddress, Integer start, Integer end, Long timeoutSeconds) {
        this.start = start;
        this.end = end;
        this.clientAddress = clientAddress;
        this.timeoutSeconds = timeoutSeconds;
    }

    public EthereumInputSource(String clientAddress, Integer start, Integer end, Long timeoutSeconds, Integer tries) {
        this.start = start;
        this.end = end;
        this.clientAddress = clientAddress;
        this.timeoutSeconds = timeoutSeconds;
        this.tries = tries;
    }

    public EthereumInputSource() {
    }

    public void configure(Configuration parameters) {
        if (StringUtils.isEmpty((CharSequence)this.clientAddress)) {
            this.clientAddress = parameters.getString("web3j.clientAddress", "http://localhost:8545");
        }
        if (this.timeoutSeconds != null) {
            this.timeoutSeconds = parameters.getLong("web3j.timeout", this.timeoutSeconds.longValue());
        }
        if (this.tries != null) {
            this.tries = parameters.getInteger("web3j.tries", this.tries.intValue());
        }
        Web3j web3j = EthereumWrapper.configureInstance(this.clientAddress, this.timeoutSeconds);
        if (this.start == null) {
            this.start = parameters.getInteger("web3j.start", 0);
        }
        if (this.end == null) {
            int latest;
            try {
                latest = ((EthBlock)web3j.ethGetBlockByNumber(DefaultBlockParameter.valueOf((String)"latest"), false).send()).getBlock().getNumber().intValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end = parameters.getInteger("web3j.end", latest);
        }
        if (this.start >= this.end) {
            throw new IllegalArgumentException("Start block must have less value than end block");
        }
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
        return cachedStatistics;
    }

    public GenericInputSplit[] createInputSplits(int minNumSplits) {
        GenericInputSplit[] ret = new GenericInputSplit[this.end - this.start + 1];
        int startLocal = this.start;
        for (int i = 0; i <= ret.length && startLocal <= this.end; ++startLocal, ++i) {
            ret[i] = new GenericInputSplit(startLocal, ret.length);
        }
        return ret;
    }

    public InputSplitAssigner getInputSplitAssigner(GenericInputSplit[] inputSplits) {
        return new DefaultInputSplitAssigner((InputSplit[])inputSplits);
    }

    public void open(GenericInputSplit split) {
        this.split = split.getSplitNumber();
        this.reachedEnd = false;
    }

    public boolean reachedEnd() {
        return this.reachedEnd;
    }

    public EthBlock nextRecord(EthBlock reuse) throws IOException {
        Integer tryCounter = 0;
        do {
            this.logger.info("Getting block {} in try {}", (Object)this.split, (Object)tryCounter);
            try {
                reuse = (EthBlock)EthereumWrapper.getInstance().ethGetBlockByNumber(DefaultBlockParameter.valueOf((BigInteger)BigInteger.valueOf(this.split.intValue())), true).send();
                this.logger.info("Block got {} in try {}", (Object)this.split, (Object)tryCounter);
                this.reachedEnd = true;
            }
            catch (Exception ex) {
                Integer n = tryCounter;
                Integer n2 = tryCounter = Integer.valueOf(tryCounter + 1);
                this.logger.error("Error getting the block added increment try {}", (Object)tryCounter, (Object)ex);
                if (tryCounter < this.tries) continue;
                this.logger.error("Throw exception, not more tries exception: ", (Throwable)ex);
                throw ex;
            }
        } while (!this.reachedEnd && tryCounter < this.tries);
        return reuse;
    }

    public void close() {
    }
}

