/*
 * Decompiled with CFR 0.152.
 */
package com.bigeek.flink.utils;

import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.ipc.UnixIpcService;
import org.web3j.protocol.ipc.WindowsIpcService;

public class EthereumUtils {
    private static OkHttpClient createOkHttpClient(Long timeoutSeconds) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (timeoutSeconds != null) {
            builder.connectTimeout(timeoutSeconds.longValue(), TimeUnit.SECONDS);
            builder.readTimeout(timeoutSeconds.longValue(), TimeUnit.SECONDS);
            builder.writeTimeout(timeoutSeconds.longValue(), TimeUnit.SECONDS);
        }
        return builder.build();
    }

    public static Web3j generateClient(String clientAddress, Long timeoutSeconds) {
        if (StringUtils.isEmpty((CharSequence)clientAddress)) {
            throw new IllegalArgumentException("You have to define client address, use constructor or environment variable 'web3j.clientAddress'");
        }
        Object web3jService = clientAddress.startsWith("http") ? new HttpService(clientAddress, EthereumUtils.createOkHttpClient(timeoutSeconds), false) : (System.getProperty("os.name").toLowerCase().startsWith("win") ? new WindowsIpcService(clientAddress) : new UnixIpcService(clientAddress));
        return Web3j.build((Web3jService)web3jService);
    }
}

