/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.connection.client.impl;

import com.bld.commons.connection.client.RestClientConnection;
import com.bld.commons.connection.model.BasicRequest;
import com.bld.commons.connection.model.MapRequest;
import com.bld.commons.connection.model.ObjectRequest;
import com.bld.commons.connection.utils.RestConnectionMapper;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class RestClientConnectionImpl
implements RestClientConnection {
    @Value(value="${com.dxc.connection.proxy.port:}")
    private Integer portProxy;
    @Value(value="${com.dxc.connection.proxy.ip:}")
    private String proxy;
    private static final List<HttpMethod> HTTP_METHODS = Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private RestTemplate restTemplate = this.restTemplate();

    @Override
    public <T> T entityRestTemplate(MapRequest mapRequest, Class<T> responseClass) throws Exception {
        MapUtils.unmodifiableMap((Map)mapRequest.getHttpHeaders());
        HttpEntity request = new HttpEntity((MultiValueMap)mapRequest.getHttpHeaders());
        String url = mapRequest.getUrl();
        if (HTTP_METHODS.contains(mapRequest.getMethod())) {
            MultiValueMap<String, Object> body = RestConnectionMapper.mapToMultiValueMap((Map)mapRequest.getData());
            request = new HttpEntity(body, (MultiValueMap)mapRequest.getHttpHeaders());
        } else {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)mapRequest.getUrl());
            RestConnectionMapper.builderQuery(builder, (Map)mapRequest.getData());
            url = builder.toUriString();
        }
        RestBuilder restBuilder = new RestBuilder(url, request);
        ResponseEntity<T> response = this.getResponseEntity(mapRequest, restBuilder, responseClass);
        return (T)response.getBody();
    }

    @Override
    public <T> T entityRestTemplate(ObjectRequest<?> objectRequest, Class<T> responseClass) throws Exception {
        HttpEntity request = new HttpEntity(objectRequest.getData(), (MultiValueMap)objectRequest.getHttpHeaders());
        RestBuilder restBuilder = new RestBuilder(objectRequest.getUrl(), request);
        ResponseEntity<T> response = this.getResponseEntity(objectRequest, restBuilder, responseClass);
        return (T)response.getBody();
    }

    @Override
    public <T> List<T> listRestTemplate(MapRequest mapRequest, Class<T[]> responseClass) throws Exception {
        MapUtils.unmodifiableMap((Map)mapRequest.getHttpHeaders());
        HttpEntity request = new HttpEntity((MultiValueMap)mapRequest.getHttpHeaders());
        String url = mapRequest.getUrl();
        if (HTTP_METHODS.contains(mapRequest.getMethod())) {
            MultiValueMap<String, Object> body = RestConnectionMapper.mapToMultiValueMap((Map)mapRequest.getData());
            request = new HttpEntity(body, (MultiValueMap)mapRequest.getHttpHeaders());
        } else {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)mapRequest.getUrl());
            RestConnectionMapper.builderQuery(builder, (Map)mapRequest.getData());
            url = builder.toUriString();
        }
        RestBuilder restBuilder = new RestBuilder(url, request);
        ResponseEntity<T[]> response = this.getResponseEntity(mapRequest, restBuilder, responseClass);
        return Arrays.asList((Object[])response.getBody());
    }

    @Override
    public <T> List<T> listRestTemplate(ObjectRequest<?> objectRequest, Class<T[]> responseClass) throws Exception {
        HttpEntity request = new HttpEntity(objectRequest.getData(), (MultiValueMap)objectRequest.getHttpHeaders());
        RestBuilder restBuilder = new RestBuilder(objectRequest.getUrl(), request);
        ResponseEntity<T[]> response = this.getResponseEntity(objectRequest, restBuilder, responseClass);
        return Arrays.asList((Object[])response.getBody());
    }

    private <T> ResponseEntity<T> getResponseEntity(BasicRequest<?> basicRequest, RestBuilder restBuilder, Class<T> responseClass) {
        this.setTimeout(basicRequest);
        return this.restTemplate.exchange(restBuilder.getUrl(), basicRequest.getMethod(), restBuilder.getRequest(), responseClass, basicRequest.getUriParams());
    }

    private <K> void setTimeout(BasicRequest<K> basicRequest) {
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
        if (basicRequest.getTimeout() != null) {
            SimpleClientHttpRequestFactory rf = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
            rf.setReadTimeout(basicRequest.getTimeout().intValue());
            rf.setConnectTimeout(basicRequest.getTimeout().intValue());
        }
    }

    private RestTemplate restTemplate() {
        RestTemplate restTemplate = null;
        if (StringUtils.isNotEmpty((CharSequence)this.proxy) && this.portProxy != null) {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxy, (int)this.portProxy));
            requestFactory.setProxy(proxy);
            restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        } else {
            restTemplate = new RestTemplate();
            restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        }
        return restTemplate;
    }

    private class RestBuilder {
        private String url;
        private HttpEntity<?> request;

        private RestBuilder(String url, HttpEntity<?> request) {
            this.url = url;
            this.request = request;
        }

        private String getUrl() {
            return this.url;
        }

        private HttpEntity<?> getRequest() {
            return this.request;
        }
    }
}

