/*
 * Decompiled with CFR 0.152.
 */
package com.bld.commons.connection.model;

import jakarta.validation.constraints.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public abstract class BasicRequest<T> {
    protected T data;
    @NotNull
    private String url;
    @NotNull
    private HttpMethod method;
    private HttpHeaders httpHeaders;
    private Object[] uriParams;
    private Integer timeout;

    protected BasicRequest(String url, HttpMethod method, MediaType mediaType) {
        this.url = url;
        this.method = method;
        this.init();
        this.setContentType(mediaType);
    }

    private void init() {
        this.httpHeaders = new HttpHeaders();
        this.uriParams = new Object[0];
    }

    protected BasicRequest(String url, HttpMethod method) {
        this.url = url;
        this.method = method;
        this.init();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public void addHeader(String props, String value) {
        this.httpHeaders.add(props, value);
    }

    public void removeHaeder(String props) {
        this.httpHeaders.remove((Object)props);
    }

    public Object[] getUriParams() {
        return this.uriParams;
    }

    public void addUriParams(Object ... uriParams) {
        int i = this.uriParams.length;
        for (Object uriParam : uriParams) {
            this.uriParams[i++] = uriParam;
        }
    }

    public void clearUriParamas() {
        this.uriParams = new Object[0];
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public T getData() {
        return this.data;
    }

    public void setContentType(MediaType mediaType) {
        this.httpHeaders.setContentType(mediaType);
    }

    public void setBearerAuth(String token) {
        this.httpHeaders.setBearerAuth(token);
    }

    public void setBasicAuth(String usermame, String password) {
        this.httpHeaders.setBasicAuth(usermame, password);
    }
}

