/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.classes.generator.impl;

import bld.commons.classes.attributes.StandardImportType;
import bld.commons.classes.generator.ClassesGenerator;
import bld.commons.classes.generator.annotation.FindImport;
import bld.commons.classes.model.ModelAnnotation;
import bld.commons.classes.model.ModelClass;
import bld.commons.classes.model.ModelClasses;
import bld.commons.classes.model.ModelComponentClass;
import bld.commons.classes.model.ModelFreemarker;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassesGeneratorImpl
implements ClassesGenerator {
    private static final String ANNOTATION = "Annotation";
    private static final Logger logger = LoggerFactory.getLogger(ClassesGeneratorImpl.class);
    private Template template = null;

    public ClassesGeneratorImpl(Configuration configuration) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        this.template = configuration.getTemplate("typological.ftl");
    }

    @Override
    public void writeClass(ModelClasses modelClasses, String basedir) throws Exception {
        for (ModelClass modelClass : modelClasses.getClasses()) {
            this.removeImport(modelClass);
            ModelFreemarker modelFreemarker = new ModelFreemarker(modelClass);
            String outputDirectory = basedir + "/" + modelClass.getPackageName().replace(".", "/");
            File directory = new File(outputDirectory);
            if (!directory.exists()) {
                directory.mkdirs();
                logger.info("mkdir -p " + outputDirectory);
            }
            File javaSourceFile = new File(directory, modelClass.getName() + ".java");
            boolean check = true;
            try {
                if (javaSourceFile.exists()) continue;
                logger.info("Class generation: " + javaSourceFile.getAbsolutePath());
                FileWriter javaSourceFileWriter = new FileWriter(javaSourceFile);
                this.template.process(modelFreemarker, javaSourceFileWriter);
            }
            catch (Exception e) {
                check = false;
                throw e;
            }
            finally {
                if (check) continue;
                javaSourceFile.delete();
            }
        }
    }

    @Override
    public void writeClasses(Collection<ModelClasses> listModelClasses, String basedir) throws Exception {
        for (ModelClasses modelClasses : listModelClasses) {
            this.writeClass(modelClasses, basedir);
        }
    }

    private void findAllImport(ModelComponentClass modelComponentClass, Set<String> imports) throws Exception {
        for (Field field : modelComponentClass.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(FindImport.class)) {
                try {
                    String type = BeanUtils.getProperty(modelComponentClass, field.getName());
                    if (modelComponentClass instanceof ModelAnnotation) {
                        type = ANNOTATION + (type.startsWith("@") ? type.substring(1) : type);
                    }
                    if (!StandardImportType.contains(type)) continue;
                    imports.add(StandardImportType.valueOf(type).getStandardImport());
                }
                catch (Exception type) {}
                continue;
            }
            Object value = PropertyUtils.getProperty(modelComponentClass, field.getName());
            if (value instanceof ModelComponentClass) {
                this.findAllImport((ModelComponentClass)value, imports);
                continue;
            }
            if (!(value instanceof Collection)) continue;
            try {
                Collection list = (Collection)value;
                for (ModelComponentClass item : list) {
                    this.findAllImport(item, imports);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeClasses(Collection<ModelClasses> listModelClasses, ProcessingEnvironment processingEnv) throws Exception {
        for (ModelClasses modelClasses : listModelClasses) {
            this.writeClass(modelClasses, processingEnv);
        }
    }

    @Override
    public void writeClass(ModelClasses modelClasses, ProcessingEnvironment processingEnv) throws Exception {
        for (ModelClass modelClass : modelClasses.getClasses()) {
            this.removeImport(modelClass);
            System.out.println("Class generated: " + modelClass.getPackageName() + "." + modelClass.getName());
            ModelFreemarker modelFreemarker = new ModelFreemarker(modelClass);
            JavaFileObject builderFile = processingEnv.getFiler().createSourceFile(modelClass.getPackageName() + "." + modelClass.getName(), new Element[0]);
            Writer javaSourceFileWriter = null;
            try {
                javaSourceFileWriter = builderFile.openWriter();
                this.template.process(modelFreemarker, javaSourceFileWriter);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (javaSourceFileWriter == null) continue;
                javaSourceFileWriter.close();
            }
        }
    }

    private void removeImport(ModelClass modelClass) throws Exception {
        HashSet<String> imports = new HashSet<String>();
        this.findAllImport(modelClass, imports);
        modelClass.getImports().addAll(imports);
        imports = new HashSet();
        for (String importClass : modelClass.getImports()) {
            if (!importClass.substring(0, importClass.lastIndexOf(".")).equals(modelClass.getPackageName())) continue;
            imports.add(importClass);
        }
        modelClass.getImports().removeAll(imports);
    }
}

