/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.classes.model;

import bld.commons.classes.generator.annotation.FindImport;
import bld.commons.classes.model.ModelAnnotation;
import bld.commons.classes.model.ModelComponentClass;
import bld.commons.classes.model.ModelGenericType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class ModelParameter
implements ModelComponentClass {
    @JsonProperty(value="parameter")
    @NotNull(message="The \"parameter\" field can not be null to define the \"parameter\" entity")
    private @NotNull(message="The \"parameter\" field can not be null to define the \"parameter\" entity") String name;
    @FindImport
    @NotNull(message="The \"type\" field can not be null to define the \"parameter\" entity")
    private @NotNull(message="The \"type\" field can not be null to define the \"parameter\" entity") String type;
    @JsonProperty(value="final")
    private boolean parameterFinal;
    @Valid
    private Set<ModelAnnotation> annotations;
    @JsonProperty(value="generic-types")
    @Valid
    private List<ModelGenericType> genericTypes;

    public ModelParameter(String name, String type) {
        this.name = name;
        this.type = type;
        this.annotations = new HashSet<ModelAnnotation>();
        this.parameterFinal = false;
        this.genericTypes = new ArrayList<ModelGenericType>();
    }

    public ModelParameter() {
        this.annotations = new HashSet<ModelAnnotation>();
        this.parameterFinal = false;
        this.genericTypes = new ArrayList<ModelGenericType>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<ModelAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<ModelAnnotation> annotations) {
        this.annotations = annotations;
    }

    public boolean isParameterFinal() {
        return this.parameterFinal;
    }

    public void setParameterFinal(boolean parameterFinal) {
        this.parameterFinal = parameterFinal;
    }

    public List<ModelGenericType> getGenericTypes() {
        return this.genericTypes;
    }

    public void setGenericTypes(List<ModelGenericType> genericTypes) {
        this.genericTypes = genericTypes;
    }

    public String toString() {
        String annotation = "";
        for (ModelAnnotation item : this.annotations) {
            annotation = annotation + item.toString() + " ";
        }
        String genericType = "";
        for (ModelGenericType item : this.genericTypes) {
            genericType = genericType + "," + (item.getName().equals("?") ? item.toString() : item.getName());
        }
        if (StringUtils.isNotEmpty(genericType)) {
            genericType = "<" + genericType.substring(1) + ">";
        }
        return annotation + (this.parameterFinal ? " final" : "") + " " + this.type + genericType + " " + this.name;
    }
}

