/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.controller;

import bld.commons.reflection.model.BaseModel;
import bld.commons.reflection.model.CollectionResponse;
import bld.commons.reflection.model.FilterParameter;
import bld.commons.reflection.model.ObjectResponse;
import bld.commons.reflection.model.QueryFilter;
import bld.commons.workspace.WorkModel;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

public class SearchController<ID, T extends BaseModel<ID>, F extends FilterParameter> {
    @Autowired
    private WorkModel workModel;

    @PostMapping(path={"/search"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @Valid
    public CollectionResponse<T> findByFilter(@RequestBody F filter) throws Exception {
        QueryFilter queryFilter = new QueryFilter((FilterParameter)filter);
        return this.workModel.findByFilter(queryFilter);
    }

    @PostMapping(path={"/count"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @Valid
    public ObjectResponse<Long> countByFilter(@RequestBody F filter) throws Exception {
        QueryFilter queryFilter = new QueryFilter((FilterParameter)filter);
        return this.workModel.countByFilter(queryFilter);
    }

    @PostMapping(path={"/search/single-result"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @Valid
    public ObjectResponse<T> singleResultFindByFilter(@RequestBody F filter) throws Exception {
        QueryFilter query2 = new QueryFilter((FilterParameter)filter);
        return this.workModel.findSingleResultByFilter(query2);
    }
}

