/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.annotations.deserialize;

import bld.commons.json.annotations.JsonUpperLowerCase;
import bld.commons.reflection.type.UpperLowerType;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class UpperLowerDeserializer
extends StdDeserializer<String>
implements ContextualDeserializer {
    private UpperLowerType upperLower;

    public UpperLowerDeserializer() {
        super(String.class);
    }

    protected UpperLowerDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonUpperLowerCase jsonUpperLower = property.getAnnotation(JsonUpperLowerCase.class);
        this.upperLower = jsonUpperLower.value();
        return this;
    }

    @Override
    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        String word = p.getText();
        switch (this.upperLower) {
            case LOWER: {
                word = word.toLowerCase();
                break;
            }
            case UPPER: {
                word = word.toUpperCase();
                break;
            }
        }
        return word;
    }
}

