/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.annotations.serialize;

import bld.commons.json.annotations.JsonFile;
import bld.commons.reflection.type.MimeType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Base64;

public class ByteSerializer
extends StdSerializer<byte[]>
implements ContextualSerializer {
    private MimeType mimeType;

    public ByteSerializer() {
        this((Class<byte[]>)null);
    }

    public ByteSerializer(Class<byte[]> t) {
        super(t);
    }

    private String fileBase64(byte[] value) {
        String file = Base64.getEncoder().encodeToString(value);
        if (!MimeType.none.equals((Object)this.mimeType)) {
            file = "data:" + this.mimeType.getMimeType() + ";base64," + file;
        }
        return file;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.fileBase64(value));
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFile jsonFile = property.getAnnotation(JsonFile.class);
        this.mimeType = jsonFile.mimeType();
        return this;
    }
}

