/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.annotations.serialize;

import bld.commons.json.annotations.JsonDateTimeZone;
import bld.commons.reflection.utils.DateUtils;
import bld.commons.reflection.utils.StaticApplicationContext;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.core.env.Environment;

public class DateSerializer<T>
extends StdSerializer<T>
implements ContextualSerializer {
    private Environment env = null;
    protected JsonDateTimeZone dateTimeZone = null;
    private SimpleDateFormat simpleDateFormat = null;

    public DateSerializer() {
        this((Class<T>)null);
        this.env = StaticApplicationContext.getBean(Environment.class);
    }

    public DateSerializer(Class<T> t) {
        super(t);
        this.env = StaticApplicationContext.getBean(Environment.class);
    }

    private DateSerializer(Class<T> classDate, JsonDateTimeZone dateTimeZone, SimpleDateFormat simpleDateFormat) {
        super(classDate);
        this.dateTimeZone = dateTimeZone;
        this.simpleDateFormat = simpleDateFormat;
        this.env = StaticApplicationContext.getBean(Environment.class);
    }

    public String formatDate(T date) {
        String dateString = null;
        if (date instanceof Calendar) {
            dateString = this.simpleDateFormat.format(DateUtils.calendarToDate((Calendar)date));
        } else if (date instanceof Date) {
            dateString = this.simpleDateFormat.format((Date)date);
        } else if (date instanceof Timestamp) {
            dateString = this.simpleDateFormat.format(DateUtils.timestampToDate((Timestamp)date));
        }
        return dateString;
    }

    @Override
    public void serialize(T date, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.formatDate(date));
    }

    private void setSimpleDateFormat(TimeZone timeZone, String format) {
        this.simpleDateFormat = new SimpleDateFormat(format);
        this.simpleDateFormat.setTimeZone(timeZone);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        this.dateTimeZone = property.getAnnotation(JsonDateTimeZone.class);
        if ("${spring.jackson.time-zone}".equals(this.dateTimeZone.timeZone())) {
            if (this.env.getProperty("spring.jackson.time-zone") == null) {
                this.setSimpleDateFormat(TimeZone.getDefault(), this.dateTimeZone.format());
            } else {
                this.setSimpleDateFormat(TimeZone.getTimeZone(this.env.getProperty("spring.jackson.time-zone")), this.dateTimeZone.format());
            }
        } else {
            String timeZone = this.dateTimeZone.timeZone().replace("${", "").replace("}", "");
            this.setSimpleDateFormat(TimeZone.getTimeZone(this.env.getProperty(timeZone, timeZone)), this.dateTimeZone.format());
        }
        if (property.getType() != null && property.getType().getRawClass() != null) {
            return new DateSerializer(property.getType().getRawClass(), this.dateTimeZone, this.simpleDateFormat);
        }
        return this;
    }
}

