/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.model;

import bld.commons.reflection.model.FilterParameter;
import bld.commons.reflection.model.OrderBy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class QueryFilter<T, ID>
implements Serializable {
    public static final String ID = "id";
    private ID id;
    private Set<String> nullables;
    private Map<String, Object> mapParameters;
    private List<OrderBy> listOrderBy;
    private Pageable pageable;
    private Class<T> resultClass;
    private FilterParameter filterParameter;

    public QueryFilter(ID id) {
        this.init();
        this.id = id;
        this.mapParameters.put(ID, id);
    }

    public QueryFilter(FilterParameter filterParameter) {
        this.init();
        this.filterParameter = filterParameter;
        if (filterParameter != null) {
            if (CollectionUtils.isNotEmpty(filterParameter.getOrderBy())) {
                this.listOrderBy = filterParameter.getOrderBy();
            }
            if (filterParameter.getPageNumber() != null && filterParameter.getPageSize() != null) {
                this.pageable = PageRequest.of(filterParameter.getPageNumber(), filterParameter.getPageSize());
            }
        }
    }

    public QueryFilter(Map<String, Object> mapParameters) {
        this.init();
        this.mapParameters = mapParameters;
    }

    public QueryFilter() {
        this.init();
    }

    private void init() {
        this.nullables = new HashSet<String>();
        this.mapParameters = new HashMap<String, Object>();
        this.listOrderBy = new ArrayList<OrderBy>();
    }

    public ID getId() {
        return this.id;
    }

    public void setId(ID id) {
        this.id = id;
    }

    public Set<String> getNullables() {
        return this.nullables;
    }

    public Map<String, Object> getMapParameters() {
        return this.mapParameters;
    }

    public void addParameter(String key, Object value) {
        if (key != null && value != null) {
            this.mapParameters.put(key, value);
        }
    }

    public List<OrderBy> getListOrderBy() {
        return this.listOrderBy;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    public void setPageable(Integer page, Integer size) {
        if (page != null && size != null) {
            this.pageable = PageRequest.of(page, size);
        }
    }

    public Class<T> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<T> classFilter) {
        this.resultClass = classFilter;
    }

    public FilterParameter getFilterParameter() {
        return this.filterParameter;
    }

    public void setFilterParameter(FilterParameter parameterFilter) {
        this.filterParameter = parameterFilter;
    }
}

