/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.utils;

import bld.commons.reflection.annotations.DateFilter;
import bld.commons.reflection.annotations.FilterNullValue;
import bld.commons.reflection.annotations.IgnoreMapping;
import bld.commons.reflection.annotations.LikeString;
import bld.commons.reflection.annotations.ListFilter;
import bld.commons.reflection.model.FilterParameter;
import bld.commons.reflection.model.QueryFilter;
import bld.commons.reflection.type.GetSetType;
import bld.commons.reflection.utils.CamelCaseUtils;
import bld.commons.reflection.utils.DateUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.converters.CalendarConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ReflectionUtils {
    public static final String PK = "PK";
    @Autowired
    private ApplicationContext applicationContext;
    private static final Log logger = LogFactory.getLog(ReflectionUtils.class);
    public static final String SERVICE_IMPL = "ServiceImpl";
    public static final String UPDATE = "update";
    public static final String SAVE = "save";
    public static final Map<Class<?>, Class<?>> mapPrimitiveToObject = ReflectionUtils.mapFromPrimitiveToObject();

    public void saveGeneric(Object valore, Class<?> classCampoDestinatario) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String nomeClasse = classCampoDestinatario.getSimpleName();
        String nomeClasseServiceImpl = ReflectionUtils.getBeanName(nomeClasse, SERVICE_IMPL);
        Object oggettoServiceImpl = this.applicationContext.getBean(nomeClasseServiceImpl);
        Method metodo = oggettoServiceImpl.getClass().getMethod(SAVE, valore.getClass());
        metodo.invoke(oggettoServiceImpl, valore);
    }

    private static Map<Class<?>, Class<?>> mapFromPrimitiveToObject() {
        HashMap map = new HashMap();
        map.put(Integer.TYPE, Integer.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        map.put(Void.TYPE, Void.class);
        return map;
    }

    public <T, ID> QueryFilter<T, ID> dataToMap(QueryFilter<T, ID> queryFilter) {
        HashMap<String, Object> mapParameters = new HashMap<String, Object>();
        HashSet<String> checkNullable = new HashSet<String>();
        FilterParameter obj = queryFilter.getFilterParameter();
        if (obj != null) {
            Set<Field> fields = ReflectionUtils.getListField(obj.getClass());
            Map<String, LinkedHashSet<Method>> mapMethod = ReflectionUtils.getMapMethod(obj.getClass());
            for (Field field : fields) {
                IgnoreMapping ignoreMapping;
                Method method = ReflectionUtils.getMethod(mapMethod, field, GetSetType.get, new Class[0]);
                if (method == null) continue;
                IgnoreMapping ignoreMapping2 = ignoreMapping = method.isAnnotationPresent(IgnoreMapping.class) ? method.getAnnotation(IgnoreMapping.class) : field.getAnnotation(IgnoreMapping.class);
                if (ignoreMapping != null && ignoreMapping.value()) continue;
                try {
                    Object value = PropertyUtils.getProperty(obj, field.getName());
                    if (value instanceof Collection && CollectionUtils.isEmpty((Collection)value)) {
                        value = null;
                    }
                    if (value != null && value instanceof String && StringUtils.isBlank((String)value)) {
                        value = null;
                    }
                    if (value != null) {
                        LikeString likeString;
                        DateFilter dateFilter = method.isAnnotationPresent(DateFilter.class) ? method.getAnnotation(DateFilter.class) : field.getAnnotation(DateFilter.class);
                        LikeString likeString2 = likeString = method.isAnnotationPresent(LikeString.class) ? method.getAnnotation(LikeString.class) : field.getAnnotation(LikeString.class);
                        if (dateFilter != null) {
                            if (value instanceof Calendar) {
                                value = DateUtils.sumDate((Calendar)value, dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
                            } else if (value instanceof Date) {
                                value = DateUtils.sumDate((Date)value, dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
                            } else if (value instanceof Timestamp) {
                                value = DateUtils.sumDate((Timestamp)value, dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
                            }
                        } else if (value instanceof String && likeString != null) {
                            switch (likeString.likeType()) {
                                case LEFT: {
                                    value = "%" + value;
                                    break;
                                }
                                case LEFT_RIGHT: {
                                    value = "%" + value + "%";
                                    break;
                                }
                                case RIGHT: {
                                    value = value + "%";
                                    break;
                                }
                                case EQUAL: {
                                    break;
                                }
                                default: {
                                    value = "%" + value + "%";
                                }
                            }
                            switch (likeString.upperLowerType()) {
                                case LOWER: {
                                    value = ((String)value).toLowerCase();
                                    break;
                                }
                                case UPPER: {
                                    value = ((String)value).toUpperCase();
                                    break;
                                }
                            }
                        }
                        if (value instanceof Boolean && ((Boolean)value).booleanValue() && field.isAnnotationPresent(ListFilter.class)) {
                            checkNullable.add(field.getName());
                            continue;
                        }
                        if (value.getClass().isArray()) {
                            Object[] array = (Object[])value;
                            mapParameters.put(field.getName(), Arrays.asList(array));
                            continue;
                        }
                        mapParameters.put(field.getName(), value);
                        continue;
                    }
                    if ((!field.isAnnotationPresent(FilterNullValue.class) || !field.getAnnotation(FilterNullValue.class).value()) && (!method.isAnnotationPresent(FilterNullValue.class) || !method.getAnnotation(FilterNullValue.class).value())) continue;
                    mapParameters.put(field.getName(), null);
                }
                catch (Exception e) {
                    logger.warn("Errore durante la conversione dei dati in mappa");
                }
            }
            queryFilter.getMapParameters().putAll(mapParameters);
            queryFilter.getNullables().addAll(checkNullable);
        }
        return queryFilter;
    }

    public <T> void reflection(T t, Map<String, Object> mapResult) {
        HashMap<String, Object> mapResultApp = new HashMap<String, Object>();
        for (String keyResult : mapResult.keySet()) {
            String nameField = CamelCaseUtils.camelCase(keyResult, true);
            mapResultApp.put(nameField, mapResult.get(keyResult));
        }
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        DateTimeConverter converter = new DateConverter();
        beanUtilsBean.getConvertUtils().register(converter, Date.class);
        converter = new CalendarConverter(null);
        beanUtilsBean.getConvertUtils().register(converter, Calendar.class);
        try {
            beanUtilsBean.copyProperties(t, mapResultApp);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getBeanName(String nomeClasse, String rightConcat) {
        nomeClasse = Character.toLowerCase(nomeClasse.charAt(0)) + nomeClasse.substring(1);
        rightConcat = rightConcat != null ? rightConcat : "";
        return nomeClasse + rightConcat;
    }

    public static Object checkEmpty(Object obj) {
        HashSet<Field> campi = new HashSet<Field>(Arrays.asList(obj.getClass().getDeclaredFields()));
        for (Field f : campi) {
            try {
                Object value = PropertyUtils.getProperty(obj, f.getName());
                if (value == null) continue;
                return obj;
            }
            catch (Exception e) {
                logger.warn("-XXX- errore durante la lettura del campo -XXX");
                logger.warn(ExceptionUtils.getStackTrace(e));
            }
        }
        return null;
    }

    public static <T> Class<T> getGenericTypeClass(Object entity) {
        return ReflectionUtils.getGenericTypeClass(entity, 0);
    }

    public static <T> Class<T> getGenericTypeClass(Object entity, int i) {
        ParameterizedType parameterizedType = null;
        try {
            parameterizedType = (ParameterizedType)entity.getClass().getGenericSuperclass();
        }
        catch (Exception e) {
            parameterizedType = (ParameterizedType)entity.getClass().getSuperclass().getGenericSuperclass();
        }
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[i];
        return clazz;
    }

    public static <T> Class<T> getGenericTypeField(Field field) {
        return ReflectionUtils.getGenericTypeField(field, 0);
    }

    public static <T> Class<T> getGenericTypeField(Field field, int i) {
        ParameterizedType parameterizedType = null;
        parameterizedType = (ParameterizedType)field.getGenericType();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[i];
        return clazz;
    }

    public static String removeExtraSpace(String join) {
        if ((join = join.trim()).contains("  ")) {
            join = ReflectionUtils.removeExtraSpace(join.replace("  ", " "));
        }
        return join;
    }

    public static Set<Field> getListField(Class<?> classApp) {
        HashSet<Field> listField = new HashSet<Field>();
        do {
            for (Field field : classApp.getDeclaredFields()) {
                if (listField.contains(field)) continue;
                listField.add(field);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return listField;
    }

    public static Map<String, Field> getMapField(Class<?> classApp) {
        HashMap<String, Field> mapField = new HashMap<String, Field>();
        do {
            for (Field field : classApp.getDeclaredFields()) {
                if (mapField.containsKey(field.getName())) continue;
                mapField.put(field.getName(), field);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return mapField;
    }

    public static Map<String, LinkedHashSet<Method>> getMapMethod(Class<?> classApp) {
        HashMap<String, LinkedHashSet<Method>> mapMethod = new HashMap<String, LinkedHashSet<Method>>();
        do {
            for (Method method : classApp.getMethods()) {
                if (!mapMethod.containsKey(method.getName())) {
                    mapMethod.put(method.getName(), new LinkedHashSet());
                }
                ((LinkedHashSet)mapMethod.get(method.getName())).add(method);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return mapMethod;
    }

    public static Method getMethod(Map<String, LinkedHashSet<Method>> mapMethod, String methodName, Class<?> ... classParameter) {
        Set methods = mapMethod.get(methodName);
        if (CollectionUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                Object[] parameterTypes = method.getParameterTypes();
                if (ArrayUtils.isEmpty(parameterTypes) && ArrayUtils.isEmpty(classParameter)) {
                    return method;
                }
                boolean check = true;
                if (!ArrayUtils.isNotEmpty(parameterTypes) || !ArrayUtils.isNotEmpty(classParameter) || parameterTypes.length != classParameter.length) continue;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (((Class)parameterTypes[i]).isAssignableFrom(classParameter[i])) continue;
                    check = false;
                    break;
                }
                if (!check) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethod(Map<String, LinkedHashSet<Method>> mapMethod, Field field, GetSetType getSetType, Class<?> ... classParameter) {
        String methodName = getSetType.name() + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
        return ReflectionUtils.getMethod(mapMethod, methodName, classParameter);
    }
}

