/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.service;

import bld.commons.reflection.model.BuildQueryFilter;
import bld.commons.reflection.model.FilterParameter;
import bld.commons.reflection.model.OrderBy;
import bld.commons.reflection.model.QueryFilter;
import bld.commons.reflection.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseJpaService {
    private static final String fetch = "(?i)fetch";
    private static final Log logger = LogFactory.getLog(BaseJpaService.class);
    private static final String ORDER_BY = " order by ";
    public static final CharSequence ONE_TO_MANY = "<ONE_TO_MANY>";
    public static final String KEY_PROPERTY = "<PROPERTY>";
    public static final String WHERE_1_1 = " WHERE 1=1 ";
    public static final String WHERE = "<WHERE>";
    private Map<String, LinkedHashSet<String>> mapOneToMany;
    @Autowired
    protected ReflectionUtils reflectionUtils;

    protected abstract EntityManager getEntityManager();

    protected void setMapOneToMany(Map<String, LinkedHashSet<String>> mapOneToMany) {
        this.mapOneToMany = mapOneToMany;
    }

    protected Map<String, LinkedHashSet<String>> getMapOneToMany() {
        return this.mapOneToMany;
    }

    protected String getUnitName() {
        return null;
    }

    private String getWhereCondition(Map<String, Object> mapParameters, String select, Map<String, String> mapConditions, Class<? extends FilterParameter> classFilterParameter) {
        for (String key : mapParameters.keySet()) {
            String val2 = mapConditions.get(key);
            logger.debug("Key: " + key + " Parameter: " + val2);
            select = select + val2;
        }
        return select;
    }

    private <T extends Query> T setQueryParameters(Map<String, Object> mapParameters, T query2) {
        for (String key : mapParameters.keySet()) {
            Object value = mapParameters.get(key);
            logger.debug("----------------------------------------------------------");
            logger.debug("Key: " + key);
            logger.debug("Value: " + value);
            logger.debug("Class: " + value.getClass().getName());
            query2.setParameter(key, mapParameters.get(key));
        }
        return query2;
    }

    private String getWhereCondition(Set<String> nullables, String select, Map<String, String> mapConditions) {
        if (nullables != null) {
            for (String key : nullables) {
                logger.debug("String check nullable: " + key);
                select = select + mapConditions.get(key);
            }
        }
        return select;
    }

    public <T, ID> void deleteByFilter(BuildQueryFilter<T, ID> buildQueryFilter) {
        QueryFilter<T, ID> queryFilter = buildQueryFilter.getQueryFilter();
        String delete = this.buildSql(buildQueryFilter);
        logger.debug("Query= " + delete);
        TypedQuery query2 = (TypedQuery)this.getEntityManager().createQuery(delete);
        query2 = this.setQueryParameters(queryFilter.getMapParameters(), query2);
        query2.executeUpdate();
    }

    public <T, ID> List<T> findByFilter(BuildQueryFilter<T, ID> buildQueryFilter) {
        TypedQuery<T> query2 = this.buildQuery(buildQueryFilter);
        return query2.getResultList();
    }

    private <T, ID> TypedQuery<T> buildQuery(BuildQueryFilter<T, ID> buildQueryFilter) {
        QueryFilter<T, ID> queryFilter = buildQueryFilter.getQueryFilter();
        Map<String, Object> mapParameters = queryFilter.getMapParameters();
        String select = this.buildSql(buildQueryFilter);
        ManageOneToMany manageOneToMany = this.addRelationshipsOneToMany(mapParameters, select, queryFilter.getNullables());
        select = manageOneToMany.getSelect();
        select = this.addOrderBy(queryFilter.getListOrderBy(), select);
        logger.info("\nQuery: \n" + select);
        TypedQuery<T> query2 = this.getEntityManager().createQuery(select, queryFilter.getResultClass());
        query2 = this.setQueryParameters(mapParameters, query2);
        if (manageOneToMany.isOneToMany()) {
            query2.setHint("hibernate.query.passDistinctThrough", false);
        }
        if (queryFilter.getPageable() != null) {
            query2.setFirstResult(queryFilter.getPageable().getPageNumber() * queryFilter.getPageable().getPageSize());
            query2.setMaxResults(queryFilter.getPageable().getPageSize());
        }
        return query2;
    }

    private <T, ID> Class<? extends FilterParameter> getClassFilterParameter(QueryFilter<T, ID> queryFilter) {
        Class<?> classFilterParameter = null;
        if (queryFilter.getFilterParameter() != null) {
            classFilterParameter = queryFilter.getFilterParameter().getClass();
        }
        return classFilterParameter;
    }

    private <T, ID> String buildSql(BuildQueryFilter<T, ID> buildQueryFilter) {
        QueryFilter<T, ID> queryFilter = buildQueryFilter.getQueryFilter();
        String select = this.getWhereCondition(queryFilter.getNullables(), buildQueryFilter.getSql(), buildQueryFilter.getMapConditions());
        select = this.getWhereCondition(queryFilter.getMapParameters(), select, buildQueryFilter.getMapConditions(), this.getClassFilterParameter(queryFilter));
        return select;
    }

    private String addOrderBy(List<OrderBy> listOrderBy, String select) {
        String writeOrderBy = "";
        if (CollectionUtils.isNotEmpty(listOrderBy)) {
            for (OrderBy orderBy : listOrderBy) {
                writeOrderBy = writeOrderBy + "," + orderBy.getSortKey() + " " + orderBy.getOrderType().name();
            }
            writeOrderBy = ORDER_BY + writeOrderBy.substring(1);
        }
        if (!select.toLowerCase().contains(ORDER_BY.trim())) {
            select = select + writeOrderBy;
        }
        return select;
    }

    private ManageOneToMany addRelationshipsOneToMany(Map<String, Object> mapParameters, String select, Set<String> nullables) {
        String innerJoin = " ";
        HashSet<String> listJoin = new HashSet<String>();
        for (String key : this.mapOneToMany.keySet()) {
            if (!mapParameters.containsKey(key) && (nullables == null || !nullables.contains(key))) continue;
            Set joins = this.mapOneToMany.get(key);
            for (String join : joins) {
                if (listJoin.contains(join = ReflectionUtils.removeExtraSpace(join))) continue;
                listJoin.add(join);
                innerJoin = innerJoin + " " + join + " ";
            }
        }
        select = select.replace(ONE_TO_MANY, innerJoin);
        ManageOneToMany manageOneToMany = new ManageOneToMany(select, listJoin.size() > 0);
        return manageOneToMany;
    }

    public <T, ID> Long countByFilter(BuildQueryFilter<T, ID> buildQueryFilter) {
        QueryFilter<T, ID> queryFilter = buildQueryFilter.getQueryFilter();
        String count = buildQueryFilter.getSql();
        ManageOneToMany manageOneToMany = this.addRelationshipsOneToMany(queryFilter.getMapParameters(), count, queryFilter.getNullables());
        count = manageOneToMany.getSelect();
        buildQueryFilter.setSql(count);
        count = this.buildSql(buildQueryFilter).replaceAll(fetch, "");
        TypedQuery<Long> query2 = this.getEntityManager().createQuery(count, Long.class);
        query2 = this.setQueryParameters(queryFilter.getMapParameters(), query2);
        return (Long)query2.getSingleResult();
    }

    public <T, ID> T findSingleResultByFilter(BuildQueryFilter<T, ID> buildQueryFilter) {
        TypedQuery<T> query2 = this.buildQuery(buildQueryFilter);
        T t = null;
        try {
            t = query2.getSingleResult();
        }
        catch (Exception e) {
            logger.info("Record not found");
        }
        return t;
    }

    public <T, ID> T findById(BuildQueryFilter<T, ID> buildQueryFilter) {
        QueryFilter<T, ID> queryFilter = buildQueryFilter.getQueryFilter();
        queryFilter.getMapParameters().put("id", queryFilter.getId());
        return this.findSingleResultByFilter(buildQueryFilter);
    }

    public <T, ID> List<T> nativeQuerySelectByFilter(BuildQueryFilter<T, ID> buildQueryFilter) {
        String sql = this.buildNativeQuery(buildQueryFilter);
        sql = this.addOrderBy(buildQueryFilter.getQueryFilter().getListOrderBy(), sql);
        Query query2 = this.getEntityManager().createNativeQuery(sql, Tuple.class);
        query2 = this.setQueryParameters(buildQueryFilter.getQueryFilter().getMapParameters(), query2);
        if (buildQueryFilter.getQueryFilter().getPageable() != null) {
            query2.setFirstResult(buildQueryFilter.getQueryFilter().getPageable().getPageNumber() * buildQueryFilter.getQueryFilter().getPageable().getPageSize());
            query2.setMaxResults(buildQueryFilter.getQueryFilter().getPageable().getPageSize());
        }
        List results = query2.getResultList();
        ArrayList<Object> listT = new ArrayList<Object>();
        for (Tuple row : results) {
            List<TupleElement<?>> elements = row.getElements();
            Object t = null;
            try {
                t = buildQueryFilter.getQueryFilter().getResultClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> mapRow = new HashMap<String, Object>();
            for (TupleElement<?> element : elements) {
                Object value = row.get(element.getAlias());
                if (value == null) continue;
                mapRow.put(element.getAlias(), value);
            }
            this.reflectionUtils.reflection(t, mapRow);
            listT.add(t);
        }
        return listT;
    }

    public <T, ID> Long nativeQueryCountByFilter(BuildQueryFilter<T, ID> buildQueryFilter) {
        String sql = this.buildNativeQuery(buildQueryFilter);
        sql = this.addOrderBy(buildQueryFilter.getQueryFilter().getListOrderBy(), sql);
        Query query2 = this.getEntityManager().createNativeQuery(sql, Long.class);
        query2 = this.setQueryParameters(buildQueryFilter.getQueryFilter().getMapParameters(), query2);
        Long count = (Long)query2.getSingleResult();
        return count;
    }

    private <T, ID> String buildNativeQuery(BuildQueryFilter<T, ID> buildQueryFilter) {
        String where = WHERE_1_1;
        String sql = buildQueryFilter.getSql();
        for (String key : buildQueryFilter.getQueryFilter().getMapParameters().keySet()) {
            if (!buildQueryFilter.getMapConditions().containsKey(key)) continue;
            where = where + buildQueryFilter.getMapConditions().get(key);
        }
        for (String nullable : buildQueryFilter.getQueryFilter().getNullables()) {
            if (!buildQueryFilter.getMapConditions().containsKey(nullable)) continue;
            where = where + buildQueryFilter.getMapConditions().get(nullable);
        }
        sql = sql.replace("(?i)<WHERE>", where);
        return sql;
    }

    private class ManageOneToMany {
        private String select;
        private boolean oneToMany;

        public ManageOneToMany(String select, boolean oneToMany) {
            this.select = select;
            this.oneToMany = oneToMany;
        }

        public String getSelect() {
            return this.select;
        }

        public boolean isOneToMany() {
            return this.oneToMany;
        }
    }
}

