/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.service;

import bld.commons.exception.PropertiesException;
import bld.commons.reflection.model.BuildQueryFilter;
import bld.commons.reflection.model.QueryFilter;
import bld.commons.reflection.utils.ReflectionUtils;
import bld.commons.service.BaseJpaService;
import bld.commons.service.JpaService;
import bld.commons.service.QueryJpql;
import bld.commons.utils.PersistenceMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Id;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;

public abstract class JpaServiceImpl<T, ID>
extends BaseJpaService
implements JpaService<T, ID> {
    private static final String POINT = "\\.";
    private Class<T> clazz = ReflectionUtils.getGenericTypeClass(this);
    private Field id = null;
    @Autowired
    protected ReflectionUtils reflectionUtils;
    @Autowired
    protected QueryJpql<T> queryJpl;

    protected Class<T> getClazz() {
        return this.clazz;
    }

    protected Field getId() {
        return this.id;
    }

    public JpaServiceImpl() {
        Set<Field> fields = ReflectionUtils.getListField(this.clazz);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            this.id = field;
            break;
        }
    }

    protected abstract JpaRepository<T, ID> getJpaRepository();

    private BuildQueryFilter<T, ID> configureQueryFilter(Map<String, String> mapConditions, QueryFilter<T, ID> queryFilter, String query2) {
        if (MapUtils.isEmpty(this.getMapOneToMany())) {
            this.setMapOneToMany();
        }
        if (queryFilter.getFilterParameter() != null) {
            queryFilter = this.reflectionUtils.dataToMap(queryFilter);
        }
        queryFilter.setResultClass(this.clazz);
        return new BuildQueryFilter<T, ID>(mapConditions, queryFilter, query2);
    }

    private void setMapOneToMany() {
        super.setMapOneToMany(this.queryJpl.getMapOneToMany());
    }

    private String selectByFilter() {
        return this.queryJpl.selectByFilter();
    }

    private String countByFilter() {
        return this.queryJpl.countByFilter();
    }

    private String deleteByFilter() {
        return this.queryJpl.deleteByFilter();
    }

    @Override
    public long count() {
        return this.getJpaRepository().count();
    }

    @Override
    public void delete(T entity) {
        this.getJpaRepository().delete(entity);
    }

    @Override
    public T findById(ID id) {
        return this.getJpaRepository().findById(id).orElse(null);
    }

    @Override
    public List<T> findAll() {
        return this.getJpaRepository().findAll();
    }

    @Override
    public void save(T entity) {
        this.getJpaRepository().save(entity);
    }

    @Override
    public T update(T entity) {
        return this.getJpaRepository().save(entity);
    }

    @Override
    public void saveAndFlush(T entity) {
        this.getJpaRepository().saveAndFlush(entity);
    }

    @Override
    public T updateAndFlush(T entity) {
        this.getJpaRepository().save(entity);
        this.getJpaRepository().flush();
        return entity;
    }

    @Override
    public void deleteAndFlush(T entity) {
        this.getJpaRepository().delete(entity);
        this.getJpaRepository().flush();
    }

    @Override
    public void saveAll(Collection<T> listT) {
        if (!CollectionUtils.isEmpty(listT)) {
            this.getJpaRepository().saveAll(listT);
        }
    }

    @Override
    public void flush() {
        this.getJpaRepository().flush();
    }

    @Override
    public void deleteById(ID id) {
        this.getJpaRepository().deleteById(id);
    }

    protected void addJoinOneToMany(String key, String ... join) {
        if (!this.getMapOneToMany().containsKey(key)) {
            this.getMapOneToMany().put(key, new LinkedHashSet());
        }
        this.getMapOneToMany().get(key).addAll(Arrays.asList(join));
    }

    @Override
    public List<T> findByFilter(QueryFilter<T, ID> queryFilter) {
        return this.findByFilter(queryFilter, this.selectByFilter());
    }

    @Override
    public T findSingleResultByFilter(QueryFilter<T, ID> queryFilter) {
        return this.findSingleResultByFilter(queryFilter, this.selectByFilter());
    }

    @Override
    public T findSingleResultByFilter(QueryFilter<T, ID> queryFilter, String select) {
        BuildQueryFilter<T, ID> buildQueryFilter = this.configureQueryFilter(this.queryJpl.mapConditions(), queryFilter, select);
        return super.findSingleResultByFilter(buildQueryFilter);
    }

    @Override
    public Long countByFilter(QueryFilter<T, ID> queryFilter) {
        return this.countByFilter(queryFilter, this.countByFilter());
    }

    @Override
    public List<T> findByFilter(QueryFilter<T, ID> queryFilter, String select) {
        BuildQueryFilter<T, ID> buildQueryFilter = this.configureQueryFilter(this.queryJpl.mapConditions(), queryFilter, select);
        return super.findByFilter(buildQueryFilter);
    }

    @Override
    public Long countByFilter(QueryFilter<T, ID> queryFilter, String count) {
        BuildQueryFilter<T, ID> buildQueryFilter = this.configureQueryFilter(this.queryJpl.mapConditions(), queryFilter, count);
        return super.countByFilter(buildQueryFilter);
    }

    @Override
    public void deleteByFilter(QueryFilter<T, ID> queryFilter) {
        BuildQueryFilter<T, ID> buildQueryFilter = this.configureQueryFilter(this.queryJpl.mapDeleteConditions(), queryFilter, this.deleteByFilter());
        super.deleteByFilter(buildQueryFilter);
    }

    @Override
    public Map<ID, T> mapFindByFilter(QueryFilter<T, ID> queryFilter) {
        List<T> list = this.findByFilter(queryFilter);
        return this.mapIdEntity(list);
    }

    private Map<ID, T> mapIdEntity(List<T> list) {
        HashMap<Object, T> map = new HashMap<Object, T>();
        for (T t : list) {
            try {
                map.put(PropertyUtils.getProperty(t, this.id.getName()), t);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new PropertiesException(e);
            }
        }
        return map;
    }

    @Override
    public Map<ID, T> mapFindByFilter(QueryFilter<T, ID> queryFilter, String sql) {
        List<T> list = this.findByFilter(queryFilter, sql);
        return this.mapIdEntity(list);
    }

    private Object getKey(String[] fields, T t) {
        Object value = t;
        for (String field : fields) {
            try {
                value = PropertyUtils.getProperty(value, field);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new PropertiesException(e);
            }
        }
        return value;
    }

    private <J> PersistenceMap<J, T> mapKeyEntity(List<T> list, Class<J> classKey, String key) {
        PersistenceMap<Object, T> map = new PersistenceMap<Object, T>();
        String[] fields = key.split(POINT);
        for (T t : list) {
            map.put(this.getKey(fields, t), t);
        }
        return map;
    }

    @Override
    public <J> PersistenceMap<J, T> mapKeyFindByFilter(QueryFilter<T, ID> queryFilter, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryFilter);
        return this.mapKeyEntity(list, classKey, key);
    }

    @Override
    public <J> PersistenceMap<J, T> mapKeyFindByFilter(QueryFilter<T, ID> queryFilter, String sql, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryFilter, sql);
        return this.mapKeyEntity(list, classKey, key);
    }

    private <J> PersistenceMap<J, List<T>> mapKeyListEntity(List<T> list, Class<J> classKey, String keyFields) {
        PersistenceMap map = new PersistenceMap();
        String[] fields = keyFields.split(POINT);
        for (T t : list) {
            Object key = this.getKey(fields, t);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(this.getKey(fields, t))).add(t);
        }
        return map;
    }

    @Override
    public <J> PersistenceMap<J, List<T>> mapKeyListFindByFilter(QueryFilter<T, ID> queryFilter, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryFilter);
        return this.mapKeyListEntity(list, classKey, key);
    }

    @Override
    public <J> PersistenceMap<J, List<T>> mapKeyListFindByFilter(QueryFilter<T, ID> queryFilter, String sql, Class<J> classKey, String key) {
        List<T> list = this.findByFilter(queryFilter, sql);
        return this.mapKeyListEntity(list, classKey, key);
    }

    @Override
    public <K> List<K> nativeQuerySelectByFilter(QueryFilter<K, ID> queryFilter, String sql) {
        BuildQueryFilter<K, ID> buildQueryFilter = this.getBuildNativeQueryFilter(queryFilter, sql);
        return super.nativeQuerySelectByFilter(buildQueryFilter);
    }

    @Override
    public <K> Long nativeQueryCountByFilter(QueryFilter<K, ID> queryFilter, String count) {
        BuildQueryFilter<K, ID> buildQueryFilter = this.getBuildNativeQueryFilter(queryFilter, count);
        return this.nativeQueryCountByFilter(buildQueryFilter);
    }

    private <K> BuildQueryFilter<K, ID> getBuildNativeQueryFilter(QueryFilter<K, ID> queryFilter, String sql) {
        BuildQueryFilter<K, ID> buildQueryFilter = new BuildQueryFilter<K, ID>();
        if (queryFilter.getFilterParameter() != null) {
            queryFilter = this.reflectionUtils.dataToMap(queryFilter);
        }
        buildQueryFilter.setQueryFilter(queryFilter);
        buildQueryFilter.setSql(sql);
        buildQueryFilter.setMapConditions(this.queryJpl.mapNativeConditions());
        return buildQueryFilter;
    }
}

