/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.workspace;

import bld.commons.annotations.WorkspaceClasses;
import bld.commons.reflection.model.BaseModel;
import bld.commons.reflection.model.CollectionResponse;
import bld.commons.reflection.model.ObjectResponse;
import bld.commons.reflection.model.QueryFilter;
import bld.commons.service.JpaService;
import bld.commons.workspace.WorkModel;
import bld.commons.workspace.mapper.MapperModel;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class WorkModelImpl
implements WorkModel {
    @Autowired
    private ApplicationContext context;

    @Override
    public <T, ID, M extends BaseModel<ID>> CollectionResponse<M> findByFilter(QueryFilter<T, ID> queryFilter) throws Exception {
        CollectionResponse response = new CollectionResponse();
        if (!queryFilter.getFilterParameter().getClass().isAnnotationPresent(WorkspaceClasses.class)) {
            throw new Exception("The \"WorkspaceClasses\" annotation is missing in \"FilterParameter\" class");
        }
        WorkspaceClasses workspaceClasses = queryFilter.getFilterParameter().getClass().getAnnotation(WorkspaceClasses.class);
        JpaService<?, ?> service = this.context.getBean(workspaceClasses.service());
        List<?> list = service.findByFilter(queryFilter);
        Long totalCount = service.countByFilter(queryFilter);
        MapperModel<?, ?> mapperModel = this.context.getBean(workspaceClasses.mapper());
        ArrayList listModel = new ArrayList();
        for (Object entity : list) {
            Object model = mapperModel.convertToModel(entity);
            listModel.add(model);
        }
        response.setData(listModel);
        response.setTotalCount(totalCount != null ? totalCount : Long.valueOf(0L));
        if (queryFilter.getPageable() != null) {
            response.setPageNumber(queryFilter.getPageable().getPageNumber());
            response.setPageSize(queryFilter.getPageable().getPageSize());
        }
        return response;
    }

    @Override
    public <T, ID> ObjectResponse<Long> countByFilter(QueryFilter<T, ID> queryFilter) {
        WorkspaceClasses workspaceClasses = queryFilter.getFilterParameter().getClass().getAnnotation(WorkspaceClasses.class);
        JpaService<?, ?> service = this.context.getBean(workspaceClasses.service());
        Long totalCount = service.countByFilter(queryFilter);
        return new ObjectResponse<Long>(totalCount);
    }

    @Override
    public <T, ID, M extends BaseModel<ID>> ObjectResponse<M> findSingleResultByFilter(QueryFilter<T, ID> queryFilter) throws Exception {
        ObjectResponse response = new ObjectResponse();
        if (!queryFilter.getFilterParameter().getClass().isAnnotationPresent(WorkspaceClasses.class)) {
            throw new Exception("The \"WorkspaceClasses\" annotation is missing in \"FilterParameter\" class");
        }
        WorkspaceClasses workspaceClasses = queryFilter.getFilterParameter().getClass().getAnnotation(WorkspaceClasses.class);
        JpaService<?, ?> service = this.context.getBean(workspaceClasses.service());
        Object entity = service.findSingleResultByFilter(queryFilter);
        MapperModel<?, ?> mapperModel = this.context.getBean(workspaceClasses.mapper());
        response.setData(mapperModel.convertToModel(entity));
        return response;
    }
}

