/*
 * Decompiled with CFR 0.152.
 */
package bld.plugin.jpa.service.generator;

import bld.commons.classes.generator.config.ConfigurationClassGenerator;
import bld.commons.classes.generator.impl.ClassesGeneratorImpl;
import bld.commons.classes.generator.utils.ClassGeneratorUtils;
import bld.commons.classes.model.ModelClasses;
import bld.commons.classes.type.OutputDirectoryType;
import bld.plugin.jpa.service.generator.classes.ClassBuilding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javax.persistence.Entity;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="jpa-service-generator", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class ServiceJpaGeneratorPlugin
extends AbstractMojo {
    private static final String TARGET_GENERATED_SOURCES_CLASSES = "/target/generated-sources/classes";
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private String persistencePackage;
    @Parameter(defaultValue="src_main_java")
    private OutputDirectoryType outputDirectory;
    @Parameter(required=true)
    private String servicePackage;
    @Parameter(required=false)
    private String repositoryPackage;
    @Parameter(defaultValue="/template")
    private String resourceTemplateDirectory;
    @Parameter
    private List<String> buildPackages;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String outputDirectory = this.project.getBasedir() + "/" + this.outputDirectory.getValue();
            String classesDirectory = this.project.getBuild().getOutputDirectory();
            this.project.addCompileSourceRoot(new File(this.project.getBasedir() + TARGET_GENERATED_SOURCES_CLASSES).getAbsolutePath());
            String slash = "/";
            String shell = "bash";
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                slash = "\\";
                shell = "cmd.exe";
            }
            if (!this.persistencePackage.endsWith(".")) {
                this.persistencePackage = this.persistencePackage + ".";
            }
            ModelClasses modelClasses = new ModelClasses();
            File dir = new File(classesDirectory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String importJar = "";
            for (Artifact artifact : this.project.getArtifacts()) {
                importJar = importJar + ":" + artifact.getFile().getPath();
            }
            String packages = (String)this.project.getCompileSourceRoots().get(0) + slash + this.persistencePackage.replace(".", slash) + "*.java";
            String target = this.project.getBuild().getOutputDirectory() + "/";
            if (CollectionUtils.isNotEmpty(this.buildPackages)) {
                for (String buildPackage : this.buildPackages) {
                    packages = packages + " " + (String)this.project.getCompileSourceRoots().get(0) + slash + buildPackage.replace(".", slash) + "/*.java";
                }
            }
            String command = "javac -cp ." + importJar + " -d " + classesDirectory + " " + packages;
            this.getLog().debug((CharSequence)command);
            ProcessBuilder processBuilder = new ProcessBuilder(shell, "-c", command);
            processBuilder.redirectOutput(new File(this.project.getBuild().getOutputDirectory() + "/out.log"));
            File errorFile = new File(this.project.getBuild().getOutputDirectory() + "/out-error.log");
            processBuilder.redirectError(errorFile);
            processBuilder.start().waitFor();
            this.readLog(errorFile);
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            URL[] urls = new URL[runtimeClasspathElements.size()];
            for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
                urls[i] = new File((String)runtimeClasspathElements.get(i)).toURI().toURL();
            }
            URLClassLoader urlClassLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            List<File> files = ClassGeneratorUtils.getFiles(classesDirectory + slash + this.persistencePackage.replace(".", slash), "class");
            for (File file : files) {
                String nameClass = file.getPath().replace(target, "").replace("/", ".").replace(".class", "");
                Class<?> entityClass = urlClassLoader.loadClass(nameClass);
                try {
                    if (!entityClass.isAnnotationPresent(Entity.class)) continue;
                    ClassBuilding.generateClass(modelClasses, entityClass, classesDirectory, this.servicePackage, this.repositoryPackage);
                }
                catch (ArrayStoreException e) {
                    this.getLog().error((CharSequence)("TypeNotPresentExceptionProxy to: " + entityClass.getName()));
                }
            }
            this.getLog().debug((CharSequence)("Entities size: " + modelClasses.getClasses().size()));
            ClassesGeneratorImpl generatorClass = new ClassesGeneratorImpl(ConfigurationClassGenerator.configClassGenerator(this.resourceTemplateDirectory));
            generatorClass.writeClass(modelClasses, outputDirectory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readLog(File file) {
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            while ((strLine = br.readLine()) != null) {
                System.out.println(strLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

