/*
 * Decompiled with CFR 0.152.
 */
package bld.plugin.jpa.service.generator.classes;

import bld.commons.classes.attributes.ClassType;
import bld.commons.classes.attributes.LevelType;
import bld.commons.classes.model.ModelAnnotation;
import bld.commons.classes.model.ModelClass;
import bld.commons.classes.model.ModelClasses;
import bld.commons.classes.model.ModelField;
import bld.commons.classes.model.ModelGenericType;
import bld.commons.classes.model.ModelMethod;
import bld.commons.classes.model.ModelSuperClass;
import bld.commons.reflection.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Set;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassBuilding {
    private static final String BASE_JPA_REPOSITORY = "BaseJpaRepository";
    private static final String QUERY_BUILDER = "QueryBuilder";
    private static final String SPACE = "        ";
    private static final String OVERRIDE = "Override";
    private static final ModelAnnotation ANNOTATION_QUERY_BUILDER = ClassBuilding.getModelAnnotation("QueryBuilder");
    private static final String AUTOWIRED = "Autowired";
    private static final String TRANSACTIONAL = "Transactional";
    private static final String ENTITY_MANAGER = "EntityManager";
    private static final Log logger = LogFactory.getLog(ClassBuilding.class);
    private static final String SERVICE = "Service";
    private static final String REPOSITORY = "Repository";
    private static final String SERVICE_IMPL = "ServiceImpl";
    private static final ModelAnnotation ANNOTATION_REPOSITORY = ClassBuilding.getModelAnnotation("Repository");
    private static final ModelAnnotation ANNOTATION_SERVICE = ClassBuilding.getModelAnnotation("Service");
    private static final ModelAnnotation ANNOTATION_TRANSACTIONAL = ClassBuilding.getModelAnnotation("Transactional");
    private static final ModelAnnotation ANNOTATION_AUTOWIRED = ClassBuilding.getModelAnnotation("Autowired");
    private static final ModelAnnotation ANNOTATION_OVERRIDE = new ModelAnnotation("Override");
    private static final ModelField ENTITY_MANAGER_FIELD = ClassBuilding.getEntityManagerField();
    private static final ModelMethod ENTITY_MANAGER_METHOD = ClassBuilding.returnMethodService("getEntityManager", "EntityManager", "        return this." + ENTITY_MANAGER_FIELD.getName() + ";");

    public static void generateClass(ModelClasses modelClasses, Class<?> classEntity, String path, String servicePackage, String repositoryPackage) throws Exception {
        ModelClass interfaceRepository = new ModelClass();
        ModelClass interfaceService = new ModelClass();
        ModelClass classService = new ModelClass();
        String className = classEntity.getSimpleName();
        if (StringUtils.isEmpty(repositoryPackage)) {
            repositoryPackage = classEntity.getName().replace("." + className, "");
        }
        logger.info("Class building: " + classEntity.getName() + REPOSITORY);
        logger.info("Class building: " + servicePackage + "." + className + SERVICE);
        logger.info("Class building: " + servicePackage + "." + className + SERVICE_IMPL);
        interfaceRepository.getImports().add(classEntity.getName());
        interfaceService.getImports().add(classEntity.getName());
        classService.getImports().add(classEntity.getName());
        classService.getImports().add(repositoryPackage + "." + className + REPOSITORY);
        interfaceRepository.setName(className + REPOSITORY);
        interfaceRepository.setPackageName(repositoryPackage);
        interfaceRepository.setType(ClassType.INTERFACE);
        interfaceRepository.getAnnotations().add(ANNOTATION_REPOSITORY);
        ModelGenericType genericTypeEntityClass = new ModelGenericType();
        genericTypeEntityClass.setName(className);
        Set<Field> listField = ReflectionUtils.getListField(classEntity);
        ModelGenericType genericTypeId = new ModelGenericType();
        for (Field field : listField) {
            if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(EmbeddedId.class)) continue;
            Class<?> classType = field.getType();
            if (ReflectionUtils.mapPrimitiveToObject.containsKey(classType)) {
                classType = ReflectionUtils.mapPrimitiveToObject.get(classType);
            }
            genericTypeId.setName(classType.getSimpleName());
            if (classType.getName().startsWith("java.lang")) continue;
            interfaceRepository.getImports().add(classType.getName());
            interfaceService.getImports().add(classType.getName());
            classService.getImports().add(classType.getName());
        }
        ModelSuperClass superClassBaseJpaRepository = ClassBuilding.getPersistenceGenericType(genericTypeEntityClass, genericTypeId, BASE_JPA_REPOSITORY);
        interfaceRepository.getExtendsClass().add(superClassBaseJpaRepository);
        modelClasses.getClasses().add(interfaceRepository);
        interfaceService.setName(className + SERVICE);
        interfaceService.setType(ClassType.INTERFACE);
        interfaceService.setPackageName(servicePackage);
        ModelSuperClass superClassJpaService = ClassBuilding.getPersistenceGenericType(genericTypeEntityClass, genericTypeId, "JpaService");
        interfaceService.getExtendsClass().add(superClassJpaService);
        modelClasses.getClasses().add(interfaceService);
        ModelSuperClass interfaceServiceSuperClass = new ModelSuperClass();
        interfaceServiceSuperClass.setName(interfaceService.getName());
        classService.getImplementsClass().add(interfaceServiceSuperClass);
        classService.getExtendsClass().add(ClassBuilding.getPersistenceGenericType(genericTypeEntityClass, genericTypeId, "JpaServiceImpl"));
        classService.setName(className + SERVICE_IMPL);
        classService.setPackageName(servicePackage);
        classService.getAnnotations().add(ANNOTATION_SERVICE);
        classService.getAnnotations().add(ANNOTATION_TRANSACTIONAL);
        classService.getAnnotations().add(ANNOTATION_QUERY_BUILDER);
        ModelField repositoryField = new ModelField();
        String typeRepoField = className + REPOSITORY;
        String repoField = Character.toLowerCase(typeRepoField.charAt(0)) + typeRepoField.substring(1);
        repositoryField.setType(typeRepoField);
        repositoryField.setName(repoField);
        repositoryField.setGetterSetter(false);
        repositoryField.getAnnotations().add(ANNOTATION_AUTOWIRED);
        classService.getFields().add(repositoryField);
        classService.getFields().add(ENTITY_MANAGER_FIELD);
        ModelMethod jpaRepositoryMethod = new ModelMethod();
        jpaRepositoryMethod.setName("getJpaRepository");
        jpaRepositoryMethod.setLevelType(LevelType.PROTECTED);
        jpaRepositoryMethod.getAnnotations().add(ANNOTATION_OVERRIDE);
        jpaRepositoryMethod.setType("JpaRepository");
        jpaRepositoryMethod.getGenericTypes().add(genericTypeEntityClass);
        jpaRepositoryMethod.getGenericTypes().add(genericTypeId);
        jpaRepositoryMethod.getCommands().add("        return this." + repoField + ";");
        classService.getMethods().add(jpaRepositoryMethod);
        classService.getMethods().add(ENTITY_MANAGER_METHOD);
        modelClasses.getClasses().add(classService);
    }

    private static ModelSuperClass getPersistenceGenericType(ModelGenericType genericTypeEntityClass, ModelGenericType genericTypeId, String name) {
        ModelSuperClass modelSuperClass = new ModelSuperClass();
        modelSuperClass.setName(name);
        modelSuperClass.getGenericTypes().add(genericTypeEntityClass);
        modelSuperClass.getGenericTypes().add(genericTypeId);
        return modelSuperClass;
    }

    private static ModelAnnotation getModelAnnotation(String annotationName) {
        ModelAnnotation modelAnnotation = new ModelAnnotation();
        modelAnnotation.setName(annotationName);
        return modelAnnotation;
    }

    private static ModelField getEntityManagerField() {
        ModelField entityManagerField = new ModelField();
        entityManagerField.setGetterSetter(false);
        entityManagerField.setType(ENTITY_MANAGER);
        entityManagerField.setName(Character.toLowerCase(ENTITY_MANAGER.charAt(0)) + ENTITY_MANAGER.substring(1));
        ModelAnnotation persistenceContextAnnotation = new ModelAnnotation();
        persistenceContextAnnotation.setName("PersistenceContext");
        entityManagerField.getAnnotations().add(persistenceContextAnnotation);
        return entityManagerField;
    }

    private static ModelMethod returnMethodService(String name, String type, String command) {
        ModelMethod modelMethod = new ModelMethod(name, type);
        modelMethod.getAnnotations().add(ANNOTATION_OVERRIDE);
        modelMethod.setLevelType(LevelType.PROTECTED);
        modelMethod.getCommands().add(command);
        return modelMethod;
    }
}

