/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.session.JdbcSessionProperties;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.jdbc.init.PlatformPlaceholderDatabaseDriverResolver;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;

public class JdbcSessionDataSourceScriptDatabaseInitializer
extends DataSourceScriptDatabaseInitializer {
    public JdbcSessionDataSourceScriptDatabaseInitializer(DataSource dataSource, JdbcSessionProperties properties) {
        this(dataSource, JdbcSessionDataSourceScriptDatabaseInitializer.getSettings(dataSource, properties));
    }

    public JdbcSessionDataSourceScriptDatabaseInitializer(DataSource dataSource, DatabaseInitializationSettings settings) {
        super(dataSource, settings);
    }

    static DatabaseInitializationSettings getSettings(DataSource dataSource, JdbcSessionProperties properties) {
        DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
        PlatformPlaceholderDatabaseDriverResolver platformResolver = new PlatformPlaceholderDatabaseDriverResolver();
        settings.setSchemaLocations(platformResolver.resolveAll(dataSource, properties.getSchema()));
        settings.setMode(properties.getInitializeSchema());
        settings.setContinueOnError(true);
        return settings;
    }
}

