/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.convert.threeten;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.lang.Nullable;

public class Jsr310JpaConverters {

    @Converter(autoApply=true)
    public static class ZoneIdConverter
    implements AttributeConverter<ZoneId, String> {
        @Override
        @Nullable
        public String convertToDatabaseColumn(ZoneId zoneId) {
            return zoneId == null ? null : Jsr310Converters.ZoneIdToStringConverter.INSTANCE.convert(zoneId);
        }

        @Override
        @Nullable
        public ZoneId convertToEntityAttribute(String zoneId) {
            return zoneId == null ? null : Jsr310Converters.StringToZoneIdConverter.INSTANCE.convert(zoneId);
        }
    }

    @Converter(autoApply=true)
    public static class InstantConverter
    implements AttributeConverter<Instant, Date> {
        @Override
        @Nullable
        public Date convertToDatabaseColumn(Instant instant) {
            return instant == null ? null : Jsr310Converters.InstantToDateConverter.INSTANCE.convert(instant);
        }

        @Override
        @Nullable
        public Instant convertToEntityAttribute(Date date) {
            return date == null ? null : Jsr310Converters.DateToInstantConverter.INSTANCE.convert(date);
        }
    }

    @Converter(autoApply=true)
    public static class LocalDateTimeConverter
    implements AttributeConverter<LocalDateTime, Date> {
        @Override
        @Nullable
        public Date convertToDatabaseColumn(LocalDateTime date) {
            return date == null ? null : Jsr310Converters.LocalDateTimeToDateConverter.INSTANCE.convert(date);
        }

        @Override
        @Nullable
        public LocalDateTime convertToEntityAttribute(Date date) {
            return date == null ? null : Jsr310Converters.DateToLocalDateTimeConverter.INSTANCE.convert(date);
        }
    }

    @Converter(autoApply=true)
    public static class LocalTimeConverter
    implements AttributeConverter<LocalTime, Date> {
        @Override
        @Nullable
        public Date convertToDatabaseColumn(LocalTime time) {
            return time == null ? null : Jsr310Converters.LocalTimeToDateConverter.INSTANCE.convert(time);
        }

        @Override
        @Nullable
        public LocalTime convertToEntityAttribute(Date date) {
            return date == null ? null : Jsr310Converters.DateToLocalTimeConverter.INSTANCE.convert(date);
        }
    }

    @Converter(autoApply=true)
    public static class LocalDateConverter
    implements AttributeConverter<LocalDate, Date> {
        @Override
        @Nullable
        public Date convertToDatabaseColumn(LocalDate date) {
            return date == null ? null : Jsr310Converters.LocalDateToDateConverter.INSTANCE.convert(date);
        }

        @Override
        @Nullable
        public LocalDate convertToEntityAttribute(Date date) {
            return date == null ? null : Jsr310Converters.DateToLocalDateConverter.INSTANCE.convert(date);
        }
    }
}

