/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.SpecificationComposition;
import org.springframework.lang.Nullable;

public interface Specification<T>
extends Serializable {
    public static final long serialVersionUID = 1L;

    public static <T> Specification<T> not(@Nullable Specification<T> spec) {
        return spec == null ? (root, query2, builder) -> null : (root, query2, builder) -> builder.not(spec.toPredicate(root, query2, builder));
    }

    public static <T> Specification<T> where(@Nullable Specification<T> spec) {
        return spec == null ? (root, query2, builder) -> null : spec;
    }

    default public Specification<T> and(@Nullable Specification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    default public Specification<T> or(@Nullable Specification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @Nullable
    public Predicate toPredicate(Root<T> var1, CriteriaQuery<?> var2, CriteriaBuilder var3);
}

