/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.Set;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Subgraph;
import org.springframework.data.mapping.PropertyPath;

abstract class EntityGraphFactory {
    public static final String HINT = "javax.persistence.fetchgraph";

    EntityGraphFactory() {
    }

    public static <T> EntityGraph<T> create(EntityManager entityManager, Class<T> domainType, Set<String> properties) {
        EntityGraph<T> entityGraph = entityManager.createEntityGraph(domainType);
        for (String property : properties) {
            Subgraph current = null;
            for (PropertyPath path : PropertyPath.from(property, domainType)) {
                if (path.hasNext()) {
                    current = current == null ? entityGraph.addSubgraph(path.getSegment()) : current.addSubgraph(path.getSegment());
                    continue;
                }
                if (current == null) {
                    entityGraph.addAttributeNodes(path.getSegment());
                    continue;
                }
                current.addAttributeNodes(path.getSegment());
            }
        }
        return entityGraph;
    }
}

