/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.classes.model;

import bld.commons.classes.attributes.ClassType;
import bld.commons.classes.generator.utils.ClassGeneratorUtils;
import bld.commons.classes.model.ModelAnnotation;
import bld.commons.classes.model.ModelComponentClass;
import bld.commons.classes.model.ModelConstructor;
import bld.commons.classes.model.ModelEnumValue;
import bld.commons.classes.model.ModelField;
import bld.commons.classes.model.ModelGenericType;
import bld.commons.classes.model.ModelMethod;
import bld.commons.classes.model.ModelSuperClass;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class ModelClass
implements ModelComponentClass {
    @NotNull(message="The \"name\" field can not be null to define the \"class\" entity")
    @JsonProperty(value="class")
    private @NotNull(message="The \"name\" field can not be null to define the \"class\" entity") String name;
    @NotNull
    private ClassType type;
    @JsonProperty(value="package")
    @NotNull
    private String packageName;
    @JsonProperty(value="extends")
    @Valid
    private Set<ModelSuperClass> extendsClass;
    @JsonProperty(value="implements")
    @Valid
    private Set<ModelSuperClass> implementsClass;
    @Valid
    private Set<ModelAnnotation> annotations;
    @Valid
    private LinkedHashSet<ModelField> fields;
    private Set<String> imports;
    @JsonProperty(value="generic-types")
    private List<ModelGenericType> genericTypes;
    private boolean lombok;
    @JsonProperty(value="abstract")
    private boolean abstractClass;
    @Valid
    private LinkedHashSet<ModelMethod> methods;
    private LinkedHashSet<ModelConstructor> constructors;
    private LinkedHashSet<ModelEnumValue> enumValues;

    public ModelClass() {
        this.init();
    }

    private void init() {
        this.annotations = new HashSet<ModelAnnotation>();
        this.fields = new LinkedHashSet();
        this.imports = new HashSet<String>();
        this.genericTypes = new ArrayList<ModelGenericType>();
        this.extendsClass = new HashSet<ModelSuperClass>();
        this.implementsClass = new HashSet<ModelSuperClass>();
        this.methods = new LinkedHashSet();
        this.lombok = false;
        this.abstractClass = false;
        this.type = ClassType.CLASS;
        this.constructors = new LinkedHashSet();
        this.enumValues = new LinkedHashSet();
    }

    public ModelClass(String name, ClassType type, String packageName) {
        this.name = name;
        this.type = type;
        this.packageName = packageName;
        this.init();
    }

    public void addInterface(ModelSuperClass ... modelSuperClasses) {
        ClassGeneratorUtils.addElements(this.implementsClass, modelSuperClasses);
    }

    public void addExtendsClass(ModelSuperClass ... modelSuperClasses) {
        ClassGeneratorUtils.addElements(this.extendsClass, modelSuperClasses);
    }

    public void addAnnotations(ModelAnnotation ... annotations) {
        ClassGeneratorUtils.addElements(this.annotations, annotations);
    }

    public void addFields(ModelField ... fields) {
        ClassGeneratorUtils.addElements(this.fields, fields);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Set<ModelAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<ModelAnnotation> annotations) {
        this.annotations = annotations;
    }

    public LinkedHashSet<ModelField> getFields() {
        return this.fields;
    }

    public void setFields(LinkedHashSet<ModelField> fields) {
        this.fields = fields;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    public List<ModelGenericType> getGenericTypes() {
        return this.genericTypes;
    }

    public void setGenericTypes(List<ModelGenericType> genericType) {
        this.genericTypes = genericType;
    }

    public Set<ModelSuperClass> getExtendsClass() {
        return this.extendsClass;
    }

    public void setExtendsClass(Set<ModelSuperClass> extendsClass) {
        this.extendsClass = extendsClass;
    }

    public Set<ModelSuperClass> getImplementsClass() {
        return this.implementsClass;
    }

    public void setImplementsClass(Set<ModelSuperClass> implementsClass) {
        this.implementsClass = implementsClass;
    }

    public boolean isLombok() {
        return this.lombok;
    }

    public void setLombok(boolean lombok) {
        this.lombok = lombok;
    }

    public ClassType getType() {
        return this.type;
    }

    public void setType(ClassType type) {
        this.type = type;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public LinkedHashSet<ModelMethod> getMethods() {
        return this.methods;
    }

    public void setMethods(LinkedHashSet<ModelMethod> methods) {
        this.methods = methods;
    }

    public LinkedHashSet<ModelConstructor> getConstructors() {
        return this.constructors;
    }

    public void setConstructors(LinkedHashSet<ModelConstructor> constructors) {
        this.constructors = constructors;
    }

    public LinkedHashSet<ModelEnumValue> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(LinkedHashSet<ModelEnumValue> enumValues) {
        this.enumValues = enumValues;
    }

    public void addImport(String imp) {
        if (StringUtils.isNotBlank(imp)) {
            this.imports.add(imp);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var3_9;
        void var4_14;
        void var3_6;
        String genericType = "";
        for (ModelGenericType modelGenericType : this.genericTypes) {
            genericType = genericType + "," + modelGenericType.toString();
        }
        if (StringUtils.isNotEmpty(genericType)) {
            genericType = "<" + genericType.substring(1) + ">";
        }
        String extend = "";
        for (ModelSuperClass modelSuperClass : this.extendsClass) {
            extend = extend + "," + modelSuperClass.toString();
        }
        if (StringUtils.isNotEmpty(extend)) {
            extend = " extends " + extend.substring(1);
        }
        String string = "";
        for (ModelSuperClass item : this.implementsClass) {
            String string2 = (String)var3_6 + "," + item.toString();
        }
        if (StringUtils.isNotEmpty((CharSequence)var3_6)) {
            String string3 = " implements " + var3_6.substring(1);
        }
        String string4 = "";
        if (this.abstractClass) {
            String string5 = "abstract";
        }
        return "public " + (String)var4_14 + " " + this.type.name().toLowerCase() + " " + this.name + genericType + "" + extend + "" + (String)var3_9;
    }
}

