/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.reflection.utils;

import bld.commons.reflection.annotations.ConditionsZones;
import bld.commons.reflection.annotations.DateFilter;
import bld.commons.reflection.annotations.FieldMapping;
import bld.commons.reflection.annotations.FilterNullValue;
import bld.commons.reflection.annotations.IgnoreMapping;
import bld.commons.reflection.annotations.IgnoreResultSet;
import bld.commons.reflection.annotations.LikeString;
import bld.commons.reflection.annotations.ListFilter;
import bld.commons.reflection.annotations.ResultMapping;
import bld.commons.reflection.model.BaseParameter;
import bld.commons.reflection.model.NativeQueryParameter;
import bld.commons.reflection.model.QueryParameter;
import bld.commons.reflection.type.GetSetType;
import com.bld.commons.utils.CamelCaseUtils;
import com.bld.commons.utils.DateUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jpa.TypedParameterValue;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ReflectionCommons {
    public static final String PK = "PK";
    @Autowired
    private ApplicationContext applicationContext;
    private static final Log logger = LogFactory.getLog(ReflectionCommons.class);
    public static final String SERVICE_IMPL = "ServiceImpl";
    public static final String UPDATE = "update";
    public static final String SAVE = "save";
    public static final Map<Class<?>, Class<?>> mapPrimitiveToObject = ReflectionCommons.mapFromPrimitiveToObject();
    public static final Map<Class<?>, Type> mapType = ReflectionCommons.getMapType();
    private static final Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public void saveGeneric(Object valore, Class<?> classCampoDestinatario) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String nomeClasse = classCampoDestinatario.getSimpleName();
        String nomeClasseServiceImpl = ReflectionCommons.getBeanName(nomeClasse, SERVICE_IMPL);
        Object oggettoServiceImpl = this.applicationContext.getBean(nomeClasseServiceImpl);
        Method metodo = oggettoServiceImpl.getClass().getMethod(SAVE, valore.getClass());
        metodo.invoke(oggettoServiceImpl, valore);
    }

    private static Map<Class<?>, Type> getMapType() {
        HashMap map = new HashMap();
        map.put(Boolean.class, StandardBasicTypes.BOOLEAN);
        map.put(String.class, StandardBasicTypes.STRING);
        map.put(Long.class, StandardBasicTypes.LONG);
        map.put(BigInteger.class, StandardBasicTypes.BIG_INTEGER);
        map.put(Integer.class, StandardBasicTypes.INTEGER);
        map.put(Short.class, StandardBasicTypes.SHORT);
        map.put(BigDecimal.class, StandardBasicTypes.BIG_DECIMAL);
        map.put(Double.class, StandardBasicTypes.DOUBLE);
        map.put(Float.class, StandardBasicTypes.FLOAT);
        map.put(Byte.class, StandardBasicTypes.BYTE);
        map.put(Character.class, StandardBasicTypes.CHARACTER);
        map.put(Date.class, StandardBasicTypes.DATE);
        map.put(Calendar.class, StandardBasicTypes.CALENDAR);
        map.put(Locale.class, StandardBasicTypes.LOCALE);
        map.put(TimeZone.class, StandardBasicTypes.TIMEZONE);
        map.put(Clob.class, StandardBasicTypes.CLOB);
        map.put(Blob.class, StandardBasicTypes.BLOB);
        return map;
    }

    private static Map<Class<?>, Class<?>> mapFromPrimitiveToObject() {
        HashMap map = new HashMap();
        map.put(Integer.TYPE, Integer.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        map.put(Void.TYPE, Void.class);
        return map;
    }

    public <T, ID> QueryParameter<T, ID> dataToMap(QueryParameter<T, ID> queryParameter) {
        BaseParameter obj = queryParameter.getBaseParameter();
        if (obj != null) {
            Set<Field> fields = ReflectionCommons.getListField(obj.getClass());
            Map<String, LinkedHashSet<Method>> mapMethod = ReflectionCommons.getMapMethod(obj.getClass());
            for (Field field : fields) {
                IgnoreMapping ignoreMapping;
                Method method = ReflectionCommons.getMethod(mapMethod, field, GetSetType.get, new Class[0]);
                if (method == null) continue;
                IgnoreMapping ignoreMapping2 = ignoreMapping = method.isAnnotationPresent(IgnoreMapping.class) ? method.getAnnotation(IgnoreMapping.class) : field.getAnnotation(IgnoreMapping.class);
                if (ignoreMapping != null && ignoreMapping.value()) continue;
                try {
                    Object value = PropertyUtils.getProperty(obj, field.getName());
                    if (value instanceof Collection && CollectionUtils.isEmpty((Collection)value)) {
                        value = null;
                    }
                    if (value != null && value instanceof String && StringUtils.isBlank((String)value)) {
                        value = null;
                    }
                    if (value != null) {
                        if ((value = this.getValue(field, method, value)) instanceof Boolean && ((Boolean)value).booleanValue() && field.isAnnotationPresent(ListFilter.class)) {
                            queryParameter.addNullable(field.getName());
                            continue;
                        }
                        if (value.getClass().isArray()) {
                            Object[] array = (Object[])value;
                            queryParameter.addParameter(field.getName(), Arrays.asList(array));
                            continue;
                        }
                        queryParameter.addParameter(field.getName(), value);
                        continue;
                    }
                    if ((!field.isAnnotationPresent(FilterNullValue.class) || !field.getAnnotation(FilterNullValue.class).value()) && (!method.isAnnotationPresent(FilterNullValue.class) || !method.getAnnotation(FilterNullValue.class).value())) continue;
                    queryParameter.addParameter(field.getName(), new TypedParameterValue(mapType.get(field.getType()), value));
                }
                catch (Exception e) {
                    logger.warn("Error converting data to map");
                }
            }
        }
        return queryParameter;
    }

    private Object getValue(Field field, Method method, Object value) {
        DateFilter dateFilter = method.isAnnotationPresent(DateFilter.class) ? method.getAnnotation(DateFilter.class) : field.getAnnotation(DateFilter.class);
        LikeString likeString = method.isAnnotationPresent(LikeString.class) ? method.getAnnotation(LikeString.class) : field.getAnnotation(LikeString.class);
        return this.getValue(value, dateFilter, likeString);
    }

    public Object getValue(Object value, DateFilter dateFilter, LikeString likeString) {
        if (dateFilter != null) {
            if (value instanceof Calendar) {
                value = DateUtils.sumDate((Calendar)value, dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
            } else if (value instanceof Date) {
                value = DateUtils.sumDate((Date)value, dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
            } else if (value instanceof Timestamp) {
                value = DateUtils.sumDate((Timestamp)value, dateFilter.addYear(), dateFilter.addMonth(), dateFilter.addWeek(), dateFilter.addDay(), dateFilter.addHour(), dateFilter.addMinute(), dateFilter.addSecond());
            }
        } else if (likeString != null && value instanceof String) {
            switch (likeString.likeType()) {
                case LEFT_RIGHT: {
                    value = "%" + value + "%";
                    break;
                }
                case NONE: {
                    break;
                }
                case LEFT: {
                    value = "%" + value;
                    break;
                }
                case RIGHT: {
                    value = value + "%";
                    break;
                }
                default: {
                    value = "%" + value + "%";
                }
            }
            switch (likeString.upperLowerType()) {
                case LOWER: {
                    value = ((String)value).toLowerCase();
                    break;
                }
                case UPPER: {
                    value = ((String)value).toUpperCase();
                    break;
                }
            }
        }
        return value;
    }

    public <T, ID> NativeQueryParameter<T, ID> dataToMap(NativeQueryParameter<T, ID> queryParameter) {
        BaseParameter obj = queryParameter.getBaseParameter();
        if (obj != null) {
            Set<Field> fields = ReflectionCommons.getListField(obj.getClass());
            Map<String, LinkedHashSet<Method>> mapMethod = ReflectionCommons.getMapMethod(obj.getClass());
            for (Field field : fields) {
                IgnoreMapping ignoreMapping;
                Method method = ReflectionCommons.getMethod(mapMethod, field, GetSetType.get, new Class[0]);
                if (method == null) continue;
                IgnoreMapping ignoreMapping2 = ignoreMapping = method.isAnnotationPresent(IgnoreMapping.class) ? method.getAnnotation(IgnoreMapping.class) : field.getAnnotation(IgnoreMapping.class);
                if (ignoreMapping != null && ignoreMapping.value()) continue;
                try {
                    ConditionsZones conditionsZones;
                    Object value = PropertyUtils.getProperty(obj, field.getName());
                    ConditionsZones conditionsZones2 = conditionsZones = method.isAnnotationPresent(ConditionsZones.class) ? method.getAnnotation(ConditionsZones.class) : field.getAnnotation(ConditionsZones.class);
                    if (value instanceof Collection && CollectionUtils.isEmpty((Collection)value)) {
                        value = null;
                    }
                    if (value != null && value instanceof String && StringUtils.isBlank((String)value)) {
                        value = null;
                    }
                    if (value != null) {
                        if ((value = this.getValue(field, method, value)) instanceof Boolean && ((Boolean)value).booleanValue() && field.isAnnotationPresent(ListFilter.class)) {
                            queryParameter.addNullable(field.getName(), conditionsZones);
                            continue;
                        }
                        if (value.getClass().isArray()) {
                            Object[] array = (Object[])value;
                            queryParameter.addParameter(field.getName(), Arrays.asList(array), conditionsZones);
                            continue;
                        }
                        queryParameter.addParameter(field.getName(), value, conditionsZones);
                        continue;
                    }
                    if (field.isAnnotationPresent(FilterNullValue.class) && field.getAnnotation(FilterNullValue.class).value() || method.isAnnotationPresent(FilterNullValue.class) && method.getAnnotation(FilterNullValue.class).value()) {
                        queryParameter.addParameter(field.getName(), new TypedParameterValue(mapType.get(field.getType()), value), conditionsZones);
                        continue;
                    }
                    if (conditionsZones == null) continue;
                    queryParameter.addEmptyZones(conditionsZones);
                }
                catch (Exception e) {
                    logger.warn("Error converting data to map");
                }
            }
        }
        return queryParameter;
    }

    public <T> T reflection(Class<T> classT, Map<String, Object> mapResult) {
        HashMap<String, Object> mapRow = new HashMap<String, Object>();
        BeanUtilsBean beanUtils = new BeanUtilsBean(new ConvertUtilsBean(){

            public Object convert(String value, Class clazz) {
                if (clazz.isEnum()) {
                    return Enum.valueOf(clazz, value);
                }
                return super.convert(value, clazz);
            }
        });
        beanUtils.getConvertUtils().register(false, false, 0);
        for (String keyResult : mapResult.keySet()) {
            String nameField = CamelCaseUtils.camelCase(keyResult, true);
            mapRow.put(nameField, mapResult.get(keyResult));
        }
        T t = null;
        try {
            t = this.mapResultSet(classT, mapRow, beanUtils);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    private <T> T mapResultSet(Class<T> classT, Map<String, Object> mapRow, BeanUtilsBean beanUtils) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        T t = classT.getConstructor(new Class[0]).newInstance(new Object[0]);
        Set<Field> fields = ReflectionCommons.getListField(classT);
        boolean isEmpty = true;
        for (Field field : fields) {
            if (field.isAnnotationPresent(IgnoreResultSet.class)) continue;
            Object value = null;
            if (field.isAnnotationPresent(ResultMapping.class)) {
                value = this.mapResultSet(field.getType(), mapRow, beanUtils);
                if (value == null) continue;
                isEmpty = false;
                beanUtils.setProperty(t, field.getName(), value);
                continue;
            }
            String key = field.getName();
            if (field.isAnnotationPresent(FieldMapping.class)) {
                key = field.getAnnotation(FieldMapping.class).value();
            }
            if (!mapRow.containsKey(key) || (value = mapRow.get(key)) == null) continue;
            isEmpty = false;
            beanUtils.setProperty(t, field.getName(), value);
        }
        if (isEmpty) {
            return null;
        }
        return t;
    }

    public static String getBeanName(String nomeClasse, String rightConcat) {
        nomeClasse = Character.toLowerCase(nomeClasse.charAt(0)) + nomeClasse.substring(1);
        rightConcat = rightConcat != null ? rightConcat : "";
        return nomeClasse + rightConcat;
    }

    public static Object checkEmpty(Object obj) {
        HashSet<Field> campi = new HashSet<Field>(Arrays.asList(obj.getClass().getDeclaredFields()));
        for (Field f : campi) {
            try {
                Object value = PropertyUtils.getProperty(obj, f.getName());
                if (value == null) continue;
                return obj;
            }
            catch (Exception e) {
                logger.warn("-XXX- errore durante la lettura del campo -XXX");
                logger.warn(ExceptionUtils.getStackTrace(e));
            }
        }
        return null;
    }

    public static <T> Class<T> getGenericTypeClass(Object entity) {
        return ReflectionCommons.getGenericTypeClass(entity.getClass(), 0);
    }

    public static <T> Class<T> getGenericTypeClass(Class<?> clazz) {
        return ReflectionCommons.getGenericTypeClass(clazz, 0);
    }

    public static <T> Class<T> getGenericTypeClass(Class<?> clazz, int i) {
        ParameterizedType parameterizedType = null;
        try {
            parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        }
        catch (Exception e) {
            parameterizedType = (ParameterizedType)clazz.getSuperclass().getGenericSuperclass();
        }
        Class clazzType = (Class)parameterizedType.getActualTypeArguments()[i];
        return clazzType;
    }

    public static <T> Class<T> getGenericTypeClass(Object entity, int i) {
        return ReflectionCommons.getGenericTypeClass(entity.getClass(), i);
    }

    public static <T> Class<T> getGenericTypeField(Field field) {
        return ReflectionCommons.getGenericTypeField(field, 0);
    }

    public static <T> Class<T> getGenericTypeField(Field field, int i) {
        ParameterizedType parameterizedType = null;
        parameterizedType = (ParameterizedType)field.getGenericType();
        Class clazz = (Class)parameterizedType.getActualTypeArguments()[i];
        return clazz;
    }

    public static String removeExtraSpace(String join) {
        if ((join = join.trim()).contains("  ")) {
            join = ReflectionCommons.removeExtraSpace(join.replace("  ", " "));
        }
        return join;
    }

    public static Set<Field> getListField(Class<?> classApp) {
        HashSet<Field> listField = new HashSet<Field>();
        do {
            for (Field field : classApp.getDeclaredFields()) {
                if (listField.contains(field)) continue;
                listField.add(field);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return listField;
    }

    public static Set<Field> getListField(Class<?> classApp, Class<? extends Annotation> annotation) {
        HashSet<Field> listField = new HashSet<Field>();
        HashSet<Field> skipField = new HashSet<Field>();
        do {
            for (Field field : classApp.getDeclaredFields()) {
                if (field.isAnnotationPresent(annotation) && !skipField.contains(field)) {
                    listField.add(field);
                }
                skipField.add(field);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return listField;
    }

    public static Map<String, Field> getMapField(Class<?> classApp) {
        HashMap<String, Field> mapField = new HashMap<String, Field>();
        do {
            for (Field field : classApp.getDeclaredFields()) {
                if (mapField.containsKey(field.getName())) continue;
                mapField.put(field.getName(), field);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return mapField;
    }

    public static Map<String, LinkedHashSet<Method>> getMapMethod(Class<?> classApp) {
        HashMap<String, LinkedHashSet<Method>> mapMethod = new HashMap<String, LinkedHashSet<Method>>();
        do {
            for (Method method : classApp.getMethods()) {
                if (!mapMethod.containsKey(method.getName())) {
                    mapMethod.put(method.getName(), new LinkedHashSet());
                }
                ((LinkedHashSet)mapMethod.get(method.getName())).add(method);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return mapMethod;
    }

    public static Set<Method> methods(Class<?> classApp) {
        HashSet<Method> methods = new HashSet<Method>();
        do {
            for (Method method : classApp.getMethods()) {
                if (methods.contains(method)) continue;
                methods.add(method);
            }
        } while ((classApp = classApp.getSuperclass()) != null && !classApp.getName().equals(Object.class.getName()));
        return methods;
    }

    public static Method getMethod(Map<String, LinkedHashSet<Method>> mapMethod, String methodName, Class<?> ... classParameter) {
        Set methods = mapMethod.get(methodName);
        if (CollectionUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                Object[] parameterTypes = method.getParameterTypes();
                if (ArrayUtils.isEmpty(parameterTypes) && ArrayUtils.isEmpty(classParameter)) {
                    return method;
                }
                boolean check = true;
                if (!ArrayUtils.isNotEmpty(parameterTypes) || !ArrayUtils.isNotEmpty(classParameter) || parameterTypes.length != classParameter.length) continue;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (((Class)parameterTypes[i]).isAssignableFrom(classParameter[i])) continue;
                    check = false;
                    break;
                }
                if (!check) continue;
                return method;
            }
        }
        return null;
    }

    public static Method getMethod(Map<String, LinkedHashSet<Method>> mapMethod, Field field, GetSetType getSetType, Class<?> ... classParameter) {
        String methodName = getSetType.name() + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
        return ReflectionCommons.getMethod(mapMethod, methodName, classParameter);
    }

    public static Set<String> variablesInText(String input) {
        Matcher matcher = pattern.matcher(input);
        HashSet<String> variables = new HashSet<String>();
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }
}

