/*
 * Decompiled with CFR 0.152.
 */
package bld.commons.service;

import bld.commons.exception.JpaServiceException;
import bld.commons.exception.OrderByException;
import bld.commons.reflection.model.BuildJpqlQueryParameter;
import bld.commons.reflection.model.BuildNativeQueryParameter;
import bld.commons.reflection.model.ConditionsZoneModel;
import bld.commons.reflection.model.NativeQueryParameter;
import bld.commons.reflection.model.OrderBy;
import bld.commons.reflection.model.QueryParameter;
import bld.commons.reflection.utils.ReflectionCommons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseJpaService<T, ID> {
    public static final String JOIN_ZONE = "joinZone";
    private static final String END_LINE = "\n";
    private Class<T> classEntity = ReflectionCommons.getGenericTypeClass(this);
    private Class<ID> classId = ReflectionCommons.getGenericTypeClass(this, 1);
    private static final String fetch = "(?i)fetch";
    private static final Log logger = LogFactory.getLog(BaseJpaService.class);
    private static final String ORDER_BY = " order by ";
    public static final CharSequence ONE_TO_MANY = "<ONE_TO_MANY>";
    public static final String KEY_PROPERTY = "<PROPERTY>";
    public static final String WHERE_CONDITION = "\nWHERE ";
    private Map<String, LinkedHashSet<String>> mapOneToMany;
    @Autowired
    protected ReflectionCommons reflectionCommons;

    protected abstract EntityManager getEntityManager();

    protected void setMapOneToMany(Map<String, LinkedHashSet<String>> mapOneToMany) {
        this.mapOneToMany = mapOneToMany;
    }

    protected Map<String, LinkedHashSet<String>> getMapOneToMany() {
        return this.mapOneToMany;
    }

    protected Class<T> getClassEntity() {
        return this.classEntity;
    }

    private <Q extends Query> void setQueryParameters(Map<String, Object> mapParameters, Q query) {
        for (Map.Entry<String, Object> entry : mapParameters.entrySet()) {
            Object value = entry.getValue();
            logger.debug("----------------------------------------------------------");
            logger.debug("Key: " + entry.getKey());
            logger.debug("Value: " + value);
            if (value != null) {
                logger.debug("Class: " + value.getClass().getName());
            }
            query.setParameter(entry.getKey(), entry.getValue());
        }
    }

    private void getWhereCondition(Map<String, Object> mapParameters, StringBuilder where, Map<String, String> mapConditions) {
        for (String key : mapParameters.keySet()) {
            this.setCondition(where, mapConditions, key);
        }
    }

    private void setCondition(StringBuilder where, Map<String, String> mapConditions, String key) {
        String condition = mapConditions.get(key);
        if (StringUtils.isBlank(condition)) {
            throw new JpaServiceException("The \"" + key + "\" parameter is not mappend in condition");
        }
        where.append(condition);
    }

    private void getWhereCondition(Set<String> nullables, StringBuilder where, Map<String, String> mapConditions) {
        if (nullables != null) {
            for (String key : nullables) {
                this.setCondition(where, mapConditions, key);
            }
        }
    }

    public void deleteByFilter(BuildJpqlQueryParameter<T, ID> buildQueryFilter) {
        QueryParameter queryFilter = (QueryParameter)buildQueryFilter.getQueryParameter();
        StringBuilder sql = buildQueryFilter.getSql();
        this.buildWhere(buildQueryFilter, sql);
        String delete = sql.toString();
        logger.debug("Query= " + delete);
        Query query = this.getEntityManager().createQuery(delete);
        this.setQueryParameters(queryFilter.getParameters(), query);
        query.executeUpdate();
    }

    public List<ID> findIdByFilter(BuildJpqlQueryParameter<T, ID> buildQueryFilter) {
        TypedQuery<ID> query = this.buildQuery(buildQueryFilter, this.classId, true);
        return query.getResultList();
    }

    public List<T> findByFilter(BuildJpqlQueryParameter<T, ID> buildQueryFilter) {
        TypedQuery<T> query = this.buildQuery(buildQueryFilter, this.classEntity, false);
        return query.getResultList();
    }

    private <J> TypedQuery<J> buildQuery(BuildJpqlQueryParameter<T, ID> buildQueryFilter, Class<J> clazz, boolean removeFetch) {
        QueryParameter queryFilter = (QueryParameter)buildQueryFilter.getQueryParameter();
        Map<String, Object> mapParameters = queryFilter.getParameters();
        ManageOneToMany manageOneToMany = this.addRelationshipsOneToMany(mapParameters, buildQueryFilter.getSql(), queryFilter.getNullables());
        StringBuilder sql = manageOneToMany.getSelect();
        this.buildWhere(buildQueryFilter, sql);
        this.addOrderBy(queryFilter.getListOrderBy(), sql, buildQueryFilter.getMapOrders());
        String select = sql.toString();
        if (removeFetch) {
            select = select.replaceAll(fetch, "");
        }
        logger.debug("\nQuery: \n" + select);
        TypedQuery<J> query = this.getEntityManager().createQuery(select, clazz);
        this.setQueryParameters(mapParameters, query);
        if (manageOneToMany.isOneToMany()) {
            query.setHint("hibernate.query.passDistinctThrough", false);
        }
        if (queryFilter.getPageable() != null) {
            query.setFirstResult(queryFilter.getPageable().getPageNumber() * queryFilter.getPageable().getPageSize());
            query.setMaxResults(queryFilter.getPageable().getPageSize());
        }
        return query;
    }

    private void buildWhere(BuildJpqlQueryParameter<T, ID> buildQueryFilter, StringBuilder sql) {
        QueryParameter queryFilter = (QueryParameter)buildQueryFilter.getQueryParameter();
        StringBuilder where = new StringBuilder("");
        this.getWhereCondition(queryFilter.getNullables(), where, buildQueryFilter.getMapConditions());
        this.getWhereCondition(queryFilter.getParameters(), where, buildQueryFilter.getMapConditions());
        if (where.length() > 0) {
            sql.append("where\n").append(where.substring(4));
        }
    }

    private void addOrderBy(List<OrderBy> listOrderBy, StringBuilder sql, Map<String, String> mapOrders) {
        if (!sql.toString().toLowerCase().contains(ORDER_BY.trim()) && CollectionUtils.isNotEmpty(listOrderBy)) {
            StringBuilder writeOrderBy = new StringBuilder("");
            int substring = 0;
            if (CollectionUtils.isNotEmpty(listOrderBy)) {
                for (OrderBy orderBy : listOrderBy) {
                    if (!mapOrders.containsKey(orderBy.getSortKey())) {
                        throw new OrderByException("The \"" + orderBy.getSortKey() + "\" sort key is not found");
                    }
                    writeOrderBy.append(",").append(mapOrders.get(orderBy.getSortKey())).append(" ").append(orderBy.getOrderType().name());
                }
                substring = 1;
            }
            sql.append(END_LINE).append(ORDER_BY).append(writeOrderBy.substring(substring));
        }
    }

    private ManageOneToMany addRelationshipsOneToMany(Map<String, Object> mapParameters, StringBuilder select, Set<String> nullables) {
        StringBuilder innerJoin = new StringBuilder("");
        if (nullables == null) {
            nullables = new HashSet<String>();
        }
        HashSet<String> listJoin = new HashSet<String>();
        for (String key : this.mapOneToMany.keySet()) {
            if (!mapParameters.containsKey(key) && !nullables.contains(key)) continue;
            Set joins = this.mapOneToMany.get(key);
            for (String join : joins) {
                if (listJoin.contains(join = ReflectionCommons.removeExtraSpace(join))) continue;
                listJoin.add(join);
                innerJoin.append(END_LINE).append(join);
            }
        }
        select.append((CharSequence)innerJoin).append(END_LINE);
        ManageOneToMany manageOneToMany = new ManageOneToMany(select, listJoin.size() > 0);
        return manageOneToMany;
    }

    public Long countByFilter(BuildJpqlQueryParameter<T, ID> buildQueryFilter) {
        QueryParameter queryFilter = (QueryParameter)buildQueryFilter.getQueryParameter();
        ManageOneToMany manageOneToMany = this.addRelationshipsOneToMany(queryFilter.getParameters(), buildQueryFilter.getSql(), queryFilter.getNullables());
        StringBuilder sql = manageOneToMany.getSelect();
        this.buildWhere(buildQueryFilter, sql);
        String count = sql.toString().replaceAll(fetch, "");
        logger.debug("\nQuery: \n" + count);
        TypedQuery<Long> query = this.getEntityManager().createQuery(count, Long.class);
        this.setQueryParameters(queryFilter.getParameters(), query);
        return (Long)query.getSingleResult();
    }

    public T findSingleResultByFilter(BuildJpqlQueryParameter<T, ID> buildQueryFilter) {
        TypedQuery<T> query = this.buildQuery(buildQueryFilter, this.classEntity, false);
        T t = null;
        try {
            t = query.getSingleResult();
        }
        catch (Exception e) {
            logger.info("Record not found");
        }
        return t;
    }

    public T findById(BuildJpqlQueryParameter<T, ID> buildQueryFilter) {
        QueryParameter queryFilter = (QueryParameter)buildQueryFilter.getQueryParameter();
        queryFilter.getParameters().put("id", queryFilter.getId());
        return this.findSingleResultByFilter(buildQueryFilter);
    }

    public <K> List<K> findByFilter(BuildNativeQueryParameter<K, ID> buildQueryFilter) {
        StringBuilder sql = this.buildNativeQuery(buildQueryFilter);
        this.addOrderBy(((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getListOrderBy(), sql, buildQueryFilter.getMapOrders());
        String select = sql.toString();
        logger.debug(select);
        Query query = this.getEntityManager().createNativeQuery(select, Tuple.class);
        this.setNativeQueryParameters(((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getMapConditionsZone(), query);
        if (((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getPageable() != null) {
            query.setFirstResult(((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getPageable().getPageNumber() * ((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getPageable().getPageSize());
            query.setMaxResults(((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getPageable().getPageSize());
        }
        List results = query.getResultList();
        ArrayList listK = new ArrayList();
        for (Tuple row : results) {
            List<TupleElement<?>> elements = row.getElements();
            HashMap<String, Object> mapRow = new HashMap<String, Object>();
            for (TupleElement<?> element : elements) {
                Object value = row.get(element.getAlias());
                if (value == null) continue;
                mapRow.put(element.getAlias(), value);
            }
            Object k = this.reflectionCommons.reflection(((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getResultClass(), mapRow);
            listK.add(k);
        }
        return listK;
    }

    private <Q extends Query> void setNativeQueryParameters(Map<String, ConditionsZoneModel> mapZone, Q query) {
        for (ConditionsZoneModel zone : mapZone.values()) {
            for (Map.Entry<String, Object> entry : zone.getParameters().entrySet()) {
                logger.debug("Parameter: " + entry.getKey() + "= " + entry.getValue());
                logger.debug("Class: " + (entry.getValue() != null ? entry.getValue().getClass().getName() : " null"));
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public <K> Long nativeQueryCountByFilter(BuildNativeQueryParameter<K, ID> buildQueryFilter) {
        StringBuilder sql = this.buildNativeQuery(buildQueryFilter);
        String count = sql.toString();
        logger.debug(count);
        Query query = this.getEntityManager().createNativeQuery(count);
        this.setNativeQueryParameters(((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getMapConditionsZone(), query);
        Number size = (Number)query.getSingleResult();
        return size.longValue();
    }

    private <K> StringBuilder buildNativeQuery(BuildNativeQueryParameter<K, ID> buildQueryFilter) {
        StringBuilder sql = buildQueryFilter.getSql();
        Set<String> zones = ReflectionCommons.variablesInText(sql.toString());
        HashMap<String, ConditionsZoneModel> map = new HashMap<String, ConditionsZoneModel>(((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getMapConditionsZone());
        map.remove(JOIN_ZONE);
        Map<String, StringBuilder> mapConditions = ((NativeQueryParameter)buildQueryFilter.getQueryParameter()).getEmptyZones();
        for (String key : map.keySet()) {
            ConditionsZoneModel conditionsZoneModel = (ConditionsZoneModel)map.get(key);
            Map conditions = (Map)buildQueryFilter.getMapConditions().get(key);
            if (!mapConditions.containsKey(key)) {
                mapConditions.put(key, new StringBuilder(conditionsZoneModel.getWhere()));
            }
            for (String parameter : conditionsZoneModel.getParameters().keySet()) {
                mapConditions.get(key).append((String)conditions.get(parameter)).append(END_LINE);
            }
            for (String nullable : conditionsZoneModel.getNullables()) {
                mapConditions.get(key).append((String)conditions.get(nullable)).append(END_LINE);
            }
        }
        StringSubstitutor stringSubstitutor = new StringSubstitutor(mapConditions);
        sql = new StringBuilder(stringSubstitutor.replace(sql));
        for (String zone : zones) {
            zone = "${" + zone + "}";
            int startIndex = sql.indexOf(zone);
            if (startIndex < 0) continue;
            int endIndex = startIndex + zone.length();
            sql = sql.replace(startIndex, endIndex, "");
        }
        return sql;
    }

    private class ManageOneToMany {
        private StringBuilder select;
        private boolean oneToMany;

        private ManageOneToMany(StringBuilder select, boolean oneToMany) {
            this.select = select;
            this.oneToMany = oneToMany;
        }

        public StringBuilder getSelect() {
            return this.select;
        }

        public boolean isOneToMany() {
            return this.oneToMany;
        }
    }
}

